/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.upgrade_aquatic.client.renderer.entity.jellyfish;

import com.mojang.blaze3d.vertex.PoseStack;
import com.teamabnormals.upgrade_aquatic.client.model.jellyfish.CassiopeaJellyfishModel;
import com.teamabnormals.upgrade_aquatic.client.renderer.entity.jellyfish.AbstractJellyfishRenderer;
import com.teamabnormals.upgrade_aquatic.client.renderer.entity.jellyfish.layers.JellyfishEmissiveLayer;
import com.teamabnormals.upgrade_aquatic.common.entity.animal.jellyfish.CassiopeaJellyfish;
import com.teamabnormals.upgrade_aquatic.core.UpgradeAquatic;
import com.teamabnormals.upgrade_aquatic.core.other.UAModelLayers;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class CassiopeaJellyfishRenderer
extends AbstractJellyfishRenderer<CassiopeaJellyfish> {
    public CassiopeaJellyfishRenderer(EntityRendererProvider.Context context) {
        super(context, new CassiopeaJellyfishModel(context.bakeLayer(UAModelLayers.CASSIOPEA_JELLYFISH)), 0.25f);
        this.addLayer(new JellyfishEmissiveLayer(this, this));
    }

    public void render(CassiopeaJellyfish jellyfish, float entityYaw, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn) {
        this.shadowRadius *= jellyfish.getSize();
        super.render((LivingEntity)jellyfish, entityYaw, partialTicks, matrixStackIn, bufferIn, packedLightIn);
    }

    public ResourceLocation getTextureLocation(CassiopeaJellyfish jellyfish) {
        return UpgradeAquatic.location("textures/entity/jellyfish/cassiopea/" + jellyfish.getVariantName() + "_jellyfish.png");
    }

    @Override
    public ResourceLocation getOverlayTexture(CassiopeaJellyfish jellyfish) {
        return UpgradeAquatic.location("textures/entity/jellyfish/cassiopea/" + jellyfish.getVariantName() + "_jellyfish_overlay.png");
    }

    protected RenderType getRenderType(CassiopeaJellyfish jellyfish, boolean p_230496_2_, boolean p_230496_3_, boolean p_230496_4_) {
        return RenderType.entityTranslucent((ResourceLocation)this.getTextureLocation(jellyfish));
    }

    protected void scale(CassiopeaJellyfish jellyfish, PoseStack matrixStack, float partialTickTime) {
        float size = jellyfish.getSize();
        matrixStack.scale(size, size, size);
    }
}

