/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.upgrade_aquatic.client.renderer.entity;

import com.teamabnormals.upgrade_aquatic.client.model.GooseModel;
import com.teamabnormals.upgrade_aquatic.common.entity.animal.Goose;
import com.teamabnormals.upgrade_aquatic.core.UpgradeAquatic;
import com.teamabnormals.upgrade_aquatic.core.other.UAModelLayers;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class GooseRenderer
extends MobRenderer<Goose, GooseModel<Goose>> {
    public GooseRenderer(EntityRendererProvider.Context context) {
        super(context, new GooseModel(context.bakeLayer(UAModelLayers.GOOSE)), 0.25f);
    }

    public ResourceLocation getTextureLocation(Goose entity) {
        return UpgradeAquatic.location("textures/entity/goose.png");
    }

    protected float getBob(Goose livingBase, float partialTicks) {
        float f = Mth.lerp((float)partialTicks, (float)livingBase.oFlap, (float)livingBase.flap);
        float f1 = Mth.lerp((float)partialTicks, (float)livingBase.oFlapSpeed, (float)livingBase.flapSpeed);
        return (Mth.sin((float)f) + 1.0f) * f1;
    }
}

