/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.upgrade_aquatic.client.particle;

import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class SpectralConsumeParticle
extends TextureSheetParticle {
    protected final SpriteSet animatedSprite;
    private final float scale = this.quadSize = this.random.nextFloat() * 0.6f + 0.2f;
    private final int MAX_FRAME_ID = 3;
    protected int currentFrame = 0;
    private boolean directionRight = true;
    private int lastTick = 0;

    public SpectralConsumeParticle(SpriteSet animatedSprite, ClientLevel world, double posX, double posY, double posZ, double motionX, double motionY, double motionZ) {
        super(world, posX, posY, posZ, motionX, motionY, motionZ);
        this.rCol = 1.0f;
        this.gCol = 1.0f;
        this.bCol = 1.0f;
        this.xd = motionX * (double)0.2f + (Math.random() * 2.0 - 1.0) * (double)0.01f;
        this.yd = motionY * (double)0.2f + (Math.random() * 2.0 - 1.0) * (double)0.01f;
        this.zd = motionZ * (double)0.2f + (Math.random() * 2.0 - 1.0) * (double)0.01f;
        this.lifetime = (int)(8.0 / (Math.random() * 0.8 + 0.2));
        this.animatedSprite = animatedSprite;
        this.setSpriteFromAge(animatedSprite);
    }

    public void render(VertexConsumer p_225606_1_, Camera activeInfo, float partialTicks) {
        Entity entity = activeInfo.getEntity();
        if (entity.tickCount >= this.lastTick + 5) {
            if (this.currentFrame == 3) {
                this.directionRight = false;
            } else if (this.currentFrame == 0) {
                this.directionRight = true;
            }
            this.currentFrame += this.directionRight ? 1 : -1;
            this.lastTick = entity.tickCount;
        }
        float f = ((float)this.age + partialTicks) / (float)this.lifetime;
        this.quadSize = this.scale * (1.0f - f * f * 0.5f);
        super.render(p_225606_1_, activeInfo, partialTicks);
    }

    public void tick() {
        super.tick();
        this.oRoll = this.roll;
        if (this.isAlive()) {
            this.setSpriteFromAge(this.animatedSprite);
        }
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_OPAQUE;
    }

    public int getLightColor(float partialTick) {
        float f = ((float)this.age + partialTick) / (float)this.lifetime;
        f = Mth.clamp((float)f, (float)0.0f, (float)1.0f);
        int i = super.getLightColor(partialTick);
        int j = i & 0xFF;
        int k = i >> 16 & 0xFF;
        if ((j += (int)(f * 15.0f * 16.0f)) > 240) {
            j = 240;
        }
        return j | k << 16;
    }

    public static class Factory
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet animatedSprite;

        public Factory(SpriteSet animatedSprite) {
            this.animatedSprite = animatedSprite;
        }

        public Particle createParticle(SimpleParticleType type, ClientLevel world, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            return new SpectralConsumeParticle(this.animatedSprite, world, x, y, z, xSpeed, ySpeed, zSpeed);
        }
    }
}

