/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.upgrade_aquatic.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.teamabnormals.blueprint.core.endimator.Endimator;
import com.teamabnormals.blueprint.core.endimator.entity.EndimatorEntityModel;
import com.teamabnormals.upgrade_aquatic.common.entity.monster.Thrasher;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;

public class ThrasherModel<E extends Thrasher>
extends EndimatorEntityModel<E> {
    public ModelPart neck;
    public ModelPart body;
    public ModelPart top_jaw;
    public ModelPart bottom_jaw;
    public ModelPart left_fin;
    public ModelPart right_fin;
    public ModelPart fin;
    public ModelPart tail_holder;
    public ModelPart right_fin_2;
    public ModelPart left_fin_2;
    public ModelPart tail_holder_2;
    public ModelPart tail;
    public ModelPart tail_linear;

    public ThrasherModel(ModelPart root) {
        this.neck = root.getChild("neck");
        this.body = this.neck.getChild("body");
        this.top_jaw = this.neck.getChild("top_jaw");
        this.bottom_jaw = this.neck.getChild("bottom_jaw");
        this.left_fin = this.neck.getChild("left_fin");
        this.right_fin = this.neck.getChild("right_fin");
        this.fin = this.neck.getChild("fin");
        this.tail_holder = this.body.getChild("tail_holder");
        this.right_fin_2 = this.body.getChild("right_fin_2");
        this.left_fin_2 = this.body.getChild("left_fin_2");
        this.tail_holder_2 = this.tail_holder.getChild("tail_holder_2");
        this.tail = this.tail_holder_2.getChild("tail");
        this.tail_linear = this.tail.getChild("tail_linear");
        this.endimator = Endimator.compile((ModelPart)root);
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition root = meshdefinition.getRoot();
        PartDefinition neck = root.addOrReplaceChild("neck", CubeListBuilder.create().texOffs(0, 24).addBox(-6.0f, -5.0f, -4.0f, 12.0f, 11.0f, 8.0f), PartPose.offsetAndRotation((float)0.0f, (float)17.0f, (float)-10.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition body = neck.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 43).addBox(-6.0f, 0.0f, 0.0f, 12.0f, 10.0f, 13.0f), PartPose.offsetAndRotation((float)0.0f, (float)-4.0f, (float)4.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition top_jaw = neck.addOrReplaceChild("top_jaw", CubeListBuilder.create().texOffs(0, 0).addBox(-6.0f, -2.5f, -10.0f, 12.0f, 5.0f, 10.0f), PartPose.offsetAndRotation((float)0.0f, (float)-2.5f, (float)-4.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition bottom_jaw = neck.addOrReplaceChild("bottom_jaw", CubeListBuilder.create().texOffs(44, 0).addBox(-6.0f, -2.0f, -10.0f, 12.0f, 4.0f, 10.0f), PartPose.offsetAndRotation((float)0.0f, (float)4.0f, (float)-4.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition left_fin = neck.addOrReplaceChild("left_fin", CubeListBuilder.create().texOffs(0, 16).mirror().addBox(0.0f, 0.0f, -2.5f, 10.0f, 1.0f, 6.0f), PartPose.offsetAndRotation((float)6.0f, (float)0.5f, (float)-0.5f, (float)0.0f, (float)-0.17453292f, (float)0.20943952f));
        PartDefinition right_fin = neck.addOrReplaceChild("right_fin", CubeListBuilder.create().texOffs(0, 16).addBox(-10.0f, 0.0f, -2.5f, 10.0f, 1.0f, 6.0f), PartPose.offsetAndRotation((float)-6.0f, (float)0.5f, (float)-0.5f, (float)0.0f, (float)0.17453292f, (float)-0.20943952f));
        PartDefinition fin = neck.addOrReplaceChild("fin", CubeListBuilder.create().texOffs(50, 50).addBox(0.0f, -7.0f, 0.0f, 0.0f, 7.0f, 12.0f), PartPose.offsetAndRotation((float)0.0f, (float)-5.0f, (float)-2.5f, (float)-0.17453292f, (float)0.0f, (float)0.0f));
        PartDefinition tail_holder = body.addOrReplaceChild("tail_holder", CubeListBuilder.create().texOffs(0, 66).addBox(-4.0f, -1.0f, 0.0f, 8.0f, 7.0f, 8.0f), PartPose.offsetAndRotation((float)0.0f, (float)2.5f, (float)13.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition right_fin_2 = body.addOrReplaceChild("right_fin_2", CubeListBuilder.create().texOffs(33, 16).addBox(-13.0f, 0.0f, -4.0f, 13.0f, 1.0f, 8.0f), PartPose.offsetAndRotation((float)-6.0f, (float)5.0f, (float)6.0f, (float)0.0f, (float)0.17453292f, (float)-0.20943952f));
        PartDefinition left_fin_2 = body.addOrReplaceChild("left_fin_2", CubeListBuilder.create().texOffs(33, 16).mirror().addBox(-0.0f, 0.0f, -4.0f, 13.0f, 1.0f, 8.0f), PartPose.offsetAndRotation((float)6.0f, (float)5.0f, (float)6.0f, (float)0.0f, (float)-0.17453292f, (float)0.20943952f));
        PartDefinition tail_holder_2 = tail_holder.addOrReplaceChild("tail_holder_2", CubeListBuilder.create().texOffs(0, 81).addBox(-3.0f, -3.0f, 0.0f, 6.0f, 6.0f, 8.0f), PartPose.offsetAndRotation((float)0.0f, (float)2.5f, (float)8.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition tail = tail_holder_2.addOrReplaceChild("tail", CubeListBuilder.create().texOffs(30, 70).addBox(0.0f, -3.0f, 0.0f, 0.0f, 6.0f, 18.0f), PartPose.offsetAndRotation((float)0.0f, (float)0.1f, (float)8.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition tail_linear = tail.addOrReplaceChild("tail_linear", CubeListBuilder.create().texOffs(30, 70).addBox(0.0f, 0.0f, 0.0f, 6.0f, 0.0f, 18.0f), PartPose.offsetAndRotation((float)-3.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)100, (int)100);
    }

    public void renderToBuffer(PoseStack matrixStackIn, VertexConsumer bufferIn, int packedLightIn, int packedOverlayIn, int color) {
        this.neck.render(matrixStackIn, bufferIn, packedLightIn, packedOverlayIn, color);
    }

    public void setupAnim(E thrasher, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        super.setupAnim(thrasher, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        float tailAnimation = ((Thrasher)((Object)thrasher)).getTailAnimation(ageInTicks - (float)((Thrasher)((Object)thrasher)).tickCount);
        float finWaveAnimation = ((Thrasher)((Object)thrasher)).getFinAnimation(ageInTicks - (float)((Thrasher)((Object)thrasher)).tickCount);
        this.neck.xRot = headPitch * ((float)Math.PI / 180);
        this.neck.yRot = netHeadYaw * ((float)Math.PI / 180);
        ModelPart[] tailComponents = new ModelPart[]{this.body, this.tail_holder, this.tail_holder_2};
        for (int i = 1; i < tailComponents.length + 1; ++i) {
            tailComponents[i - 1].yRot = Mth.sin((float)tailAnimation) * (float)Math.PI * (0.045f * (float)i);
        }
        if (((Thrasher)((Object)thrasher)).isMoving() && thrasher.isInWater()) {
            this.tail.zRot = Mth.sin((float)((float)((double)(((float)((Thrasher)((Object)thrasher)).tickCount + ageInTicks) * 2.0f) * Math.PI * 0.8125)));
        }
        this.right_fin.zRot = (float)((double)(-Mth.cos((float)finWaveAnimation) * (float)Math.PI) * 0.13);
        this.right_fin_2.zRot = (float)((double)(-Mth.cos((float)(finWaveAnimation - 1.5f)) * (float)Math.PI) * 0.1);
        this.left_fin.zRot = (float)((double)(Mth.cos((float)finWaveAnimation) * (float)Math.PI) * 0.13);
        this.left_fin_2.zRot = (float)((double)(Mth.cos((float)(finWaveAnimation - 1.5f)) * (float)Math.PI) * 0.1);
    }
}

