/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.upgrade_aquatic.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.teamabnormals.upgrade_aquatic.common.entity.monster.Flare;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class FlareModel<F extends Flare>
extends EntityModel<F> {
    public ModelPart base;
    public ModelPart tail;
    public ModelPart left_shoulder;
    public ModelPart right_shoulder;
    public ModelPart head;
    public ModelPart tail_end;
    public ModelPart left_wing;
    public ModelPart right_wing;
    public ModelPart shape13;

    public FlareModel(ModelPart root) {
        this.base = root.getChild("base");
        this.head = this.base.getChild("head");
        this.shape13 = this.head.getChild("shape13");
        this.left_shoulder = this.base.getChild("left_shoulder");
        this.left_wing = this.left_shoulder.getChild("left_wing");
        this.tail = this.base.getChild("tail");
        this.tail_end = this.tail.getChild("tail_end");
        this.right_shoulder = this.base.getChild("right_shoulder");
        this.right_wing = this.right_shoulder.getChild("right_wing");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition root = meshdefinition.getRoot();
        PartDefinition base = root.addOrReplaceChild("base", CubeListBuilder.create().texOffs(0, 8).addBox(0.0f, 0.0f, 0.0f, 5.0f, 3.0f, 9.0f, false), PartPose.offsetAndRotation((float)-2.5f, (float)18.0f, (float)-5.0f, (float)-0.174533f, (float)0.0f, (float)0.0f));
        PartDefinition head = base.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).addBox(-3.5f, 0.0f, -5.0f, 7.0f, 4.0f, 5.0f, false), PartPose.offsetAndRotation((float)2.5f, (float)1.2f, (float)0.0f, (float)0.349066f, (float)0.0f, (float)0.0f));
        PartDefinition shape13 = head.addOrReplaceChild("shape13", CubeListBuilder.create().texOffs(26, 0).addBox(-4.5f, 0.0f, -3.0f, 9.0f, 2.0f, 5.0f, false), PartPose.offsetAndRotation((float)0.0f, (float)2.0f, (float)-3.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition left_shoulder = base.addOrReplaceChild("left_shoulder", CubeListBuilder.create().texOffs(27, 16).mirror().addBox(0.0f, 0.0f, -4.5f, 6.0f, 2.0f, 9.0f, true), PartPose.offsetAndRotation((float)5.0f, (float)0.0f, (float)4.5f, (float)-0.0f, (float)0.0f, (float)0.17453292f));
        PartDefinition left_wing = left_shoulder.addOrReplaceChild("left_wing", CubeListBuilder.create().texOffs(0, 46).mirror().addBox(0.0f, 0.0f, -5.0f, 13.0f, 1.0f, 10.0f, true), PartPose.offsetAndRotation((float)6.0f, (float)0.0f, (float)0.5f, (float)0.0f, (float)0.0f, (float)0.17453292f));
        PartDefinition tail = base.addOrReplaceChild("tail", CubeListBuilder.create().texOffs(0, 20).addBox(-2.5f, 0.0f, 0.0f, 5.0f, 3.0f, 10.0f, false), PartPose.offsetAndRotation((float)2.5f, (float)0.0f, (float)9.0f, (float)-0.17453292f, (float)0.0f, (float)0.0f));
        PartDefinition tail_end = tail.addOrReplaceChild("tail_end", CubeListBuilder.create().texOffs(0, 33).addBox(-1.5f, 0.0f, 0.0f, 3.0f, 3.0f, 10.0f, false), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)10.0f, (float)-0.17453292f, (float)0.0f, (float)0.0f));
        PartDefinition right_shoulder = base.addOrReplaceChild("right_shoulder", CubeListBuilder.create().texOffs(27, 16).addBox(-6.0f, 0.0f, -4.5f, 6.0f, 2.0f, 9.0f, false), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)4.5f, (float)0.0f, (float)0.0f, (float)-0.17453292f));
        PartDefinition right_wing = right_shoulder.addOrReplaceChild("right_wing", CubeListBuilder.create().texOffs(0, 46).addBox(-13.0f, 0.0f, -5.0f, 13.0f, 1.0f, 10.0f, false), PartPose.offsetAndRotation((float)-6.0f, (float)0.0f, (float)0.5f, (float)0.0f, (float)-0.0f, (float)-0.17453292f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void renderToBuffer(PoseStack matrixStackIn, VertexConsumer bufferIn, int packedLightIn, int packedOverlayIn, int color) {
        this.base.render(matrixStackIn, bufferIn, packedLightIn, packedOverlayIn, color);
    }

    public void setupAnim(F flare, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        float f = ((float)(flare.getId() * 3) + ageInTicks) * 0.13f;
        float f1 = 16.0f;
        this.left_wing.zRot = this.left_shoulder.zRot = Mth.cos((float)f) * f1 * ((float)Math.PI / 180);
        this.right_shoulder.zRot = -this.left_shoulder.zRot;
        this.right_wing.zRot = -this.left_wing.zRot;
        this.tail_end.xRot = this.tail.xRot = -(5.0f + Mth.cos((float)(f * 2.0f)) * 5.0f) * ((float)Math.PI / 180);
    }
}

