/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.util.packet;

import com.railwayteam.railways.content.conductor.ConductorEntity;
import com.railwayteam.railways.content.conductor.ConductorPossessionController;
import com.railwayteam.railways.multiloader.S2CPacket;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;

public class SetCameraViewPacket
implements S2CPacket {
    private final int id;

    public SetCameraViewPacket(Entity camera) {
        this.id = camera.getId();
    }

    public SetCameraViewPacket(FriendlyByteBuf buf) {
        this.id = buf.readVarInt();
    }

    @Override
    public void write(FriendlyByteBuf buffer) {
        buffer.writeVarInt(this.id);
    }

    @Override
    public void handle(Minecraft mc) {
        Entity entity = mc.level.getEntity(this.id);
        boolean isCamera = entity instanceof ConductorEntity;
        if (isCamera || entity instanceof Player) {
            mc.setCameraEntity(entity);
            if (isCamera) {
                ConductorPossessionController.setRenderPosition(entity);
                if (mc.player != null) {
                    mc.player.xxa = 0.0f;
                    mc.player.zza = 0.0f;
                    mc.player.setJumping(false);
                }
            }
            mc.levelRenderer.allChanged();
        }
    }
}

