/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.util.packet;

import com.railwayteam.railways.content.minecarts.MinecartJukebox;
import com.railwayteam.railways.multiloader.S2CPacket;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class JukeboxCartPacket
implements S2CPacket {
    final int id;
    final CompoundTag recordTag;

    public JukeboxCartPacket(Entity target, ItemStack disc) {
        this.id = target.getId();
        this.recordTag = (CompoundTag)disc.save((HolderLookup.Provider)target.level().registryAccess());
    }

    public JukeboxCartPacket(FriendlyByteBuf buf) {
        this.id = buf.readInt();
        this.recordTag = buf.readNbt();
    }

    @Override
    public void write(FriendlyByteBuf buffer) {
        buffer.writeInt(this.id);
        buffer.writeNbt((Tag)this.recordTag);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void handle(Minecraft mc) {
        Entity target;
        ClientLevel level = mc.level;
        if (level != null && (target = level.getEntity(this.id)) instanceof MinecartJukebox) {
            MinecartJukebox juke = (MinecartJukebox)target;
            RegistryAccess registryAccess = level.registryAccess();
            ItemStack stack = this.recordTag != null ? ItemStack.parseOptional((HolderLookup.Provider)registryAccess, (CompoundTag)this.recordTag) : ItemStack.EMPTY;
            juke.insertRecord(stack);
        }
    }
}

