/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.util.client;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import org.jetbrains.annotations.Nullable;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class OcclusionTestLevel
implements BlockGetter {
    private final Map<BlockPos, BlockState> blocks = new HashMap<BlockPos, BlockState>();
    private final BlockGetter blockGetter;

    public OcclusionTestLevel(BlockGetter blockGetter) {
        this.blockGetter = blockGetter;
    }

    public void setBlock(BlockPos pos, BlockState state) {
        this.blocks.put(pos.immutable(), state);
    }

    public void clear() {
        this.blocks.clear();
    }

    @Nullable
    public BlockEntity getBlockEntity(BlockPos pos) {
        return null;
    }

    public BlockState getBlockState(BlockPos pos) {
        return this.blocks.get(pos);
    }

    public FluidState getFluidState(BlockPos pos) {
        return Fluids.EMPTY.defaultFluidState();
    }

    public int getHeight() {
        return this.blockGetter.getHeight();
    }

    public int getMinBuildHeight() {
        return this.blockGetter.getMinBuildHeight();
    }
}

