/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.util;

import com.railwayteam.railways.content.conductor.ConductorEntity;
import com.railwayteam.railways.util.neoforge.EntityUtilsImpl;
import java.util.function.Predicate;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Contract;

public class EntityUtils {
    public static CompoundTag getPersistentData(Entity entity) {
        return EntityUtilsImpl.getPersistentData(entity);
    }

    public static void givePlayerItem(Player player, ItemStack stack) {
        EntityUtilsImpl.givePlayerItem(player, stack);
    }

    public static ServerPlayer createConductorFakePlayer(ServerLevel level, ConductorEntity conductor) {
        return EntityUtilsImpl.createConductorFakePlayer(level, conductor);
    }

    public static double getReachDistance(Player player) {
        return EntityUtilsImpl.getReachDistance(player);
    }

    @Contract
    public static boolean handleUseEvent(Player player, InteractionHand hand, BlockHitResult hit) {
        return EntityUtilsImpl.handleUseEvent(player, hand, hit);
    }

    public static boolean isHolding(Player player, Predicate<ItemStack> predicate) {
        return predicate.test(player.getItemInHand(InteractionHand.MAIN_HAND)) || predicate.test(player.getItemInHand(InteractionHand.OFF_HAND));
    }

    public static boolean isHoldingItem(Player player, Predicate<Item> predicate) {
        return EntityUtils.isHolding(player, stack -> predicate.test(stack.getItem()));
    }
}

