/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.neoforge.events;

import com.railwayteam.railways.content.custom_tracks.casing.CasingResourceReloadListener;
import com.railwayteam.railways.events.ClientEvents;
import com.railwayteam.railways.registry.neoforge.CRKeysImpl;
import net.minecraft.client.Minecraft;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.InputEvent;
import net.neoforged.neoforge.client.event.RegisterClientReloadListenersEvent;
import net.neoforged.neoforge.client.event.RegisterKeyMappingsEvent;
import net.neoforged.neoforge.event.TagsUpdatedEvent;
import net.neoforged.neoforge.event.level.LevelEvent;

@EventBusSubscriber(value={Dist.CLIENT})
public class ClientEventsForge {
    @SubscribeEvent
    public static void onClientTick(ClientTickEvent.Pre event) {
        ClientEvents.onClientTickStart(Minecraft.getInstance());
    }

    @SubscribeEvent
    public static void onClientTickPost(ClientTickEvent.Post event) {
        ClientEvents.onClientTickEnd(Minecraft.getInstance());
    }

    @SubscribeEvent
    public static void onWorldLoad(LevelEvent.Load event) {
        ClientEvents.onClientWorldLoad((Level)event.getLevel());
    }

    @SubscribeEvent
    public static void onKeyInput(InputEvent.Key event) {
        int key = event.getKey();
        boolean pressed = event.getAction() != 0;
        ClientEvents.onKeyInput(key, pressed);
    }

    @SubscribeEvent
    public static void onTagsUpdated(TagsUpdatedEvent event) {
        if (event.getUpdateCause() == TagsUpdatedEvent.UpdateCause.CLIENT_PACKET_RECEIVED) {
            ClientEvents.onTagsUpdated();
        }
    }

    @EventBusSubscriber(value={Dist.CLIENT}, bus=EventBusSubscriber.Bus.MOD)
    public static class ModBusEvents {
        @SubscribeEvent
        public static void onRegisterKeyMappings(RegisterKeyMappingsEvent event) {
            CRKeysImpl.onRegisterKeyMappings(event);
        }

        @SubscribeEvent
        public static void registerClientReloadListeners(RegisterClientReloadListenersEvent event) {
            event.registerReloadListener((PreparableReloadListener)CasingResourceReloadListener.INSTANCE);
        }
    }
}

