/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.neoforge;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ForwardingMultimap;
import com.google.common.collect.Multimap;
import com.mojang.brigadier.CommandDispatcher;
import com.railwayteam.railways.Railways;
import com.railwayteam.railways.base.data.CRTagGen;
import com.railwayteam.railways.base.data.lang.CRLangGen;
import com.railwayteam.railways.config.neoforge.CRConfigsImpl;
import com.railwayteam.railways.content.fuel.tank.FuelTankBlock;
import com.railwayteam.railways.multiloader.Env;
import com.railwayteam.railways.neoforge.RailwaysClientImpl;
import com.railwayteam.railways.neoforge.RailwaysNetworking;
import com.railwayteam.railways.registry.neoforge.CRBlockEntitiesImpl;
import com.railwayteam.railways.registry.neoforge.CRBlocksImpl;
import com.railwayteam.railways.registry.neoforge.CRCreativeModeTabsImpl;
import com.railwayteam.railways.registry.neoforge.CREntityAttributesImpl;
import com.railwayteam.railways.registry.neoforge.CRMountedStorageTypesImpl;
import com.railwayteam.railways.registry.neoforge.CRParticleTypesParticleEntryImpl;
import com.simibubi.create.api.connectivity.ConnectivityHandler;
import com.simibubi.create.api.contraption.BlockMovementChecks;
import com.simibubi.create.foundation.data.CreateRegistrate;
import com.tterrag.registrate.AbstractRegistrate;
import com.tterrag.registrate.providers.ProviderType;
import com.tterrag.registrate.util.CreativeModeTabModifier;
import java.lang.reflect.Field;
import java.lang.reflect.InaccessibleObjectException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.level.BlockGetter;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.event.RegisterCommandsEvent;

@Mod(value="railways")
@EventBusSubscriber
public class RailwaysImpl {
    static IEventBus bus;
    private static final Set<BiConsumer<CommandDispatcher<CommandSourceStack>, Boolean>> commandConsumers;

    public RailwaysImpl(IEventBus modEventBus, ModContainer modContainer) {
        bus = modEventBus;
        CRCreativeModeTabsImpl.register(bus);
        modEventBus.addListener(CREntityAttributesImpl::registerAttributes);
        Railways.init();
        CRConfigsImpl.register(modContainer);
        CRParticleTypesParticleEntryImpl.register(bus);
        modEventBus.addListener(RailwaysNetworking::registerPayloads);
        Env.CLIENT.runIfCurrent(() -> () -> RailwaysClientImpl.init());
    }

    public static void finalizeRegistrate() {
        CreateRegistrate registrate = Railways.registrate();
        registrate.addDataGenerator(ProviderType.BLOCK_TAGS, CRTagGen::generateBlockTags);
        registrate.addDataGenerator(ProviderType.ITEM_TAGS, CRTagGen::generateItemTags);
        registrate.addDataGenerator(ProviderType.LANG, CRLangGen::generate);
        RailwaysImpl.suppressRegistrateTabModifiers(registrate);
        registrate.registerEventListeners(bus);
    }

    private static void suppressRegistrateTabModifiers(CreateRegistrate registrate) {
        try {
            Field field = AbstractRegistrate.class.getDeclaredField("creativeModeTabModifiers");
            field.setAccessible(true);
            Object value = field.get(registrate);
            if (value instanceof Multimap) {
                Multimap multimap = (Multimap)value;
                multimap.clear();
            }
            field.set(registrate, (Object)new NoOpCreativeTabMultimap());
        }
        catch (SecurityException | InaccessibleObjectException e) {
            throw new IllegalStateException("Failed to access Registrate creative tab modifiers field. If running on Java 9+, you may need to add JVM flag: --add-opens com.tterrag.registrate/com.tterrag.registrate=ALL-UNNAMED", e);
        }
        catch (ReflectiveOperationException e) {
            throw new IllegalStateException("Failed to clear Registrate creative tab modifiers", e);
        }
    }

    public static void registerCommands(BiConsumer<CommandDispatcher<CommandSourceStack>, Boolean> consumer) {
        commandConsumers.add(consumer);
    }

    @SubscribeEvent
    public static void onCommandRegistration(RegisterCommandsEvent event) {
        Commands.CommandSelection selection = event.getCommandSelection();
        boolean dedicated = selection == Commands.CommandSelection.ALL || selection == Commands.CommandSelection.DEDICATED;
        commandConsumers.forEach(consumer -> consumer.accept(event.getDispatcher(), dedicated));
    }

    public static void platformBasedRegistration() {
        BlockMovementChecks.registerAttachedCheck((state, world, pos, direction) -> {
            if (state.getBlock() instanceof FuelTankBlock && ConnectivityHandler.isConnected((BlockGetter)world, (BlockPos)pos, (BlockPos)pos.relative(direction))) {
                return BlockMovementChecks.CheckResult.SUCCESS;
            }
            return BlockMovementChecks.CheckResult.PASS;
        });
        CRMountedStorageTypesImpl.init();
        CRBlocksImpl.init();
        CRBlockEntitiesImpl.init();
    }

    static {
        commandConsumers = new HashSet<BiConsumer<CommandDispatcher<CommandSourceStack>, Boolean>>();
    }

    private static final class NoOpCreativeTabMultimap
    extends ForwardingMultimap<ResourceKey<CreativeModeTab>, Consumer<CreativeModeTabModifier>> {
        private final Multimap<ResourceKey<CreativeModeTab>, Consumer<CreativeModeTabModifier>> delegate = ArrayListMultimap.create();

        private NoOpCreativeTabMultimap() {
        }

        protected Multimap<ResourceKey<CreativeModeTab>, Consumer<CreativeModeTabModifier>> delegate() {
            return this.delegate;
        }

        public boolean put(ResourceKey<CreativeModeTab> key, Consumer<CreativeModeTabModifier> value) {
            return false;
        }

        public boolean putAll(ResourceKey<CreativeModeTab> key, Iterable<? extends Consumer<CreativeModeTabModifier>> values) {
            return false;
        }

        public boolean putAll(Multimap<? extends ResourceKey<CreativeModeTab>, ? extends Consumer<CreativeModeTabModifier>> multimap) {
            return false;
        }

        public Collection<Consumer<CreativeModeTabModifier>> replaceValues(ResourceKey<CreativeModeTab> key, Iterable<? extends Consumer<CreativeModeTabModifier>> values) {
            Collection removed = this.delegate().get(key);
            this.delegate().removeAll(key);
            return removed;
        }
    }
}

