/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.mixin.conductor_possession;

import com.railwayteam.railways.content.conductor.ConductorPossessionController;
import net.minecraft.server.level.ChunkMap;
import net.minecraft.server.level.ChunkTrackingView;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ChunkPos;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ChunkMap.class})
public abstract class CameraChunkTrackingMixin {
    @Shadow
    protected abstract int getPlayerViewDistance(ServerPlayer var1);

    @Shadow
    protected abstract void applyChunkTrackingView(ServerPlayer var1, ChunkTrackingView var2);

    @Inject(method={"updateChunkTracking"}, at={@At(value="HEAD")}, cancellable=true)
    private void railways$redirectToCamera(ServerPlayer player, CallbackInfo ci) {
        if (ConductorPossessionController.isPossessingConductor((Entity)player)) {
            ChunkTrackingView.Positioned positioned;
            Entity camera = player.getCamera();
            if (camera == null) {
                return;
            }
            ChunkPos cameraChunk = camera.chunkPosition();
            int dist = this.getPlayerViewDistance(player);
            ChunkTrackingView chunkTrackingView = player.getChunkTrackingView();
            if (!(chunkTrackingView instanceof ChunkTrackingView.Positioned) || !(positioned = (ChunkTrackingView.Positioned)chunkTrackingView).center().equals((Object)cameraChunk) || positioned.viewDistance() != dist) {
                this.applyChunkTrackingView(player, ChunkTrackingView.of((ChunkPos)cameraChunk, (int)dist));
            }
            ci.cancel();
        }
    }
}

