/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.mixin;

import com.simibubi.create.content.equipment.wrench.WrenchItem;
import com.simibubi.create.content.kinetics.deployer.DeployerFakePlayer;
import com.simibubi.create.content.trains.entity.Train;
import com.simibubi.create.content.trains.station.GlobalStation;
import com.simibubi.create.content.trains.station.StationBlock;
import com.simibubi.create.content.trains.station.StationBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={WrenchItem.class}, remap=false)
public abstract class MixinWrenchItem {
    @Inject(method={"useOn"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    private void deployerWrenchStationInteraction(UseOnContext context, CallbackInfoReturnable<InteractionResult> cir) {
        Player player = context.getPlayer();
        if (player == null) {
            return;
        }
        if (!(player instanceof DeployerFakePlayer)) {
            return;
        }
        DeployerFakePlayer deployerFakePlayer = (DeployerFakePlayer)player;
        Level level = context.getLevel();
        BlockPos pos = context.getClickedPos();
        BlockState state = level.getBlockState(pos);
        if (!(state.getBlock() instanceof StationBlock)) {
            return;
        }
        if (level.isClientSide) {
            return;
        }
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (!(blockEntity instanceof StationBlockEntity)) {
            return;
        }
        StationBlockEntity stationBe = (StationBlockEntity)blockEntity;
        GlobalStation station = stationBe.getStation();
        boolean isAssemblyMode = (Boolean)state.getValue((Property)StationBlock.ASSEMBLING);
        if (station != null && station.getPresentTrain() == null && (stationBe.isAssembling() || stationBe.tryEnterAssemblyMode())) {
            stationBe.assemble(deployerFakePlayer.getUUID());
            if (isAssemblyMode) {
                level.setBlock(pos, (BlockState)state.setValue((Property)StationBlock.ASSEMBLING, (Comparable)Boolean.valueOf(false)), 3);
                stationBe.refreshBlockState();
            }
            cir.setReturnValue((Object)InteractionResult.SUCCESS);
            return;
        }
        BlockState newState = null;
        if (!isAssemblyMode) {
            newState = (BlockState)state.setValue((Property)StationBlock.ASSEMBLING, (Comparable)Boolean.valueOf(true));
        }
        if (this.disassembleAndEnterMode((ServerPlayer)deployerFakePlayer, stationBe)) {
            if (newState != null) {
                level.setBlock(pos, newState, 3);
                stationBe.refreshBlockState();
                stationBe.refreshAssemblyInfo();
            }
            cir.setReturnValue((Object)InteractionResult.SUCCESS);
        }
    }

    private boolean disassembleAndEnterMode(ServerPlayer sender, StationBlockEntity te) {
        GlobalStation station = te.getStation();
        if (station != null) {
            ItemStack schedule;
            Train train = station.getPresentTrain();
            BlockPos trackPosition = te.edgePoint.getGlobalPosition();
            ItemStack itemStack = schedule = train == null ? ItemStack.EMPTY : train.runtime.returnSchedule((HolderLookup.Provider)te.getLevel().registryAccess());
            if (train != null && !train.disassemble(te.getAssemblyDirection(), trackPosition.above())) {
                return false;
            }
            this.dropSchedule(sender, te, schedule);
        }
        return te.tryEnterAssemblyMode();
    }

    private void dropSchedule(ServerPlayer player, StationBlockEntity te, ItemStack schedule) {
        if (schedule.isEmpty()) {
            return;
        }
        ItemEntity itemEntity = new ItemEntity(te.getLevel(), (double)te.getBlockPos().getX() + 0.5, (double)te.getBlockPos().getY() + 1.5, (double)te.getBlockPos().getZ() + 0.5, schedule);
        itemEntity.setDefaultPickUpDelay();
        te.getLevel().addFreshEntity((Entity)itemEntity);
    }
}

