/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.events;

import com.railwayteam.railways.compat.create.MountedFuelTankSyncDeferral;
import com.railwayteam.railways.compat.create.MountedStorageSyncDeferral;
import com.railwayteam.railways.config.CRConfigs;
import com.railwayteam.railways.content.bogey_menu.handler.BogeyMenuEventsHandler;
import com.railwayteam.railways.content.conductor.ConductorPossessionController;
import com.railwayteam.railways.content.custom_tracks.phantom.PhantomSpriteManager;
import com.railwayteam.railways.content.cycle_menu.TagCycleHandlerClient;
import com.railwayteam.railways.content.fuel.tank.FuelTankBlockEntity;
import com.railwayteam.railways.content.qol.TrackEdgePointHighlighter;
import com.railwayteam.railways.registry.CRKeys;
import com.railwayteam.railways.registry.CRPackets;
import com.railwayteam.railways.util.packet.ConfigureDevCapeC2SPacket;
import net.createmod.catnip.animation.LerpedFloat;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;
import org.jetbrains.annotations.ApiStatus;

public class ClientEvents {
    @ApiStatus.Internal
    public static boolean previousDevCapeSetting = false;

    public static void onClientTickStart(Minecraft mc) {
        long ticks;
        CRKeys.fixBinds();
        PhantomSpriteManager.tick(mc);
        ClientLevel level = mc.level;
        MountedStorageSyncDeferral.clientTick(mc);
        MountedFuelTankSyncDeferral.clientTick(mc, (be, fluid) -> {
            if (!(be instanceof FuelTankBlockEntity)) {
                return false;
            }
            FuelTankBlockEntity tank = (FuelTankBlockEntity)be;
            FluidTank inv = tank.getTankInventory();
            inv.setFluid(fluid);
            float fillLevel = (float)inv.getFluidAmount() / (float)inv.getCapacity();
            if (tank.getFluidLevel() == null) {
                tank.setFluidLevel(LerpedFloat.linear().startWithValue((double)fillLevel));
            }
            tank.getFluidLevel().chase((double)fillLevel, 0.5, LerpedFloat.Chaser.EXP);
            return true;
        });
        long l = ticks = level == null ? 1L : level.getGameTime();
        if (ticks % 40L == 0L && previousDevCapeSetting != (previousDevCapeSetting = ((Boolean)CRConfigs.client().useDevCape.get()).booleanValue())) {
            CRPackets.PACKETS.send(new ConfigureDevCapeC2SPacket(previousDevCapeSetting));
        }
        if (ClientEvents.isGameActive()) {
            BogeyMenuEventsHandler.clientTick();
            TagCycleHandlerClient.clientTick();
            ConductorPossessionController.onClientTick(mc, true);
            TrackEdgePointHighlighter.clientTick(mc);
        }
    }

    public static void onClientTickEnd(Minecraft mc) {
        if (ClientEvents.isGameActive()) {
            ConductorPossessionController.onClientTick(mc, false);
        }
    }

    public static void onClientWorldLoad(Level level) {
        PhantomSpriteManager.firstRun = true;
    }

    protected static boolean isGameActive() {
        return Minecraft.getInstance().level != null && Minecraft.getInstance().player != null;
    }

    public static void onKeyInput(int key, boolean pressed) {
        if (Minecraft.getInstance().screen != null) {
            return;
        }
        BogeyMenuEventsHandler.onKeyInput(key, pressed);
        if (Minecraft.getInstance().screen != null) {
            return;
        }
        TagCycleHandlerClient.onKeyInput(key, pressed);
    }

    public static void onTagsUpdated() {
        TagCycleHandlerClient.onTagsUpdated();
    }
}

