/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.content.switches;

import com.railwayteam.railways.content.switches.TrackSwitch;
import com.railwayteam.railways.content.switches.TrackSwitchBlock;
import com.railwayteam.railways.content.switches.TrackSwitchBlockItem;
import com.railwayteam.railways.registry.CREdgePointTypes;
import com.railwayteam.railways.util.EntityUtils;
import com.simibubi.create.CreateClient;
import com.simibubi.create.content.trains.graph.TrackGraph;
import com.simibubi.create.content.trains.graph.TrackNode;
import com.simibubi.create.content.trains.graph.TrackNodeLocation;
import java.util.Map;
import java.util.Objects;
import net.createmod.catnip.outliner.Outliner;
import net.createmod.catnip.theme.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class TrackSwitchDebugVisualizer {
    public static void visualizeSwitchExits(TrackSwitch sw) {
        Minecraft mc = Minecraft.getInstance();
        Entity camera = mc.cameraEntity;
        if (camera == null) {
            return;
        }
        Vec3 offset = new Vec3(0.0, 0.4, 0.0);
        float width = 0.0625f;
        TrackNodeLocation from = sw.getSwitchPoint();
        TrackNodeLocation activeExit = sw.getSwitchTarget();
        for (TrackNodeLocation to : sw.getExits()) {
            boolean active = to == activeExit;
            Outliner.getInstance().showLine((Object)to, from.getLocation().add(offset), to.getLocation().add(offset)).colored(active ? new Color(0, 203, 150) : new Color(255, 50, 150)).lineWidth(width);
        }
    }

    public static void visualizePotentialLocations() {
        boolean skipHints;
        Minecraft mc = Minecraft.getInstance();
        Entity camera = mc.cameraEntity;
        if (camera == null) {
            return;
        }
        if (mc.player == null) {
            return;
        }
        boolean bl = skipHints = !EntityUtils.isHoldingItem((Player)mc.player, item -> item instanceof TrackSwitchBlockItem);
        if (skipHints) {
            HitResult hitResult = mc.hitResult;
            if (!(hitResult instanceof BlockHitResult)) {
                return;
            }
            BlockHitResult blockHitResult = (BlockHitResult)hitResult;
            if (blockHitResult.getType() == HitResult.Type.MISS) {
                return;
            }
            BlockPos pos = blockHitResult.getBlockPos();
            BlockState state = mc.player.level().getBlockState(pos);
            if (!(state.getBlock() instanceof TrackSwitchBlock)) {
                return;
            }
        }
        int range = 64;
        int rangeSqr = range * range;
        for (TrackGraph graph : CreateClient.RAILWAYS.trackNetworks.values()) {
            for (TrackNodeLocation tnl : graph.getNodes()) {
                TrackNode node;
                Map connections;
                int connectionCount;
                if (!Objects.equals(tnl.dimension, mc.level.dimension()) || tnl.getLocation().distanceToSqr(camera.position()) > (double)rangeSqr) continue;
                for (TrackSwitch sw : graph.getPoints(CREdgePointTypes.SWITCH)) {
                    TrackSwitchDebugVisualizer.visualizeSwitchExits(sw);
                }
                if (skipHints || (connectionCount = (connections = graph.getConnectionsFrom(node = graph.locateNode(tnl))).size()) <= 2 || connectionCount > 4) continue;
                Vec3 basePos = node.getLocation().getLocation();
                Vec3 averageOffset = Vec3.ZERO;
                Vec3[] offsets = new Vec3[connectionCount];
                int i = 0;
                for (Map.Entry entry : connections.entrySet()) {
                    Vec3 offset = ((TrackNode)entry.getKey()).getLocation().getLocation().subtract(basePos).normalize();
                    averageOffset = averageOffset.add(offset);
                    offsets[i] = offset;
                    ++i;
                }
                Vec3 farthestOffset = Vec3.ZERO;
                double farthestDistance = 0.0;
                for (Vec3 offset : offsets) {
                    double distance = averageOffset.distanceToSqr(offset);
                    if (!(distance > farthestDistance)) continue;
                    farthestDistance = distance;
                    farthestOffset = offset;
                }
                Direction offsetDirection = Direction.getNearest((double)farthestOffset.x, (double)farthestOffset.y, (double)farthestOffset.z);
                Outliner.getInstance().showAABB((Object)node, AABB.ofSize((Vec3)tnl.getLocation().add(farthestOffset.x / 2.0, farthestOffset.y / 2.0, farthestOffset.z / 2.0).add(0.0, 0.5, 0.0), (double)1.0, (double)1.0, (double)1.0)).colored(graph.color).lineWidth(0.0625f);
            }
        }
    }
}

