/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.content.smokestack.particles.puffs;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.railwayteam.railways.content.smokestack.particles.puffs.PuffSmokeParticle;
import com.railwayteam.railways.registry.CRParticleTypes;
import com.simibubi.create.foundation.particle.ICustomParticleDataWithSprite;
import java.util.Locale;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.DyeColor;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public abstract class PuffSmokeParticleData<T extends PuffSmokeParticleData<T>>
implements ParticleOptions,
ICustomParticleDataWithSprite<T> {
    boolean stationary;
    float red;
    float green;
    float blue;

    protected static <T extends PuffSmokeParticleData<T>> MapCodec<T> makeCodec(Constructor<T> constructor) {
        return RecordCodecBuilder.mapCodec(i -> i.group((App)Codec.BOOL.fieldOf("stationary").forGetter(p -> p.stationary), (App)Codec.FLOAT.fieldOf("red").forGetter(p -> Float.valueOf(p.red)), (App)Codec.FLOAT.fieldOf("green").forGetter(p -> Float.valueOf(p.green)), (App)Codec.FLOAT.fieldOf("blue").forGetter(p -> Float.valueOf(p.blue))).apply((Applicative)i, constructor::create));
    }

    protected PuffSmokeParticleData() {
        this(false);
    }

    protected PuffSmokeParticleData(float red, float green, float blue) {
        this(false, red, green, blue);
    }

    protected PuffSmokeParticleData(boolean stationary) {
        this(stationary, -1.0f);
    }

    protected PuffSmokeParticleData(boolean stationary, float brightness) {
        this(stationary, brightness, brightness, brightness);
    }

    protected PuffSmokeParticleData(boolean stationary, float red, float green, float blue) {
        this.stationary = stationary;
        this.red = red;
        this.green = green;
        this.blue = blue;
    }

    @NotNull
    protected abstract CRParticleTypes getParticleType();

    @NotNull
    public ParticleType<?> getType() {
        return this.getParticleType().get();
    }

    public void writeToNetwork(FriendlyByteBuf buffer) {
        buffer.writeBoolean(this.stationary);
        buffer.writeFloat(this.red);
        buffer.writeFloat(this.green);
        buffer.writeFloat(this.blue);
    }

    @NotNull
    public String writeToString() {
        return String.format(Locale.ROOT, "%s %b %f %f %f", this.getParticleType().parameter(), this.stationary, Float.valueOf(this.red), Float.valueOf(this.green), Float.valueOf(this.blue));
    }

    public abstract MapCodec<T> getCodec(ParticleType<T> var1);

    public abstract StreamCodec<FriendlyByteBuf, T> getStreamCodec();

    public abstract ParticleEngine.SpriteParticleRegistration<T> getMetaFactory();

    public abstract float getQuadSize();

    public static PuffSmokeParticleData<?> create(boolean small, boolean stationary, @NotNull DyeColor color) {
        float idx = -(3 + color.getId());
        return PuffSmokeParticleData.create(small, stationary, idx, idx, idx);
    }

    public static PuffSmokeParticleData<?> create(boolean small, boolean stationary, float red, float green, float blue) {
        if (small) {
            return new Small(stationary, red, green, blue);
        }
        return new Medium(stationary, red, green, blue);
    }

    public static PuffSmokeParticleData<?> create(boolean small, boolean stationary) {
        if (small) {
            return new Small(stationary);
        }
        return new Medium(stationary);
    }

    @FunctionalInterface
    protected static interface Constructor<T extends PuffSmokeParticleData<T>> {
        @Contract(value="_, _, _, _ -> new")
        public T create(boolean var1, float var2, float var3, float var4);
    }

    public static class Small
    extends PuffSmokeParticleData<Small> {
        public static final MapCodec<Small> CODEC = Small.makeCodec(Small::new);
        public static final StreamCodec<FriendlyByteBuf, Small> STREAM_CODEC = new StreamCodec<FriendlyByteBuf, Small>(){

            public void encode(FriendlyByteBuf buffer, Small data) {
                buffer.writeBoolean(data.stationary);
                buffer.writeFloat(data.red);
                buffer.writeFloat(data.green);
                buffer.writeFloat(data.blue);
            }

            public Small decode(FriendlyByteBuf buffer) {
                return new Small(buffer.readBoolean(), buffer.readFloat(), buffer.readFloat(), buffer.readFloat());
            }
        };

        public Small() {
        }

        public Small(float red, float green, float blue) {
            super(red, green, blue);
        }

        public Small(boolean stationary) {
            super(stationary);
        }

        public Small(boolean stationary, float brightness) {
            super(stationary, brightness);
        }

        public Small(boolean stationary, float red, float green, float blue) {
            super(stationary, red, green, blue);
        }

        @Override
        @NotNull
        protected CRParticleTypes getParticleType() {
            return CRParticleTypes.SMOKE_PUFF_SMALL;
        }

        @Override
        public MapCodec<Small> getCodec(ParticleType<Small> type) {
            return CODEC;
        }

        @Override
        public StreamCodec<FriendlyByteBuf, Small> getStreamCodec() {
            return STREAM_CODEC;
        }

        @Override
        public ParticleEngine.SpriteParticleRegistration<Small> getMetaFactory() {
            return PuffSmokeParticle.Factory::new;
        }

        @Override
        public float getQuadSize() {
            return 0.5f;
        }
    }

    public static class Medium
    extends PuffSmokeParticleData<Medium> {
        public static final MapCodec<Medium> CODEC = Medium.makeCodec(Medium::new);
        public static final StreamCodec<FriendlyByteBuf, Medium> STREAM_CODEC = new StreamCodec<FriendlyByteBuf, Medium>(){

            public void encode(FriendlyByteBuf buffer, Medium data) {
                buffer.writeBoolean(data.stationary);
                buffer.writeFloat(data.red);
                buffer.writeFloat(data.green);
                buffer.writeFloat(data.blue);
            }

            public Medium decode(FriendlyByteBuf buffer) {
                return new Medium(buffer.readBoolean(), buffer.readFloat(), buffer.readFloat(), buffer.readFloat());
            }
        };

        public Medium() {
        }

        public Medium(float red, float green, float blue) {
            super(red, green, blue);
        }

        public Medium(boolean stationary) {
            super(stationary);
        }

        public Medium(boolean stationary, float brightness) {
            super(stationary, brightness);
        }

        public Medium(boolean stationary, float red, float green, float blue) {
            super(stationary, red, green, blue);
        }

        @Override
        @NotNull
        protected CRParticleTypes getParticleType() {
            return CRParticleTypes.SMOKE_PUFF_MEDIUM;
        }

        @Override
        public MapCodec<Medium> getCodec(ParticleType<Medium> type) {
            return CODEC;
        }

        @Override
        public StreamCodec<FriendlyByteBuf, Medium> getStreamCodec() {
            return STREAM_CODEC;
        }

        @Override
        public ParticleEngine.SpriteParticleRegistration<Medium> getMetaFactory() {
            return PuffSmokeParticle.Factory::new;
        }

        @Override
        public float getQuadSize() {
            return 1.0f;
        }
    }
}

