/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.content.smokestack.particles.legacy;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.railwayteam.railways.content.smokestack.particles.legacy.SmokeParticle;
import com.railwayteam.railways.registry.CRParticleTypes;
import com.simibubi.create.foundation.particle.ICustomParticleDataWithSprite;
import java.util.Locale;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;

public class SmokeParticleData
implements ParticleOptions,
ICustomParticleDataWithSprite<SmokeParticleData> {
    public static final MapCodec<SmokeParticleData> CODEC = RecordCodecBuilder.mapCodec(i -> i.group((App)Codec.BOOL.fieldOf("stationary").forGetter(p -> p.stationary), (App)Codec.FLOAT.fieldOf("red").forGetter(p -> Float.valueOf(p.red)), (App)Codec.FLOAT.fieldOf("green").forGetter(p -> Float.valueOf(p.green)), (App)Codec.FLOAT.fieldOf("blue").forGetter(p -> Float.valueOf(p.blue))).apply((Applicative)i, SmokeParticleData::new));
    public static final StreamCodec<FriendlyByteBuf, SmokeParticleData> STREAM_CODEC = new StreamCodec<FriendlyByteBuf, SmokeParticleData>(){

        public void encode(FriendlyByteBuf buffer, SmokeParticleData data) {
            buffer.writeBoolean(data.stationary);
            buffer.writeFloat(data.red);
            buffer.writeFloat(data.green);
            buffer.writeFloat(data.blue);
        }

        public SmokeParticleData decode(FriendlyByteBuf buffer) {
            return new SmokeParticleData(buffer.readBoolean(), buffer.readFloat(), buffer.readFloat(), buffer.readFloat());
        }
    };
    boolean stationary;
    float red;
    float green;
    float blue;

    public SmokeParticleData() {
        this(false);
    }

    public SmokeParticleData(float red, float green, float blue) {
        this(false, red, green, blue);
    }

    public SmokeParticleData(boolean stationary) {
        this(stationary, stationary ? 0.3f : 0.1f);
    }

    public SmokeParticleData(boolean stationary, float brightness) {
        this(stationary, brightness, brightness, brightness);
    }

    public SmokeParticleData(boolean stationary, float red, float green, float blue) {
        this.stationary = stationary;
        this.red = red;
        this.green = green;
        this.blue = blue;
    }

    public ParticleType<?> getType() {
        return CRParticleTypes.SMOKE.get();
    }

    public void writeToNetwork(FriendlyByteBuf buffer) {
        buffer.writeBoolean(this.stationary);
        buffer.writeFloat(this.red);
        buffer.writeFloat(this.green);
        buffer.writeFloat(this.blue);
    }

    public String writeToString() {
        return String.format(Locale.ROOT, "%s %b %f %f %f", CRParticleTypes.SMOKE.parameter(), this.stationary, Float.valueOf(this.red), Float.valueOf(this.green), Float.valueOf(this.blue));
    }

    public MapCodec<SmokeParticleData> getCodec(ParticleType<SmokeParticleData> type) {
        return CODEC;
    }

    public StreamCodec<FriendlyByteBuf, SmokeParticleData> getStreamCodec() {
        return STREAM_CODEC;
    }

    public ParticleEngine.SpriteParticleRegistration<SmokeParticleData> getMetaFactory() {
        return SmokeParticle.Factory::new;
    }
}

