/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.content.smokestack.particles.legacy;

import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import com.railwayteam.railways.config.CRConfigs;
import com.railwayteam.railways.content.smokestack.particles.legacy.SmokeParticleData;
import net.createmod.catnip.animation.LerpedFloat;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SimpleAnimatedParticle;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public class SmokeParticle
extends SimpleAnimatedParticle {
    private LerpedFloat ascendScale = LerpedFloat.linear().startWithValue(1.0);
    private double baseYd;
    private final boolean stationarySource;

    protected SmokeParticle(ClientLevel world, SmokeParticleData data, double x, double y, double z, double dx, double dy, double dz, SpriteSet sprite) {
        super(world, x, y, z, sprite, world.random.nextFloat() * 0.5f);
        double scale = 0.1;
        this.xd = dx * scale;
        this.baseYd = this.yd = dy * scale + (double)(this.random.nextFloat() / 500.0f);
        this.zd = dz * scale;
        this.gravity = 3.0E-6f;
        this.quadSize = 1.5f;
        this.setLifetime(data.stationary ? 400 : (Integer)CRConfigs.client().smokeLifetime.get());
        this.setPos(x, y, z);
        this.roll = this.oRoll = world.random.nextFloat() * (float)Math.PI;
        this.setSprite(sprite.get(((SmokeQuality)((Object)CRConfigs.client().smokeQuality.get())).ordinal(), SmokeQuality.values().length - 1));
        this.alpha = data.stationary ? 0.25f : 0.1f;
        this.ascendScale.chase(data.stationary ? 0.3 : 0.1, data.stationary ? 0.001 : 0.03, LerpedFloat.Chaser.EXP);
        this.rCol = data.red;
        this.gCol = data.green;
        this.bCol = data.blue;
        this.stationarySource = data.stationary;
    }

    @NotNull
    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_TRANSLUCENT;
    }

    public void tick() {
        float diffusionScale;
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        if (this.age++ >= this.lifetime || this.alpha <= 0.0f) {
            this.remove();
            return;
        }
        float f = diffusionScale = this.stationarySource ? 800.0f : 500.0f;
        if (this.age > 350) {
            diffusionScale = 5000.0f;
        } else if (this.age > 300) {
            diffusionScale = Mth.lerp((float)((float)(this.age - 300) / 50.0f), (float)(this.stationarySource ? 800.0f : 500.0f), (float)5000.0f);
        }
        this.xd += (double)(this.random.nextFloat() / diffusionScale * (float)(this.random.nextBoolean() ? 1 : -1));
        this.zd += (double)(this.random.nextFloat() / diffusionScale * (float)(this.random.nextBoolean() ? 1 : -1));
        this.yd = this.baseYd * (double)this.ascendScale.getValue();
        this.ascendScale.tickChaser();
        this.move(this.xd, this.yd, this.zd);
        if (this.age >= this.lifetime - 100 && this.alpha > 0.01f) {
            this.alpha -= 0.015f;
        }
    }

    public void render(@NotNull VertexConsumer buffer, @NotNull Camera renderInfo, float partialTicks) {
        this.render(buffer, renderInfo, partialTicks, 0.0f, 1.0f, 1.0f);
        if (((Boolean)CRConfigs.client().thickerSmoke.get()).booleanValue()) {
            this.render(buffer, renderInfo, partialTicks, 0.3f, 0.5f, 0.75f);
            this.render(buffer, renderInfo, partialTicks, -0.3f, 0.5f, 0.75f);
        }
    }

    private void render(VertexConsumer buffer, Camera renderInfo, float partialTicks, float offsetDepth, float size, float alphaFactor) {
        Quaternionf quaternion;
        Vec3 vec3 = renderInfo.getPosition();
        float f = (float)(Mth.lerp((double)partialTicks, (double)this.xo, (double)this.x) - vec3.x());
        float g = (float)(Mth.lerp((double)partialTicks, (double)this.yo, (double)this.y) - vec3.y());
        float h = (float)(Mth.lerp((double)partialTicks, (double)this.zo, (double)this.z) - vec3.z());
        if (this.roll == 0.0f) {
            quaternion = renderInfo.rotation();
        } else {
            quaternion = new Quaternionf((Quaternionfc)renderInfo.rotation());
            float i = Mth.lerp((float)partialTicks, (float)this.oRoll, (float)this.roll);
            quaternion.mul((Quaternionfc)Axis.ZP.rotation(i));
        }
        Vector3f[] vector3fs = new Vector3f[]{new Vector3f(-size, -size, offsetDepth), new Vector3f(-size, size, offsetDepth), new Vector3f(size, size, offsetDepth), new Vector3f(size, -size, offsetDepth)};
        float j = this.getQuadSize(partialTicks);
        for (int k = 0; k < 4; ++k) {
            Vector3f vector3f2 = vector3fs[k];
            vector3f2.rotate((Quaternionfc)quaternion);
            vector3f2.mul(j);
            vector3f2.add(f, g, h);
        }
        float l = this.getU0();
        float m = this.getU1();
        float n = this.getV0();
        float o = this.getV1();
        int p = this.getLightColor(partialTicks);
        buffer.addVertex(vector3fs[0].x(), vector3fs[0].y(), vector3fs[0].z()).setUv(m, o).setColor(this.rCol, this.gCol, this.bCol, this.alpha * alphaFactor).setLight(p);
        buffer.addVertex(vector3fs[1].x(), vector3fs[1].y(), vector3fs[1].z()).setUv(m, n).setColor(this.rCol, this.gCol, this.bCol, this.alpha * alphaFactor).setLight(p);
        buffer.addVertex(vector3fs[2].x(), vector3fs[2].y(), vector3fs[2].z()).setUv(l, n).setColor(this.rCol, this.gCol, this.bCol, this.alpha * alphaFactor).setLight(p);
        buffer.addVertex(vector3fs[3].x(), vector3fs[3].y(), vector3fs[3].z()).setUv(l, o).setColor(this.rCol, this.gCol, this.bCol, this.alpha * alphaFactor).setLight(p);
    }

    public int getLightColor(float partialTick) {
        BlockPos blockpos = BlockPos.containing((double)this.x, (double)this.y, (double)this.z);
        return this.level.isLoaded(blockpos) ? LevelRenderer.getLightColor((BlockAndTintGetter)this.level, (BlockPos)blockpos) : 0;
    }

    public static enum SmokeQuality {
        LOW("smoke_16"),
        MEDIUM("smoke_32"),
        HIGH("smoke_64"),
        ULTRA("smoke");

        public final String name;

        private SmokeQuality(String name) {
            this.name = name;
        }
    }

    public static class Factory
    implements ParticleProvider<SmokeParticleData> {
        private final SpriteSet spriteSet;

        public Factory(SpriteSet animatedSprite) {
            this.spriteSet = animatedSprite;
        }

        public Particle createParticle(SmokeParticleData data, ClientLevel worldIn, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            return new SmokeParticle(worldIn, data, x, y, z, xSpeed, ySpeed, zSpeed, this.spriteSet);
        }
    }
}

