/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.content.smokestack.particles.chimneypush;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.railwayteam.railways.content.smokestack.particles.chimneypush.ChimneyPushParticle;
import com.railwayteam.railways.registry.CRParticleTypes;
import com.simibubi.create.foundation.particle.ICustomParticleDataWithSprite;
import java.util.Locale;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.DyeColor;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public abstract class ChimneyPushParticleData<T extends ChimneyPushParticleData<T>>
implements ParticleOptions,
ICustomParticleDataWithSprite<T> {
    boolean leadOnly;
    float red;
    float green;
    float blue;

    protected static <T extends ChimneyPushParticleData<T>> MapCodec<T> makeCodec(Constructor<T> constructor) {
        return RecordCodecBuilder.mapCodec(i -> i.group((App)Codec.BOOL.fieldOf("leadOnly").forGetter(p -> p.leadOnly), (App)Codec.FLOAT.fieldOf("red").forGetter(p -> Float.valueOf(p.red)), (App)Codec.FLOAT.fieldOf("green").forGetter(p -> Float.valueOf(p.green)), (App)Codec.FLOAT.fieldOf("blue").forGetter(p -> Float.valueOf(p.blue))).apply((Applicative)i, constructor::create));
    }

    protected ChimneyPushParticleData() {
        this(false);
    }

    protected ChimneyPushParticleData(float red, float green, float blue) {
        this(false, red, green, blue);
    }

    protected ChimneyPushParticleData(boolean leadOnly) {
        this(leadOnly, -1.0f);
    }

    protected ChimneyPushParticleData(boolean leadOnly, float brightness) {
        this(leadOnly, brightness, brightness, brightness);
    }

    protected ChimneyPushParticleData(boolean leadOnly, float red, float green, float blue) {
        this.leadOnly = leadOnly;
        this.red = red;
        this.green = green;
        this.blue = blue;
    }

    @NotNull
    protected abstract CRParticleTypes getParticleType();

    @NotNull
    public ParticleType<?> getType() {
        return this.getParticleType().get();
    }

    public void writeToNetwork(FriendlyByteBuf buffer) {
        buffer.writeBoolean(this.leadOnly);
        buffer.writeFloat(this.red);
        buffer.writeFloat(this.green);
        buffer.writeFloat(this.blue);
    }

    @NotNull
    public String writeToString() {
        return String.format(Locale.ROOT, "%s %b %f %f %f", this.getParticleType().parameter(), this.leadOnly, Float.valueOf(this.red), Float.valueOf(this.green), Float.valueOf(this.blue));
    }

    public abstract MapCodec<T> getCodec(ParticleType<T> var1);

    public abstract StreamCodec<FriendlyByteBuf, T> getStreamCodec();

    public abstract ParticleEngine.SpriteParticleRegistration<T> getMetaFactory();

    public abstract float getQuadSize();

    public static ChimneyPushParticleData<?> create(boolean small, boolean leadOnly, @NotNull DyeColor color) {
        float idx = -(2 + color.getId());
        return ChimneyPushParticleData.create(small, leadOnly, idx, idx, idx);
    }

    public static ChimneyPushParticleData<?> create(boolean small, boolean leadOnly, float red, float green, float blue) {
        if (small) {
            return new Small(leadOnly, red, green, blue);
        }
        return new Medium(leadOnly, red, green, blue);
    }

    public static ChimneyPushParticleData<?> create(boolean small, boolean leadOnly) {
        if (small) {
            return new Small(leadOnly);
        }
        return new Medium(leadOnly);
    }

    @FunctionalInterface
    protected static interface Constructor<T extends ChimneyPushParticleData<T>> {
        @Contract(value="_, _, _, _ -> new")
        public T create(boolean var1, float var2, float var3, float var4);
    }

    public static class Small
    extends ChimneyPushParticleData<Small> {
        public static final MapCodec<Small> CODEC = Small.makeCodec(Small::new);
        public static final StreamCodec<FriendlyByteBuf, Small> STREAM_CODEC = new StreamCodec<FriendlyByteBuf, Small>(){

            public void encode(FriendlyByteBuf buffer, Small data) {
                buffer.writeBoolean(data.leadOnly);
                buffer.writeFloat(data.red);
                buffer.writeFloat(data.green);
                buffer.writeFloat(data.blue);
            }

            public Small decode(FriendlyByteBuf buffer) {
                return new Small(buffer.readBoolean(), buffer.readFloat(), buffer.readFloat(), buffer.readFloat());
            }
        };

        public Small() {
        }

        public Small(float red, float green, float blue) {
            super(red, green, blue);
        }

        public Small(boolean leadOnly) {
            super(leadOnly);
        }

        public Small(boolean leadOnly, float brightness) {
            super(leadOnly, brightness);
        }

        public Small(boolean leadOnly, float red, float green, float blue) {
            super(leadOnly, red, green, blue);
        }

        @Override
        @NotNull
        protected CRParticleTypes getParticleType() {
            return CRParticleTypes.CHIMNEYPUSH_SMALL;
        }

        @Override
        public MapCodec<Small> getCodec(ParticleType<Small> type) {
            return CODEC;
        }

        @Override
        public StreamCodec<FriendlyByteBuf, Small> getStreamCodec() {
            return STREAM_CODEC;
        }

        @Override
        public ParticleEngine.SpriteParticleRegistration<Small> getMetaFactory() {
            return ChimneyPushParticle.Factory::new;
        }

        @Override
        public float getQuadSize() {
            return 0.5f;
        }
    }

    public static class Medium
    extends ChimneyPushParticleData<Medium> {
        public static final MapCodec<Medium> CODEC = Medium.makeCodec(Medium::new);
        public static final StreamCodec<FriendlyByteBuf, Medium> STREAM_CODEC = new StreamCodec<FriendlyByteBuf, Medium>(){

            public void encode(FriendlyByteBuf buffer, Medium data) {
                buffer.writeBoolean(data.leadOnly);
                buffer.writeFloat(data.red);
                buffer.writeFloat(data.green);
                buffer.writeFloat(data.blue);
            }

            public Medium decode(FriendlyByteBuf buffer) {
                return new Medium(buffer.readBoolean(), buffer.readFloat(), buffer.readFloat(), buffer.readFloat());
            }
        };

        public Medium() {
        }

        public Medium(float red, float green, float blue) {
            super(red, green, blue);
        }

        public Medium(boolean leadOnly) {
            super(leadOnly);
        }

        public Medium(boolean leadOnly, float brightness) {
            super(leadOnly, brightness);
        }

        public Medium(boolean leadOnly, float red, float green, float blue) {
            super(leadOnly, red, green, blue);
        }

        @Override
        @NotNull
        protected CRParticleTypes getParticleType() {
            return CRParticleTypes.CHIMNEYPUSH_MEDIUM;
        }

        @Override
        public MapCodec<Medium> getCodec(ParticleType<Medium> type) {
            return CODEC;
        }

        @Override
        public StreamCodec<FriendlyByteBuf, Medium> getStreamCodec() {
            return STREAM_CODEC;
        }

        @Override
        public ParticleEngine.SpriteParticleRegistration<Medium> getMetaFactory() {
            return ChimneyPushParticle.Factory::new;
        }

        @Override
        public float getQuadSize() {
            return 1.25f;
        }
    }
}

