/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.content.smokestack.block.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.railwayteam.railways.content.smokestack.block.DieselSmokeStackBlock;
import com.railwayteam.railways.content.smokestack.block.be.DieselSmokeStackBlockEntity;
import com.railwayteam.railways.registry.CRBlockPartials;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.renderer.SmartBlockEntityRenderer;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import net.createmod.catnip.render.CachedBuffers;
import net.createmod.catnip.render.SuperByteBuffer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class DieselSmokeStackRenderer
extends SmartBlockEntityRenderer<DieselSmokeStackBlockEntity> {
    public DieselSmokeStackRenderer(BlockEntityRendererProvider.Context context) {
        super(context);
    }

    protected void renderSafe(DieselSmokeStackBlockEntity be, float partialTicks, PoseStack ms, MultiBufferSource buffer, int light, int overlay) {
        super.renderSafe((SmartBlockEntity)be, partialTicks, ms, buffer, light, overlay);
        Direction dir = (Direction)be.getBlockState().getValue((Property)DieselSmokeStackBlock.FACING);
        SuperByteBuffer byteBuffer = CachedBuffers.partial((PartialModel)CRBlockPartials.DIESEL_STACK_FAN, (BlockState)be.getBlockState());
        byteBuffer.light(light);
        float fanAngle = (float)be.getFanRotation(be.getRpm(partialTicks));
        byteBuffer.translate(0.5, 0.5, 0.5);
        switch (dir) {
            case UP: {
                break;
            }
            case DOWN: {
                byteBuffer.rotateXDegrees(180.0f);
                break;
            }
            case NORTH: {
                byteBuffer.rotateXDegrees(90.0f);
                break;
            }
            case SOUTH: {
                byteBuffer.rotateXDegrees(-90.0f);
                break;
            }
            case EAST: {
                byteBuffer.rotateZDegrees(-90.0f);
                break;
            }
            case WEST: {
                byteBuffer.rotateZDegrees(90.0f);
            }
        }
        byteBuffer.rotateYDegrees(fanAngle);
        float yOffset = switch (dir) {
            case Direction.NORTH -> 0.8f;
            case Direction.SOUTH -> 0.8f;
            default -> 0.0f;
        };
        byteBuffer.translate(-0.5, -0.5 + (double)yOffset, -0.5);
        byteBuffer.renderInto(ms, buffer.getBuffer(RenderType.cutout()));
    }
}

