/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.content.handcar;

import com.railwayteam.railways.Railways;
import com.railwayteam.railways.content.handcar.HandcarBlock;
import com.railwayteam.railways.mixin_interfaces.IDeployAnywayBlockItem;
import com.railwayteam.railways.mixin_interfaces.IHandcarTrain;
import com.railwayteam.railways.registry.CRPackets;
import com.railwayteam.railways.registry.CRTrackMaterials;
import com.railwayteam.railways.util.packet.CurvedTrackHandcarPlacementPacket;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.Create;
import com.simibubi.create.content.contraptions.actors.seat.SeatBlock;
import com.simibubi.create.content.trains.bogey.AbstractBogeyBlock;
import com.simibubi.create.content.trains.entity.AddTrainPacket;
import com.simibubi.create.content.trains.entity.Carriage;
import com.simibubi.create.content.trains.entity.CarriageBogey;
import com.simibubi.create.content.trains.entity.CarriageContraption;
import com.simibubi.create.content.trains.entity.Train;
import com.simibubi.create.content.trains.entity.TravellingPoint;
import com.simibubi.create.content.trains.graph.TrackEdge;
import com.simibubi.create.content.trains.graph.TrackGraph;
import com.simibubi.create.content.trains.graph.TrackGraphHelper;
import com.simibubi.create.content.trains.graph.TrackGraphLocation;
import com.simibubi.create.content.trains.graph.TrackNode;
import com.simibubi.create.content.trains.graph.TrackNodeLocation;
import com.simibubi.create.content.trains.track.BezierConnection;
import com.simibubi.create.content.trains.track.BezierTrackPointLocation;
import com.simibubi.create.content.trains.track.ITrackBlock;
import com.simibubi.create.content.trains.track.TrackBlockEntity;
import com.simibubi.create.content.trains.track.TrackBlockOutline;
import com.simibubi.create.content.trains.track.TrackMaterial;
import com.simibubi.create.content.trains.track.TrackTargetingBlockItem;
import com.simibubi.create.foundation.utility.CreateLang;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.function.BiConsumer;
import net.createmod.catnip.data.Couple;
import net.createmod.catnip.data.Pair;
import net.createmod.catnip.platform.CatnipServices;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.apache.commons.lang3.mutable.MutableObject;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HandcarItem
extends BlockItem
implements IDeployAnywayBlockItem {
    public HandcarItem(Block block, Item.Properties properties) {
        super(block, properties);
    }

    private HandcarBlock getBogeyBlock() {
        return (HandcarBlock)this.getBlock();
    }

    @NotNull
    public InteractionResult useOn(@NotNull UseOnContext context) {
        ItemStack stack = context.getItemInHand();
        BlockPos pos = context.getClickedPos();
        Level level = context.getLevel();
        BlockState state = level.getBlockState(pos);
        Player player = context.getPlayer();
        if (player == null) {
            return InteractionResult.FAIL;
        }
        Block block = state.getBlock();
        if (block instanceof ITrackBlock) {
            Direction.Axis axis;
            ITrackBlock track = (ITrackBlock)block;
            TrackMaterial.TrackType trackType = track.getMaterial().trackType;
            if (trackType != TrackMaterial.TrackType.STANDARD && trackType != CRTrackMaterials.CRTrackType.UNIVERSAL) {
                return InteractionResult.FAIL;
            }
            if (level.isClientSide) {
                return InteractionResult.SUCCESS;
            }
            Vec3 lookAngle = player.getLookAngle();
            Pair nearestAxis = track.getNearestTrackAxis((BlockGetter)level, pos, state, lookAngle);
            Vec3 axisVec = (Vec3)nearestAxis.getFirst();
            boolean front = nearestAxis.getSecond() == Direction.AxisDirection.POSITIVE;
            Direction.Axis axis2 = axis = Math.abs(axisVec.x) > Math.abs(axisVec.z) ? Direction.Axis.X : Direction.Axis.Z;
            Direction assemblyDirection = axis == Direction.Axis.X ? (front ? Direction.EAST : Direction.WEST) : (front ? Direction.SOUTH : Direction.NORTH);
            MutableObject result = new MutableObject(null);
            MutableObject resultLoc = new MutableObject(null);
            HandcarItem.withGraphLocation(level, pos, front, null, (overlap, location) -> {
                result.setValue(overlap);
                resultLoc.setValue(location);
            });
            if (((TrackTargetingBlockItem.OverlapResult)result.getValue()).feedback != null) {
                player.displayClientMessage((Component)CreateLang.translateDirect((String)((TrackTargetingBlockItem.OverlapResult)result.getValue()).feedback, (Object[])new Object[0]).withStyle(ChatFormatting.RED), true);
                AllSoundEvents.DENY.play(level, null, (Vec3i)pos, 0.5f, 1.0f);
                return InteractionResult.FAIL;
            }
            TrackGraphLocation loc = (TrackGraphLocation)resultLoc.getValue();
            if (loc == null) {
                return InteractionResult.FAIL;
            }
            boolean success = this.placeHandcar(loc, level, player, pos, assemblyDirection);
            if (success) {
                stack.shrink(1);
            }
            return success ? InteractionResult.SUCCESS : InteractionResult.FAIL;
        }
        return InteractionResult.PASS;
    }

    @ApiStatus.Internal
    @NotNull
    public boolean placeHandcar(TrackGraphLocation trackGraphLocation, Level level, Player player, BlockPos soundPos, Direction assemblyDirection) {
        TrackGraph graph = trackGraphLocation.graph;
        TrackNode node1 = graph.locateNode((TrackNodeLocation)trackGraphLocation.edge.getFirst());
        TrackNode node2 = graph.locateNode((TrackNodeLocation)trackGraphLocation.edge.getSecond());
        if (node1 == null || node2 == null) {
            return false;
        }
        TrackEdge edge = (TrackEdge)graph.getConnectionsFrom(node1).get(node2);
        if (edge == null) {
            return false;
        }
        double offset = this.getBogeyBlock().getWheelPointSpacing() / 2.0;
        TravellingPoint tp1 = new TravellingPoint(node1, node2, edge, trackGraphLocation.position, false);
        TravellingPoint tp2 = new TravellingPoint(node1, node2, edge, trackGraphLocation.position, false);
        tp1.travel(graph, offset, tp1.steer(TravellingPoint.SteerDirection.NONE, new Vec3(0.0, 1.0, 0.0)));
        tp2.travel(graph, -offset, tp2.steer(TravellingPoint.SteerDirection.NONE, new Vec3(0.0, 1.0, 0.0)));
        if (!(level instanceof ServerLevel)) {
            return false;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        Train train = this.makeTrain(player.getUUID(), graph, tp1, tp2, serverLevel, soundPos, assemblyDirection);
        if (train == null) {
            return false;
        }
        AllSoundEvents.CONTROLLER_CLICK.play(level, null, (Vec3i)soundPos, 1.0f, 1.0f);
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean useOnCurve(TrackBlockOutline.BezierPointSelection selection, ItemStack stack) {
        Minecraft mc = Minecraft.getInstance();
        LocalPlayer player = mc.player;
        TrackBlockEntity be = selection.blockEntity();
        BezierTrackPointLocation loc = selection.loc();
        boolean front = player.getLookAngle().dot(selection.direction()) < 0.0;
        BezierConnection bc = (BezierConnection)be.getConnections().get(loc.curveTarget());
        TrackMaterial.TrackType trackType = bc.getMaterial().trackType;
        if (trackType != TrackMaterial.TrackType.STANDARD && trackType != CRTrackMaterials.CRTrackType.UNIVERSAL) {
            return false;
        }
        CRPackets.PACKETS.send(new CurvedTrackHandcarPlacementPacket(be.getBlockPos(), loc.curveTarget(), loc.segment(), front, player.getInventory().selected));
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private Train makeTrain(UUID owner, TrackGraph graph, TravellingPoint tp1, TravellingPoint tp2, ServerLevel level, BlockPos referencePos, Direction assemblyDirection) {
        BlockPos tempOrigin;
        HandcarBlock handcarBlock = this.getBogeyBlock();
        CarriageContraption contraption = new CarriageContraption(assemblyDirection);
        BlockPos handcarWorldPos = tempOrigin = new BlockPos(referencePos.getX(), level.getMaxBuildHeight() - 5, referencePos.getZ());
        Direction safeAssemblyDirection = assemblyDirection.getAxis().isVertical() ? Direction.EAST : assemblyDirection;
        BlockPos seatWorldPos = tempOrigin.relative(safeAssemblyDirection);
        BlockState handcarState = (BlockState)handcarBlock.defaultBlockState().setValue((Property)AbstractBogeyBlock.AXIS, (Comparable)safeAssemblyDirection.getAxis());
        BlockState seatState = ((SeatBlock)AllBlocks.SEATS.get(DyeColor.RED).get()).defaultBlockState();
        level.setBlock(handcarWorldPos, handcarState, 18);
        level.setBlock(seatWorldPos, seatState, 18);
        boolean assembled = false;
        try {
            assembled = contraption.assemble((Level)level, handcarWorldPos);
        }
        catch (Throwable t) {
            Railways.LOGGER.error("Failed to assemble handcar contraption", t);
        }
        finally {
            level.setBlock(handcarWorldPos, Blocks.AIR.defaultBlockState(), 18);
            level.setBlock(seatWorldPos, Blocks.AIR.defaultBlockState(), 18);
        }
        if (!assembled) {
            return null;
        }
        CompoundTag handcarNbt = new CompoundTag();
        CompoundTag bogeyData = new CompoundTag();
        bogeyData.putBoolean("UpsideDown", false);
        bogeyData.putString("BogeyStyle", "railways:handcar");
        handcarNbt.put("BogeyData", (Tag)bogeyData);
        handcarNbt.putString("id", "railways:bogey");
        BlockPos localHandcarPos = BlockPos.ZERO;
        BlockPos localSeatPos = seatWorldPos.subtract((Vec3i)handcarWorldPos);
        StructureTemplate.StructureBlockInfo info = (StructureTemplate.StructureBlockInfo)contraption.getBlocks().get(localHandcarPos);
        if (info != null) {
            contraption.getBlocks().put(localHandcarPos, new StructureTemplate.StructureBlockInfo(localHandcarPos, info.state(), handcarNbt));
        }
        if (!contraption.getSeats().contains(localSeatPos)) {
            contraption.getSeats().add(localSeatPos);
        }
        CarriageBogey bogey = new CarriageBogey((AbstractBogeyBlock)handcarBlock, false, new CompoundTag(), tp1, tp2);
        Carriage carriage = new Carriage(bogey, null, 0);
        Train train = new Train(UUID.randomUUID(), owner, graph, List.of(carriage), new ArrayList(), true, 0);
        ((IHandcarTrain)train).railways$setHandcar(true);
        carriage.setContraption((Level)level, contraption);
        train.name = Component.translatable((String)"block.railways.handcar");
        train.collectInitiallyOccupiedSignalBlocks();
        Create.RAILWAYS.addTrain(train);
        CatnipServices.NETWORK.sendToAllClients((CustomPacketPayload)new AddTrainPacket(train));
        return train;
    }

    public static void withGraphLocation(Level level, BlockPos pos, boolean front, BezierTrackPointLocation targetBezier, BiConsumer<TrackTargetingBlockItem.OverlapResult, TrackGraphLocation> callback) {
        TrackGraphLocation location;
        BlockState state = level.getBlockState(pos);
        Block block = state.getBlock();
        if (!(block instanceof ITrackBlock)) {
            callback.accept(TrackTargetingBlockItem.OverlapResult.NO_TRACK, null);
            return;
        }
        ITrackBlock track = (ITrackBlock)block;
        List trackAxes = track.getTrackAxes((BlockGetter)level, pos, state);
        if (targetBezier == null && trackAxes.size() > 1) {
            callback.accept(TrackTargetingBlockItem.OverlapResult.JUNCTION, null);
            return;
        }
        Direction.AxisDirection targetDirection = front ? Direction.AxisDirection.POSITIVE : Direction.AxisDirection.NEGATIVE;
        TrackGraphLocation trackGraphLocation = location = targetBezier != null ? TrackGraphHelper.getBezierGraphLocationAt((Level)level, (BlockPos)pos, (Direction.AxisDirection)targetDirection, (BezierTrackPointLocation)targetBezier) : TrackGraphHelper.getGraphLocationAt((Level)level, (BlockPos)pos, (Direction.AxisDirection)targetDirection, (Vec3)((Vec3)trackAxes.get(0)));
        if (location == null) {
            callback.accept(TrackTargetingBlockItem.OverlapResult.NO_TRACK, null);
            return;
        }
        Couple nodes = location.edge.map(arg_0 -> ((TrackGraph)location.graph).locateNode(arg_0));
        TrackEdge edge = location.graph.getConnection(nodes);
        if (edge == null) {
            return;
        }
        callback.accept(TrackTargetingBlockItem.OverlapResult.VALID, location);
    }
}

