/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.content.custom_bogeys.special.monobogey;

import com.google.common.collect.ImmutableSet;
import com.railwayteam.railways.content.custom_bogeys.special.monobogey.AbstractMonoBogeyBlock;
import com.railwayteam.railways.content.custom_bogeys.special.monobogey.InvisibleMonoBogeyBlockEntity;
import com.railwayteam.railways.registry.CRBlockEntities;
import com.railwayteam.railways.registry.CRBogeyStyles;
import com.railwayteam.railways.registry.CRShapes;
import com.railwayteam.railways.registry.CRTrackMaterials;
import com.simibubi.create.content.trains.bogey.BogeyStyle;
import com.simibubi.create.content.trains.entity.Carriage;
import com.simibubi.create.content.trains.entity.CarriageBogey;
import com.simibubi.create.content.trains.entity.TravellingPoint;
import com.simibubi.create.content.trains.track.TrackMaterial;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class InvisibleMonoBogeyBlock
extends AbstractMonoBogeyBlock<InvisibleMonoBogeyBlockEntity> {
    public InvisibleMonoBogeyBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
    }

    public BogeyStyle getDefaultStyle() {
        return CRBogeyStyles.INVISIBLE_MONOBOGEY;
    }

    public Class<InvisibleMonoBogeyBlockEntity> getBlockEntityClass() {
        return InvisibleMonoBogeyBlockEntity.class;
    }

    public BlockEntityType<? extends InvisibleMonoBogeyBlockEntity> getBlockEntityType() {
        return (BlockEntityType)CRBlockEntities.INVISIBLE_MONO_BOGEY.get();
    }

    public boolean isOnIncompatibleTrack(Carriage carriage, boolean leading) {
        TravellingPoint point = leading ? carriage.getLeadingPoint() : carriage.getTrailingPoint();
        CarriageBogey bogey = leading ? carriage.leadingBogey() : carriage.trailingBogey();
        return point.edge.getTrackMaterial().trackType != this.getTrackType(bogey.getStyle()) && point.edge.getTrackMaterial().trackType != CRTrackMaterials.CRTrackType.WIDE_GAUGE && point.edge.getTrackMaterial().trackType != CRTrackMaterials.CRTrackType.NARROW_GAUGE && point.edge.getTrackMaterial().trackType != CRTrackMaterials.CRTrackType.STANDARD;
    }

    public Set<TrackMaterial.TrackType> getValidPathfindingTypes(BogeyStyle style) {
        return ImmutableSet.of((Object)this.getTrackType(style), (Object)CRTrackMaterials.CRTrackType.WIDE_GAUGE, (Object)CRTrackMaterials.CRTrackType.NARROW_GAUGE, (Object)CRTrackMaterials.CRTrackType.STANDARD);
    }

    @NotNull
    public VoxelShape getShape(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        if (state.hasProperty((Property)UPSIDE_DOWN) && ((Boolean)state.getValue((Property)UPSIDE_DOWN)).booleanValue()) {
            return CRShapes.shape(0.0, 0.0, 0.0, 16.0, 9.0, 16.0).build();
        }
        return CRShapes.shape(0.0, 7.0, 0.0, 16.0, 16.0, 16.0).build();
    }
}

