/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.content.custom_bogeys.renderer.unified.impl;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.railwayteam.railways.content.custom_bogeys.renderer.unified.BogeyDisplay;
import com.railwayteam.railways.content.custom_bogeys.renderer.unified.BogeyDisplayHolder;
import com.railwayteam.railways.content.custom_bogeys.renderer.unified.impl.RenderedElement;
import com.railwayteam.railways.content.custom_bogeys.renderer.unified.impl.RenderedElementProvider;
import com.simibubi.create.content.trains.bogey.BogeyRenderer;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import net.createmod.catnip.data.Couple;
import net.createmod.catnip.render.CachedBuffers;
import net.createmod.catnip.render.SuperByteBuffer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;

@ApiStatus.Internal
public class UnifiedBogeyRenderer
implements BogeyRenderer,
BogeyDisplayHolder {
    private final Couple<Renderer> renderers = Couple.createWithContext(inContraption -> Renderer.create(factory, inContraption));
    @Nullable
    private final BogeyRenderer customRenderer;

    public UnifiedBogeyRenderer(BogeyDisplay.Factory factory) {
        this.customRenderer = factory.createCustomRenderer();
    }

    @Override
    public void runWithDisplay(Consumer<BogeyDisplay> consumer) {
        consumer.accept(((Renderer)this.renderers.getFirst()).display);
        consumer.accept(((Renderer)this.renderers.getSecond()).display);
        BogeyRenderer bogeyRenderer = this.customRenderer;
        if (bogeyRenderer instanceof BogeyDisplayHolder) {
            BogeyDisplayHolder customDisplayHolder = (BogeyDisplayHolder)bogeyRenderer;
            customDisplayHolder.runWithDisplay(consumer);
        }
    }

    public void render(CompoundTag bogeyData, float wheelAngle, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay, boolean inContraption) {
        Matrix4f mat;
        VertexConsumer buffer = bufferSource.getBuffer(RenderType.cutoutMipped());
        BlockState air = Blocks.AIR.defaultBlockState();
        Renderer renderer = (Renderer)this.renderers.get(inContraption);
        Matrix4f pose = poseStack.last().pose();
        for (RenderedElement element : renderer.allElements) {
            element.setTransform(pose);
        }
        renderer.display.update(bogeyData, wheelAngle);
        PoseStack ms = new PoseStack();
        for (RenderedElement.Single single : renderer.singleElements) {
            mat = single.element().pose;
            ms.last().pose().set((Matrix4fc)mat);
            ms.last().normal().set((Matrix4fc)mat);
            CachedBuffers.partial((PartialModel)single.model(), (BlockState)air).light(packedLight).overlay(packedOverlay).renderInto(ms, buffer);
        }
        for (RenderedElement.Multiple multiple : renderer.multipleElements) {
            SuperByteBuffer sbb = CachedBuffers.partial((PartialModel)multiple.model(), (BlockState)air);
            for (RenderedElement element : multiple.elements()) {
                Matrix4f mat2 = element.pose;
                ms.last().pose().set((Matrix4fc)mat2);
                ms.last().normal().set((Matrix4fc)mat2);
                sbb.light(packedLight).overlay(packedOverlay).renderInto(ms, buffer);
            }
        }
        for (RenderedElement.Scrolling scrolling : renderer.scrollingElements) {
            mat = scrolling.element.pose;
            ms.last().pose().set((Matrix4fc)mat);
            ms.last().normal().set((Matrix4fc)mat);
            float spriteSize = scrolling.entry.getTarget().getV1() - scrolling.entry.getTarget().getV0();
            float scrollV = scrolling.shiftV;
            scrollV -= (float)Mth.floor((float)scrollV);
            scrollV = scrollV * spriteSize * 0.5f;
            CachedBuffers.partial((PartialModel)scrolling.model, (BlockState)air).light(packedLight).overlay(packedOverlay).shiftUVScrolling(scrolling.entry, scrollV).renderInto(ms, buffer);
        }
        if (this.customRenderer != null) {
            this.customRenderer.render(bogeyData, wheelAngle, partialTick, poseStack, bufferSource, packedLight, packedOverlay, inContraption);
        }
    }

    private record Renderer(BogeyDisplay display, List<RenderedElement.Single> singleElements, List<RenderedElement.Multiple> multipleElements, List<RenderedElement.Scrolling> scrollingElements, List<RenderedElement> allElements) {
        private static Renderer create(BogeyDisplay.Factory factory, boolean inContraption) {
            ArrayList<RenderedElement.Single> singleElements = new ArrayList<RenderedElement.Single>();
            ArrayList<RenderedElement.Multiple> multipleElements = new ArrayList<RenderedElement.Multiple>();
            ArrayList<RenderedElement.Scrolling> scrollingElements = new ArrayList<RenderedElement.Scrolling>();
            RenderedElementProvider prov = new RenderedElementProvider(singleElements, multipleElements, scrollingElements);
            BogeyDisplay display = factory.create(prov, inContraption);
            prov.freeze();
            ArrayList<RenderedElement> allElements = new ArrayList<RenderedElement>();
            singleElements.forEach(s -> allElements.add(s.element()));
            multipleElements.forEach(m -> Collections.addAll(allElements, m.elements()));
            scrollingElements.forEach(s -> allElements.add(s.element));
            return new Renderer(display, singleElements, multipleElements, scrollingElements, allElements);
        }
    }
}

