/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.content.conductor.toolbox;

import com.railwayteam.railways.content.conductor.ConductorEntity;
import com.railwayteam.railways.content.conductor.toolbox.MountedToolboxContainer;
import com.railwayteam.railways.mixin.AccessorBlockEntity;
import com.railwayteam.railways.mixin.AccessorToolboxBlockEntity;
import com.railwayteam.railways.util.packet.PacketSender;
import com.simibubi.create.AllBlockEntityTypes;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.equipment.toolbox.ToolboxBlock;
import com.simibubi.create.content.equipment.toolbox.ToolboxBlockEntity;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public class MountedToolbox
extends ToolboxBlockEntity {
    protected final ConductorEntity parent;

    public MountedToolbox(ConductorEntity parent, DyeColor dyeColor) {
        super((BlockEntityType)AllBlockEntityTypes.TOOLBOX.get(), parent.blockPosition(), AllBlocks.TOOLBOXES.get(dyeColor).getDefaultState());
        this.parent = parent;
        this.setLevel(parent.level());
        this.setLazyTickRate(10);
    }

    public void readFromItem(ItemStack stack) {
        CompoundTag tag = ((CustomData)stack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag();
        if (tag.isEmpty()) {
            return;
        }
        this.read(tag, (HolderLookup.Provider)this.parent.level().registryAccess(), false);
        if (tag.contains("UniqueId")) {
            this.setUniqueId(tag.getUUID("UniqueId"));
        }
        if (stack.has(DataComponents.CUSTOM_NAME)) {
            this.setCustomName((Component)stack.get(DataComponents.CUSTOM_NAME));
        }
    }

    public ConductorEntity getParent() {
        return this.parent;
    }

    public void tick() {
        ((AccessorBlockEntity)((Object)this)).setWorldPosition(this.parent.blockPosition());
        super.tick();
    }

    public void read(CompoundTag compound, HolderLookup.Provider lookupProvider, boolean clientPacket) {
        super.read(compound, lookupProvider, clientPacket);
        if (compound.contains("Color", 3)) {
            DyeColor color = DyeColor.byId((int)compound.getInt("Color"));
            BlockState state = ((ToolboxBlock)AllBlocks.TOOLBOXES.get(color).get()).defaultBlockState();
            this.setBlockState(state);
        }
    }

    public void write(CompoundTag compound, HolderLookup.Provider lookupProvider, boolean clientPacket) {
        super.write(compound, lookupProvider, clientPacket);
        compound.putInt("Color", this.getColor().getId());
    }

    public List<Player> getConnectedPlayers() {
        Map<Integer, WeakHashMap<Player, Integer>> connectedPlayers = ((AccessorToolboxBlockEntity)((Object)this)).getConnectedPlayers();
        HashSet<Player> players = new HashSet<Player>();
        for (Map.Entry<Integer, WeakHashMap<Player, Integer>> entry : connectedPlayers.entrySet()) {
            players.addAll(entry.getValue().keySet());
        }
        return players.stream().toList();
    }

    public void sendData() {
        if (this.level == null || this.level.isClientSide) {
            return;
        }
        CompoundTag nbt = new CompoundTag();
        this.write(nbt, (HolderLookup.Provider)this.parent.level().registryAccess(), true);
        PacketSender.syncMountedToolboxNBT((Entity)this.parent, nbt);
    }

    public void setChanged() {
    }

    public static MountedToolbox read(ConductorEntity parent, CompoundTag compound) {
        MountedToolbox holder = new MountedToolbox(parent, DyeColor.BROWN);
        holder.read(compound, (HolderLookup.Provider)parent.level().registryAccess(), false);
        return holder;
    }

    public AbstractContainerMenu createMenu(int id, @NotNull Inventory inv, @NotNull Player player) {
        return MountedToolboxContainer.create(id, inv, this);
    }

    public ItemStack getDisplayStack() {
        ItemStack stack = new ItemStack((ItemLike)AllBlocks.TOOLBOXES.get(this.getColor()).get());
        if (this.hasCustomName()) {
            stack.set(DataComponents.CUSTOM_NAME, (Object)this.getCustomName());
        }
        return stack;
    }

    public ItemStack getCloneItemStack() {
        ItemStack stack = this.getDisplayStack();
        CompoundTag data = new CompoundTag();
        this.write(data, (HolderLookup.Provider)this.parent.level().registryAccess(), false);
        CompoundTag inv = data.getCompound("Inventory");
        CompoundTag tag = new CompoundTag();
        tag.put("Inventory", (Tag)inv);
        tag.putUUID("UniqueId", this.getUniqueId());
        stack.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)tag));
        return stack;
    }

    public void sendToMenu(RegistryFriendlyByteBuf buffer) {
        buffer.writeVarInt(this.parent.getId());
        buffer.writeNbt((Tag)this.getUpdateTag((HolderLookup.Provider)this.parent.level().registryAccess()));
    }

    public static void openMenu(ServerPlayer player, final MountedToolbox toolbox) {
        MenuProvider provider = new MenuProvider(){

            public AbstractContainerMenu createMenu(int id, Inventory inv, Player ply) {
                return MountedToolboxContainer.create(id, inv, toolbox);
            }

            public Component getDisplayName() {
                return toolbox.getDisplayName();
            }
        };
        player.openMenu(provider, (T buffer) -> toolbox.sendToMenu((RegistryFriendlyByteBuf)buffer));
    }
}

