/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.content.conductor;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.railwayteam.railways.Railways;
import com.railwayteam.railways.content.conductor.ConductorEntity;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.HumanoidArm;
import org.jetbrains.annotations.NotNull;

public class ConductorEntityModel<T extends ConductorEntity>
extends HumanoidModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(Railways.asResource("conductor"), "main");

    public ConductorEntityModel(ModelPart root) {
        super(root);
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition hat = partdefinition.addOrReplaceChild("hat", CubeListBuilder.create().texOffs(0, 48).addBox(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.5f)), PartPose.offsetAndRotation((float)0.0f, (float)10.0f, (float)0.0f, (float)0.1745f, (float)0.0f, (float)0.0f));
        PartDefinition head = partdefinition.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).addBox(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)10.0f, (float)0.0f));
        PartDefinition left_arm = partdefinition.addOrReplaceChild("left_arm", CubeListBuilder.create().texOffs(50, 0).addBox(0.0f, -2.0f, -2.0f, 3.0f, 9.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)4.0f, (float)12.0f, (float)0.0f));
        PartDefinition right_arm = partdefinition.addOrReplaceChild("right_arm", CubeListBuilder.create().texOffs(34, 0).addBox(-3.0f, -2.0f, -2.0f, 3.0f, 9.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-4.0f, (float)12.0f, (float)0.0f));
        PartDefinition body = partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 17).addBox(-4.0f, -9.0f, -3.0f, 8.0f, 5.0f, 6.0f, new CubeDeformation(0.0f)).texOffs(0, 29).addBox(-3.0f, -4.0f, -2.0f, 6.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)19.0f, (float)0.0f));
        PartDefinition right_leg = partdefinition.addOrReplaceChild("right_leg", CubeListBuilder.create().texOffs(34, 15).addBox(-1.5f, 0.0f, -2.0f, 3.0f, 5.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)1.5f, (float)19.0f, (float)0.0f));
        PartDefinition left_leg = partdefinition.addOrReplaceChild("left_leg", CubeListBuilder.create().texOffs(50, 15).addBox(-1.5f, 0.0f, -2.0f, 3.0f, 5.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-1.5f, (float)19.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    private float quadraticArmUpdate(float limbSwing) {
        return limbSwing;
    }

    public void setupAnim(@NotNull T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        float swimAmount;
        boolean fallFlying = ((ConductorEntity)((Object)entity)).visualBaseEntity != null && ((ConductorEntity)((Object)entity)).visualBaseEntity.getFallFlyingTicks() > 4;
        boolean visuallySwimming = ((ConductorEntity)((Object)entity)).visualBaseEntity != null && ((ConductorEntity)((Object)entity)).visualBaseEntity.isVisuallySwimming();
        float f = swimAmount = ((ConductorEntity)((Object)entity)).visualBaseModel != null ? ((ConductorEntity)((Object)entity)).visualBaseModel.swimAmount : this.swimAmount;
        this.head.xRot = fallFlying ? -0.7853982f : (swimAmount > 0.0f ? (visuallySwimming ? this.rotlerpRad(swimAmount, this.head.xRot, -0.7853982f) : this.rotlerpRad(swimAmount, this.head.xRot, headPitch * ((float)Math.PI / 180))) : headPitch * ((float)Math.PI / 180));
        this.head.yRot = netHeadYaw * ((float)Math.PI / 180);
        this.hat.xRot = (float)((double)this.head.xRot + -0.17453292519943295);
        this.hat.yRot = this.head.yRot;
        float amt = -1.6f;
        this.hat.x = (float)(Math.cos(this.head.xRot) * (double)amt * Math.sin(this.head.yRot));
        this.hat.z = (float)(Math.cos(this.head.xRot) * (double)amt * Math.cos(this.head.yRot));
        this.hat.y = (((ConductorEntity)((Object)entity)).visualBaseModel != null && ((ConductorEntity)((Object)entity)).visualBaseModel.crouching ? 14.2f : 10.0f) - (float)(Math.sin(this.head.xRot) * (double)amt);
        this.rightArm.xRot = Mth.cos((float)(limbSwing * 0.6662f * 2.0f + (float)Math.PI)) * 2.0f * limbSwingAmount * 0.5f;
        this.leftArm.xRot = Mth.cos((float)(limbSwing * 0.6662f * 2.0f)) * 2.0f * limbSwingAmount * 0.5f;
        this.rightArm.zRot = 0.0f;
        this.leftArm.zRot = 0.0f;
        this.rightLeg.xRot = Mth.cos((float)(limbSwing * 0.6662f * 3.0f)) * 1.4f * limbSwingAmount;
        this.leftLeg.xRot = Mth.cos((float)(limbSwing * 0.6662f * 3.0f + (float)Math.PI)) * 1.4f * limbSwingAmount;
        this.rightLeg.yRot = 0.0f;
        this.leftLeg.yRot = 0.0f;
        this.rightLeg.zRot = 0.0f;
        this.leftLeg.zRot = 0.0f;
        if (this.riding) {
            this.rightArm.xRot += -1.5707964f;
            this.leftArm.xRot += -1.5707964f;
            this.rightLeg.xRot = -1.4137167f;
            this.rightLeg.yRot = -0.15707964f;
            this.rightLeg.zRot = 0.07853982f;
            this.leftLeg.xRot = -1.4137167f;
            this.leftLeg.yRot = 0.15707964f;
            this.leftLeg.zRot = -0.07853982f;
        }
        this.rightArm.yRot = 0.0f;
        this.leftArm.yRot = 0.0f;
        if (((ConductorEntity)((Object)entity)).visualBaseModel != null && ((ConductorEntity)((Object)entity)).visualBaseModel.crouching) {
            this.body.xRot = 0.5f;
            this.rightArm.xRot += 0.4f;
            this.leftArm.xRot += 0.4f;
            this.rightLeg.z = 3.9f;
            this.leftLeg.z = 3.9f;
            this.rightLeg.y = 19.2f;
            this.leftLeg.y = 19.2f;
            this.head.y = 14.2f;
            this.body.z = 4.0f;
            this.body.y = 20.2f;
            this.leftArm.y = 15.2f;
            this.rightArm.y = 15.2f;
        } else {
            this.body.xRot = 0.0f;
            this.rightLeg.z = 0.0f;
            this.leftLeg.z = 0.0f;
            this.rightLeg.y = 19.0f;
            this.leftLeg.y = 19.0f;
            this.head.y = 10.0f;
            this.body.z = 0.0f;
            this.body.y = 19.0f;
            this.leftArm.y = 12.0f;
            this.rightArm.y = 12.0f;
        }
        if (swimAmount > 0.0f) {
            float g = limbSwing % 26.0f;
            float h = swimAmount;
            float i = swimAmount;
            if (g < 14.0f) {
                this.leftArm.xRot = this.rotlerpRad(i, this.leftArm.xRot, 0.0f);
                this.rightArm.xRot = Mth.lerp((float)h, (float)this.rightArm.xRot, (float)0.0f);
                this.leftArm.yRot = this.rotlerpRad(i, this.leftArm.yRot, (float)Math.PI);
                this.rightArm.yRot = Mth.lerp((float)h, (float)this.rightArm.yRot, (float)((float)Math.PI));
                this.leftArm.zRot = this.rotlerpRad(i, this.leftArm.zRot, (float)Math.PI + 1.8707964f * this.quadraticArmUpdate(g) / this.quadraticArmUpdate(14.0f));
                this.rightArm.zRot = Mth.lerp((float)h, (float)this.rightArm.zRot, (float)((float)Math.PI - 1.8707964f * this.quadraticArmUpdate(g) / this.quadraticArmUpdate(14.0f)));
            } else if (g >= 14.0f && g < 22.0f) {
                float j = (g - 14.0f) / 8.0f;
                this.leftArm.xRot = this.rotlerpRad(i, this.leftArm.xRot, 1.5707964f * j);
                this.rightArm.xRot = Mth.lerp((float)h, (float)this.rightArm.xRot, (float)(1.5707964f * j));
                this.leftArm.yRot = this.rotlerpRad(i, this.leftArm.yRot, (float)Math.PI);
                this.rightArm.yRot = Mth.lerp((float)h, (float)this.rightArm.yRot, (float)((float)Math.PI));
                this.leftArm.zRot = this.rotlerpRad(i, this.leftArm.zRot, 5.012389f - 1.8707964f * j);
                this.rightArm.zRot = Mth.lerp((float)h, (float)this.rightArm.zRot, (float)(1.2707963f + 1.8707964f * j));
            } else if (g >= 22.0f && g < 26.0f) {
                float j = (g - 22.0f) / 4.0f;
                this.leftArm.xRot = this.rotlerpRad(i, this.leftArm.xRot, 1.5707964f - 1.5707964f * j);
                this.rightArm.xRot = Mth.lerp((float)h, (float)this.rightArm.xRot, (float)(1.5707964f - 1.5707964f * j));
                this.leftArm.yRot = this.rotlerpRad(i, this.leftArm.yRot, (float)Math.PI);
                this.rightArm.yRot = Mth.lerp((float)h, (float)this.rightArm.yRot, (float)((float)Math.PI));
                this.leftArm.zRot = this.rotlerpRad(i, this.leftArm.zRot, (float)Math.PI);
                this.rightArm.zRot = Mth.lerp((float)h, (float)this.rightArm.zRot, (float)((float)Math.PI));
            }
            this.leftLeg.xRot = Mth.lerp((float)swimAmount, (float)this.leftLeg.xRot, (float)(0.3f * Mth.cos((float)(limbSwing * 0.33333334f + (float)Math.PI))));
            this.rightLeg.xRot = Mth.lerp((float)swimAmount, (float)this.rightLeg.xRot, (float)(0.3f * Mth.cos((float)(limbSwing * 0.33333334f))));
        }
    }

    public void translateToHand(@NotNull HumanoidArm arm, @NotNull PoseStack stack) {
        (arm == HumanoidArm.LEFT ? this.leftArm : this.rightArm).translateAndRotate(stack);
    }

    @NotNull
    public ModelPart getHead() {
        return this.head;
    }

    public void renderToBuffer(@NotNull PoseStack poseStack, @NotNull VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int packedColor) {
        this.head.render(poseStack, vertexConsumer, packedLight, packedOverlay, packedColor);
        this.body.render(poseStack, vertexConsumer, packedLight, packedOverlay, packedColor);
        this.rightArm.render(poseStack, vertexConsumer, packedLight, packedOverlay, packedColor);
        this.leftArm.render(poseStack, vertexConsumer, packedLight, packedOverlay, packedColor);
        this.rightLeg.render(poseStack, vertexConsumer, packedLight, packedOverlay, packedColor);
        this.leftLeg.render(poseStack, vertexConsumer, packedLight, packedOverlay, packedColor);
    }
}

