/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.content.conductor;

import com.railwayteam.railways.Railways;
import com.railwayteam.railways.content.conductor.ConductorEntity;
import com.railwayteam.railways.content.conductor.neoforge.ConductorCapItemImpl;
import com.simibubi.create.AllBlocks;
import java.util.EnumMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public abstract class ConductorCapItem
extends ArmorItem {
    public final DyeColor color;
    public final ResourceLocation textureId;
    public final String textureStr;
    private static final Holder<ArmorMaterial> CONDUCTOR_CAP_MATERIAL = ConductorCapItem.createConductorCapMaterial();

    protected ConductorCapItem(Item.Properties props, DyeColor color) {
        super(CONDUCTOR_CAP_MATERIAL, ArmorItem.Type.HELMET, props);
        this.color = color;
        String colorName = color.getName().toLowerCase(Locale.ROOT);
        this.textureId = Railways.asResource("textures/entity/caps/%s_conductor_cap.png".formatted(colorName));
        this.textureStr = this.textureId.toString();
    }

    private static Holder<ArmorMaterial> createConductorCapMaterial() {
        ArmorMaterial material = new ArmorMaterial((Map)Util.make(new EnumMap(ArmorItem.Type.class), map -> {
            map.put(ArmorItem.Type.BOOTS, 0);
            map.put(ArmorItem.Type.LEGGINGS, 0);
            map.put(ArmorItem.Type.CHESTPLATE, 0);
            map.put(ArmorItem.Type.HELMET, 0);
            map.put(ArmorItem.Type.BODY, 0);
        }), 0, SoundEvents.ARMOR_EQUIP_LEATHER, () -> Ingredient.EMPTY, List.of(new ArmorMaterial.Layer(Railways.asResource("conductor_cap_base"), "", false), new ArmorMaterial.Layer(Railways.asResource("conductor_cap_stripe"), "", true)), 0.0f, 0.0f);
        return Holder.direct((Object)material);
    }

    public static ConductorCapItem create(Item.Properties props, DyeColor color) {
        return ConductorCapItemImpl.create(props, color);
    }

    static boolean isCasing(Block block) {
        return block.equals(AllBlocks.ANDESITE_CASING.get());
    }

    static boolean isCasing(BlockState state) {
        return ConductorCapItem.isCasing(state.getBlock());
    }

    static boolean isCasing(Level level, BlockPos pos) {
        return ConductorCapItem.isCasing(level.getBlockState(pos));
    }

    @Nonnull
    public InteractionResult useOn(UseOnContext ctx) {
        BlockPos pos;
        Level level = ctx.getLevel();
        if (ConductorCapItem.isCasing(level, pos = ctx.getClickedPos())) {
            if (level.isClientSide) {
                return InteractionResult.SUCCESS;
            }
            level.removeBlock(pos, false);
            ConductorEntity.spawn(level, pos, ctx.getItemInHand().copy());
            if (ctx.getPlayer() != null && !ctx.getPlayer().isCreative()) {
                ctx.getItemInHand().shrink(1);
                return InteractionResult.CONSUME;
            }
            return InteractionResult.SUCCESS;
        }
        return super.useOn(ctx);
    }
}

