/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.content.buffer.single_deco;

import com.railwayteam.railways.content.buffer.DyeableBlockEntity;
import com.railwayteam.railways.registry.CRBlockEntities;
import com.railwayteam.railways.util.AdventureUtils;
import com.simibubi.create.content.equipment.wrench.IWrenchable;
import com.simibubi.create.foundation.block.IBE;
import com.simibubi.create.foundation.block.ProperWaterloggedBlock;
import javax.annotation.ParametersAreNonnullByDefault;
import net.createmod.catnip.math.VoxelShaper;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public abstract class AbstractDyeableSingleBufferBlock
extends HorizontalDirectionalBlock
implements IBE<DyeableBlockEntity>,
IWrenchable,
ProperWaterloggedBlock {
    public AbstractDyeableSingleBufferBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder.add(new Property[]{FACING, WATERLOGGED}));
    }

    public void onRemove(@NotNull BlockState state, @NotNull Level worldIn, @NotNull BlockPos pos, @NotNull BlockState newState, boolean isMoving) {
        IBE.onRemove((BlockState)state, (Level)worldIn, (BlockPos)pos, (BlockState)newState);
    }

    protected abstract BlockState cycleStyle(BlockState var1, Direction var2);

    public BlockState getRotatedBlockState(BlockState originalState, Direction targetedFace) {
        if (targetedFace.getAxis().isVertical()) {
            return super.getRotatedBlockState(originalState, targetedFace);
        }
        return this.cycleStyle(originalState, targetedFace);
    }

    public FluidState getFluidState(BlockState state) {
        return this.fluidState(state);
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockState state = super.getStateForPlacement(context);
        if (state != null) {
            state = context.getClickedFace().getAxis().isVertical() ? (BlockState)state.setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite()) : (BlockState)state.setValue((Property)FACING, (Comparable)context.getClickedFace());
        }
        return this.withWater(state, context);
    }

    protected abstract VoxelShaper getShaper(BlockState var1, BlockGetter var2, BlockPos var3, CollisionContext var4);

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return this.getShaper(state, level, pos, context).get((Direction)state.getValue((Property)FACING));
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos currentPos, BlockPos neighborPos) {
        this.updateWater(level, state, currentPos);
        return state;
    }

    public ItemInteractionResult useItemOn(ItemStack stack, BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHit) {
        if (AdventureUtils.isAdventure(pPlayer)) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        InteractionResult result = this.onBlockEntityUse((BlockGetter)pLevel, pPos, be -> be.applyDyeIfValid(stack));
        return result.consumesAction() ? ItemInteractionResult.sidedSuccess((boolean)pLevel.isClientSide) : ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    public Class<DyeableBlockEntity> getBlockEntityClass() {
        return DyeableBlockEntity.class;
    }

    public BlockEntityType<? extends DyeableBlockEntity> getBlockEntityType() {
        return (BlockEntityType)CRBlockEntities.DYEABLE.get();
    }
}

