/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.content.buffer;

import com.mojang.serialization.MapCodec;
import com.railwayteam.railways.Railways;
import com.railwayteam.railways.content.buffer.WoodVariantTrackBufferBlock;
import java.util.Locale;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class StandardTrackBufferBlock
extends WoodVariantTrackBufferBlock {
    public static final MapCodec<StandardTrackBufferBlock> CODEC = StandardTrackBufferBlock.simpleCodec(StandardTrackBufferBlock::new);
    public static final EnumProperty<Style> STYLE = EnumProperty.create((String)"style", Style.class);

    protected MapCodec<? extends StandardTrackBufferBlock> codec() {
        return CODEC;
    }

    public StandardTrackBufferBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue(STYLE, (Comparable)((Object)Style.STANDARD)));
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition((StateDefinition.Builder<Block, BlockState>)builder.add(new Property[]{STYLE}));
    }

    @Override
    protected BlockState getCycledStyle(BlockState originalState, Direction targetedFace) {
        return (BlockState)originalState.cycle(STYLE);
    }

    public static enum Style implements StringRepresentable
    {
        STANDARD("buffer_stop"),
        SHORT("buffer_stop_short_support");

        private final String model;

        private Style(String model) {
            this.model = model;
        }

        public ResourceLocation getModel() {
            return Railways.asResource("block/buffer/" + this.model);
        }

        public String getSerializedName() {
            return this.name().toLowerCase(Locale.ROOT);
        }
    }
}

