/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.content.buffer;

import com.railwayteam.railways.Railways;
import java.util.EnumMap;
import java.util.List;
import java.util.function.UnaryOperator;
import net.createmod.catnip.render.StitchedSprite;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public class BufferModelUtils {
    public static final StitchedSprite SPRUCE_PLANKS_TEMPLATE = new StitchedSprite(ResourceLocation.withDefaultNamespace((String)"block/spruce_planks"));
    public static final StitchedSprite BIG_BUFFER_TEMPLATE = new StitchedSprite(Railways.asResource("block/buffer/big_buffer"));
    public static final StitchedSprite SMALL_BUFFER_TEMPLATE = new StitchedSprite(Railways.asResource("block/buffer/small_buffer"));
    public static final StitchedSprite SMALL_BUFFER_MONORAIL_TEMPLATE = new StitchedSprite(Railways.asResource("block/buffer/small_buffer_monorail"));
    public static final EnumMap<DyeColor, StitchedSprite> BIG_BUFFER_COLORS = new EnumMap(DyeColor.class);
    public static final EnumMap<DyeColor, StitchedSprite> SMALL_BUFFER_COLORS = new EnumMap(DyeColor.class);

    public static UnaryOperator<TextureAtlasSprite> getSwapper(@Nullable BlockState planksState) {
        if (planksState == null) {
            return sprite -> null;
        }
        Block planksBlock = planksState.getBlock();
        ResourceLocation id = BuiltInRegistries.BLOCK.getKey((Object)planksBlock);
        String path = id.getPath();
        if (path.endsWith("_planks")) {
            return sprite -> {
                if (sprite == SPRUCE_PLANKS_TEMPLATE.get()) {
                    return BufferModelUtils.getSpriteOnSide(planksState, Direction.UP);
                }
                return null;
            };
        }
        return sprite -> null;
    }

    @SafeVarargs
    public static UnaryOperator<TextureAtlasSprite> combineSwappers(UnaryOperator<TextureAtlasSprite> ... swappers) {
        return sprite -> {
            for (UnaryOperator swapper : swappers) {
                TextureAtlasSprite newSprite;
                if (swapper == null || (newSprite = (TextureAtlasSprite)swapper.apply(sprite)) == null) continue;
                return newSprite;
            }
            return null;
        };
    }

    public static UnaryOperator<TextureAtlasSprite> getSwapper(@Nullable DyeColor color) {
        if (color == null) {
            return sprite -> null;
        }
        return sprite -> {
            if (sprite == SMALL_BUFFER_TEMPLATE.get() || sprite == SMALL_BUFFER_MONORAIL_TEMPLATE.get()) {
                return SMALL_BUFFER_COLORS.get(color).get();
            }
            if (sprite == BIG_BUFFER_TEMPLATE.get()) {
                return BIG_BUFFER_COLORS.get(color).get();
            }
            return null;
        };
    }

    private static TextureAtlasSprite getSpriteOnSide(BlockState state, Direction side) {
        BakedModel model = Minecraft.getInstance().getBlockRenderer().getBlockModel(state);
        if (model == null) {
            return null;
        }
        RandomSource random = RandomSource.create();
        random.setSeed(42L);
        List quads = model.getQuads(state, side, random);
        if (!quads.isEmpty()) {
            return ((BakedQuad)quads.get(0)).getSprite();
        }
        random.setSeed(42L);
        quads = model.getQuads(state, null, random);
        if (!quads.isEmpty()) {
            for (BakedQuad quad : quads) {
                if (quad.getDirection() != side) continue;
                return quad.getSprite();
            }
        }
        return model.getParticleIcon();
    }

    public static void register() {
    }

    static {
        for (DyeColor color : DyeColor.values()) {
            BIG_BUFFER_COLORS.put(color, new StitchedSprite(Railways.asResource("block/buffer/big_buffer/big_buffer_" + color.getName())));
            SMALL_BUFFER_COLORS.put(color, new StitchedSprite(Railways.asResource("block/buffer/small_buffer/small_buffer_" + color.getName())));
        }
    }
}

