/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.content.bogey_menu;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.railwayteam.railways.api.bogeymenu.v0.entry.BogeyEntry;
import com.railwayteam.railways.api.bogeymenu.v0.entry.CategoryEntry;
import com.railwayteam.railways.content.bogey_menu.components.BogeyMenuButton;
import com.railwayteam.railways.content.bogey_menu.handler.BogeyMenuHandlerClient;
import com.railwayteam.railways.impl.bogeymenu.v0.BogeyMenuManagerImpl;
import com.railwayteam.railways.registry.CRGuiTextures;
import com.railwayteam.railways.registry.CRIcons;
import com.railwayteam.railways.registry.CRPackets;
import com.railwayteam.railways.util.client.ClientTextUtils;
import com.railwayteam.railways.util.packet.BogeyStyleSelectionPacket;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.content.trains.bogey.AbstractBogeyBlock;
import com.simibubi.create.content.trains.bogey.BogeySizes;
import com.simibubi.create.content.trains.bogey.BogeyStyle;
import com.simibubi.create.foundation.gui.AllGuiTextures;
import com.simibubi.create.foundation.gui.AllIcons;
import com.simibubi.create.foundation.gui.widget.IconButton;
import com.simibubi.create.foundation.gui.widget.Indicator;
import com.simibubi.create.foundation.gui.widget.Label;
import com.simibubi.create.foundation.gui.widget.ScrollInput;
import com.simibubi.create.foundation.gui.widget.SelectionScrollInput;
import com.simibubi.create.foundation.gui.widget.TooltipArea;
import dev.engine_room.flywheel.lib.transform.PoseTransformStack;
import dev.engine_room.flywheel.lib.transform.TransformStack;
import java.util.List;
import net.createmod.catnip.animation.AnimationTickHolder;
import net.createmod.catnip.data.Pair;
import net.createmod.catnip.gui.AbstractSimiScreen;
import net.createmod.catnip.gui.element.GuiGameElement;
import net.createmod.catnip.gui.element.ScreenElement;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;

public class BogeyMenuScreen
extends AbstractSimiScreen {
    private final CRGuiTextures background = CRGuiTextures.BOGEY_MENU;
    private final List<Component> categoryComponentList = BogeyMenuManagerImpl.CATEGORIES.stream().map(CategoryEntry::getName).toList();
    private CategoryEntry selectedCategory = BogeyMenuManagerImpl.CATEGORIES.get(0);
    private int categoryIndex = 0;
    BogeyEntry[] bogeyList = new BogeyEntry[6];
    BogeyMenuButton[] bogeyMenuButtons = new BogeyMenuButton[6];
    BogeyEntry selectedBogey;
    private float scrollOffs;
    private boolean scrolling;
    private int ticksOpen;
    private boolean soundPlayed;
    private TooltipArea longBogeyTooltipArea;
    private IconButton favouriteButton;

    protected void init() {
        this.setWindowSize(this.background.width, this.background.height);
        super.init();
        this.clearWidgets();
        int x = this.guiLeft;
        int y = this.guiTop;
        for (int i = 0; i < 6; ++i) {
            this.bogeyMenuButtons[i] = new BogeyMenuButton(x + 19, y + 41 + i * 18, 82, 17, this.bogeySelection(i));
            this.addRenderableWidget((GuiEventListener)this.bogeyMenuButtons[i]);
        }
        this.setupList(this.selectedCategory);
        this.selectedBogey = this.selectedCategory.getBogeyEntryList().get(0);
        this.scrollOffs = 0.0f;
        this.scrollTo(0.0f);
        Label categoryLabel = new Label(x + 14, y + 25, CommonComponents.EMPTY).withShadow();
        ScrollInput categoryScrollInput = new SelectionScrollInput(x + 9, y + 20, 77, 18).forOptions(this.categoryComponentList).writingTo(categoryLabel).setState(this.categoryIndex).calling(categoryIndex -> {
            this.scrollOffs = 0.0f;
            this.scrollTo(0.0f);
            this.categoryIndex = categoryIndex;
            this.selectedCategory = BogeyMenuManagerImpl.CATEGORIES.get((int)categoryIndex);
            this.setupList(this.selectedCategory);
            this.selectedBogey = !this.selectedCategory.getBogeyEntryList().isEmpty() ? this.selectedCategory.getBogeyEntryList().get(0) : null;
        });
        this.addRenderableWidget((GuiEventListener)categoryLabel);
        this.addRenderableWidget((GuiEventListener)categoryScrollInput);
        this.favouriteButton = new IconButton(x + this.background.width - 167, y + this.background.height - 49, (ScreenElement)CRIcons.I_FAVORITE);
        this.favouriteButton.withCallback(this::onFavorite);
        this.addRenderableWidget((GuiEventListener)this.favouriteButton);
        IconButton closeButton = new IconButton(x + this.background.width - 33, y + this.background.height - 24, (ScreenElement)AllIcons.I_CONFIRM);
        closeButton.withCallback(this::onMenuClose);
        this.addRenderableWidget((GuiEventListener)closeButton);
        String[] gaugeText = new String[]{"narrow", "standard", "wide"};
        for (int i = 0; i < 3; ++i) {
            this.addRenderableOnly((Renderable)new TooltipArea(x + 163 + i * 18, y + 135, 18, 18).withTooltip((List)ImmutableList.of((Object)Component.translatable((String)"railways.gui.bogey_menu.gauge_description").withStyle(s -> s.withColor(5476833)), (Object)Component.translatable((String)("railways.gui.bogey_menu." + gaugeText[i] + "_gauge")).withStyle(ChatFormatting.GRAY))));
        }
        this.longBogeyTooltipArea = new TooltipArea(x + 122, y + 20, 136, 18);
        this.addRenderableOnly((Renderable)this.longBogeyTooltipArea);
    }

    protected void renderWindow(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        PoseStack ms = guiGraphics.pose();
        int x = this.guiLeft;
        int y = this.guiTop;
        this.background.render(guiGraphics, x, y, 512, 512);
        MutableComponent header = Component.translatable((String)"railways.gui.bogey_menu.title");
        int halfWidth = this.background.width / 2;
        int halfHeaderWidth = this.font.width((FormattedText)header) / 2;
        guiGraphics.drawString(this.font, (Component)header, x + halfWidth - halfHeaderWidth, y + 4, 5776420, false);
        ms.pushPose();
        ((PoseTransformStack)((PoseTransformStack)TransformStack.of((PoseStack)ms).pushPose().translate((float)(x + this.background.width + 4), (float)(y + this.background.height + 4), 100.0f).scale(40.0f)).rotateXDegrees(-22.0f)).rotateYDegrees(63.0f);
        GuiGameElement.of((BlockState)AllBlocks.RAILWAY_CASING.getDefaultState()).render(guiGraphics);
        ms.popPose();
        int scrollBarPos = (int)(41.0f + 93.0f * this.scrollOffs);
        CRGuiTextures barTexture = this.canScroll() ? CRGuiTextures.BOGEY_MENU_SCROLL_BAR : CRGuiTextures.BOGEY_MENU_SCROLL_BAR_DISABLED;
        barTexture.render(guiGraphics, x + 11, y + scrollBarPos, 512, 512);
        for (int i = 0; i < 6; ++i) {
            BogeyEntry bogeyEntry = this.bogeyList[i];
            if (bogeyEntry == null) continue;
            ResourceLocation icon = bogeyEntry.iconLocation();
            if (icon != null) {
                this.renderIcon(guiGraphics, ms, icon, x + 20, y + 42 + i * 18);
            }
            Component bogeyName = ClientTextUtils.getComponentWithWidthCutoff(bogeyEntry.bogeyStyle().displayName, 55);
            guiGraphics.drawString(this.font, bogeyName, x + 40, y + 46 + i * 18, 0xFFFFFF);
        }
        if (this.selectedBogey != null) {
            Component displayName = this.selectedBogey.bogeyStyle().displayName;
            Component bogeyName = ClientTextUtils.getComponentWithWidthCutoff(displayName, 126);
            guiGraphics.drawCenteredString(this.font, bogeyName, x + 190, y + 25, 0xFFFFFF);
            if (this.font.width((FormattedText)displayName) > 126) {
                this.longBogeyTooltipArea.withTooltip((List)ImmutableList.of((Object)displayName));
                this.longBogeyTooltipArea.visible = true;
            } else {
                this.longBogeyTooltipArea.visible = false;
            }
            Indicator.State[] states = BogeyMenuHandlerClient.getTrackCompat(this.selectedBogey);
            for (int i = 0; i < 3; ++i) {
                AllGuiTextures indicator = switch (states[i]) {
                    default -> throw new MatchException(null, null);
                    case Indicator.State.ON -> AllGuiTextures.INDICATOR_WHITE;
                    case Indicator.State.OFF -> AllGuiTextures.INDICATOR;
                    case Indicator.State.RED -> AllGuiTextures.INDICATOR_RED;
                    case Indicator.State.YELLOW -> AllGuiTextures.INDICATOR_YELLOW;
                    case Indicator.State.GREEN -> AllGuiTextures.INDICATOR_GREEN;
                };
                indicator.render(guiGraphics, x + 163 + i * 18, y + 128);
            }
            BogeyStyle style = this.selectedBogey.bogeyStyle();
            float bogeyScale = this.selectedBogey.scale();
            List<Pair<BogeyStyle, BogeySizes.BogeySize>> renderCycle = BogeyMenuHandlerClient.getRenderCycle(style);
            Pair<BogeyStyle, BogeySizes.BogeySize> renderPair = renderCycle.get(this.ticksOpen / 40 % renderCycle.size());
            BogeyStyle renderStyle = (BogeyStyle)renderPair.getFirst();
            BogeySizes.BogeySize renderSize = (BogeySizes.BogeySize)renderPair.getSecond();
            if (BogeyMenuManagerImpl.SIZES_TO_SCALE.containsKey(renderPair)) {
                bogeyScale = BogeyMenuManagerImpl.SIZES_TO_SCALE.get(renderPair).floatValue();
            }
            AbstractBogeyBlock bogeyBlock = style.getBlockForSize(renderSize);
            BlockState bogeyState = (BlockState)bogeyBlock.defaultBlockState().setValue((Property)AbstractBogeyBlock.AXIS, (Comparable)Direction.Axis.Z);
            ms.pushPose();
            ms.translate((double)(x + 190), (double)y + 86.5, 1000.0);
            ms.scale(bogeyScale, bogeyScale, bogeyScale);
            Quaternionf zRot = Axis.ZP.rotationDegrees(180.0f);
            Quaternionf xRot = Axis.XP.rotationDegrees(-20.0f);
            Quaternionf yRot = Axis.YP.rotationDegrees(-45.0f);
            zRot.mul((Quaternionfc)xRot);
            zRot.mul((Quaternionfc)yRot);
            ms.mulPose(zRot);
            ms.translate(-0.5, -0.5, -0.5);
            Lighting.setupForEntityInInventory();
            Minecraft mc = Minecraft.getInstance();
            MultiBufferSource.BufferSource bufferSource = mc.renderBuffers().bufferSource();
            int light = 0xF000F0;
            int overlay = OverlayTexture.NO_OVERLAY;
            float wheelAngle = -3.0f * AnimationTickHolder.getRenderTime();
            RenderSystem.enableDepthTest();
            RenderSystem.disableCull();
            this.minecraft.getBlockRenderer().renderSingleBlock(bogeyState, ms, (MultiBufferSource)bufferSource, light, overlay);
            ms.pushPose();
            ms.translate(0.0f, 1.0f, 0.0f);
            renderStyle.render(renderSize, partialTicks, ms, (MultiBufferSource)bufferSource, light, overlay, wheelAngle, new CompoundTag(), false);
            ms.popPose();
            bufferSource.endBatch();
            RenderSystem.enableCull();
            ms.popPose();
            double x0 = x + 120;
            double y0 = y + 48;
            double w = 140.0;
            double h = 77.0;
            double bottom = y0 + h;
            Window window = mc.getWindow();
            double scale = window.getGuiScale();
            RenderSystem.clearDepth((double)0.86);
            RenderSystem.enableScissor((int)((int)(x0 * scale)), (int)(window.getHeight() - (int)(bottom * scale)), (int)((int)(w * scale)), (int)((int)(h * scale)));
            RenderSystem.clear((int)256, (boolean)false);
            RenderSystem.disableScissor();
            RenderSystem.clearDepth((double)1.0);
        }
    }

    private void renderIcon(GuiGraphics guiGraphics, PoseStack ms, ResourceLocation icon, int x, int y) {
        ms.pushPose();
        guiGraphics.blit(icon, x, y, 0, 0.0f, 0.0f, 16, 16, 16, 16);
        ms.popPose();
    }

    private void setupList(CategoryEntry categoryEntry) {
        this.setupList(categoryEntry, 0);
    }

    private void setupList(CategoryEntry categoryEntry, int offset) {
        List<BogeyEntry> bogies = categoryEntry.getBogeyEntryList();
        for (int i = 0; i < 6; ++i) {
            if (i < bogies.size()) {
                this.bogeyList[i] = bogies.get(i + offset);
                this.bogeyMenuButtons[i].active = true;
                continue;
            }
            this.bogeyList[i] = null;
            this.bogeyMenuButtons[i].active = false;
        }
    }

    public void tick() {
        ++this.ticksOpen;
        this.soundPlayed = false;
        super.tick();
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 256) {
            if (this.selectedBogey == null) {
                this.onClose();
            } else {
                this.onMenuClose();
            }
            return true;
        }
        if (keyCode == 257) {
            this.onMenuClose();
            return true;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (button == 0 && this.insideScrollbar(mouseX, mouseY)) {
            this.scrolling = this.canScroll();
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        if (button == 0) {
            this.scrolling = false;
        }
        return super.mouseReleased(mouseX, mouseY, button);
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (!this.scrolling) {
            return super.mouseDragged(mouseX, mouseY, button, dragX, dragY);
        }
        int scrollbarLeft = this.guiTop + 41;
        int scrollbarRight = scrollbarLeft + 108;
        float scrollFactor = (float)((mouseY - (double)scrollbarLeft - 7.5) / (double)((float)(scrollbarRight - scrollbarLeft) - 15.0f));
        this.scrollOffs = Mth.clamp((float)scrollFactor, (float)0.0f, (float)1.0f);
        this.scrollTo(this.scrollOffs);
        return true;
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
        super.mouseScrolled(mouseX, mouseY, scrollX, scrollY);
        if (!this.canScroll()) {
            return false;
        }
        if (this.insideCategorySelector(mouseX, mouseY)) {
            return false;
        }
        if (this.selectedCategory.getBogeyEntryList().size() < 6) {
            return false;
        }
        double listSize = this.selectedCategory.getBogeyEntryList().size() - 6;
        float scrollFactor = (float)(scrollY / listSize);
        float oldScrollOffs = this.scrollOffs;
        this.scrollOffs = Mth.clamp((float)(this.scrollOffs - scrollFactor), (float)0.0f, (float)1.0f);
        this.scrollTo(this.scrollOffs);
        if (!this.soundPlayed && this.scrollOffs != oldScrollOffs) {
            Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)AllSoundEvents.SCROLL_VALUE.getMainEvent(), (float)(1.5f + 0.1f * this.scrollOffs)));
        }
        this.soundPlayed = true;
        return true;
    }

    private void scrollTo(float pos) {
        List<BogeyEntry> bogies = this.selectedCategory.getBogeyEntryList();
        float listSize = bogies.size() - 6;
        int index = (int)((double)(pos * listSize) + 0.5);
        this.setupList(this.selectedCategory, index);
    }

    private boolean canScroll() {
        return this.selectedCategory.getBogeyEntryList().size() > 6;
    }

    private boolean insideCategorySelector(double mouseX, double mouseY) {
        int scrollbarLeftX = this.guiLeft + 11;
        int scrollbarTopY = this.guiTop + 20;
        int scrollbarRightX = scrollbarLeftX + 90;
        int scrollbarBottomY = scrollbarTopY + 34;
        return mouseX >= (double)scrollbarLeftX && mouseY >= (double)scrollbarTopY && mouseX < (double)scrollbarRightX && mouseY < (double)scrollbarBottomY;
    }

    private boolean insideScrollbar(double mouseX, double mouseY) {
        int scrollbarLeftX = this.guiLeft + 11;
        int scrollbarTopY = this.guiTop + 41;
        int scrollbarRightX = scrollbarLeftX + 8;
        int scrollbarBottomY = scrollbarTopY + 108;
        return mouseX >= (double)scrollbarLeftX && mouseY >= (double)scrollbarTopY && mouseX < (double)scrollbarRightX && mouseY < (double)scrollbarBottomY;
    }

    private Button.OnPress bogeySelection(int index) {
        return b -> {
            this.selectedBogey = this.bogeyList[index];
            this.updateFavorites();
        };
    }

    private void onFavorite() {
        if (this.selectedBogey != null) {
            BogeyMenuHandlerClient.toggleFavorite(this.selectedBogey.bogeyStyle());
            this.updateFavorites();
        }
    }

    private void updateFavorites() {
        this.favouriteButton.setIcon((ScreenElement)(BogeyMenuHandlerClient.isFavorited(this.selectedBogey.bogeyStyle()) ? CRIcons.I_FAVORITED : CRIcons.I_FAVORITE));
        if (this.selectedCategory == CategoryEntry.FavoritesCategory.INSTANCE) {
            this.scrollTo(this.scrollOffs);
        }
    }

    private void onMenuClose() {
        if (this.selectedBogey == null) {
            return;
        }
        BogeyStyle style = this.selectedBogey.bogeyStyle();
        BogeySizes.BogeySize size = BogeyMenuHandlerClient.getSize(style);
        CRPackets.PACKETS.send(new BogeyStyleSelectionPacket(style, size));
        this.onClose();
    }
}

