/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.content.animated_flywheel;

import com.railwayteam.railways.config.CRConfigs;
import com.simibubi.create.AllPartialModels;
import com.simibubi.create.content.contraptions.AbstractContraptionEntity;
import com.simibubi.create.content.contraptions.Contraption;
import com.simibubi.create.content.contraptions.behaviour.MovementContext;
import com.simibubi.create.content.contraptions.render.ActorVisual;
import com.simibubi.create.content.kinetics.base.KineticBlockEntityVisual;
import com.simibubi.create.content.kinetics.base.RotatingInstance;
import com.simibubi.create.content.trains.entity.CarriageContraption;
import com.simibubi.create.content.trains.entity.CarriageContraptionEntity;
import com.simibubi.create.foundation.render.AllInstanceTypes;
import com.simibubi.create.foundation.virtualWorld.VirtualRenderWorld;
import dev.engine_room.flywheel.api.instance.Instancer;
import dev.engine_room.flywheel.api.visualization.VisualizationContext;
import dev.engine_room.flywheel.lib.instance.InstanceTypes;
import dev.engine_room.flywheel.lib.instance.TransformedInstance;
import dev.engine_room.flywheel.lib.model.Models;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import net.createmod.catnip.animation.AnimationTickHolder;
import net.createmod.catnip.math.AngleHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;

class FlywheelActorVisual
extends ActorVisual {
    private static final double FLYWHEEL_DIAMETER = 2.8125;
    private final RotatingInstance shaft;
    private final TransformedInstance wheel;
    private final Matrix4f baseTransform;
    private float angle;
    private float lastRenderTime;
    private boolean hasLastEntityPos;
    private double lastEntityX;
    private double lastEntityZ;

    FlywheelActorVisual(VisualizationContext visualizationContext, VirtualRenderWorld simulationWorld, MovementContext context) {
        super(visualizationContext, (BlockAndTintGetter)simulationWorld, context);
        BlockState state = context.state;
        BlockPos localPos = context.localPos;
        Direction.Axis axis = (Direction.Axis)state.getValue((Property)BlockStateProperties.AXIS);
        Instancer shaftInstancer = this.instancerProvider.instancer(AllInstanceTypes.ROTATING, Models.partial((PartialModel)AllPartialModels.SHAFT));
        this.shaft = (RotatingInstance)shaftInstancer.createInstance();
        this.shaft.setRotationAxis(axis).setRotationOffset(KineticBlockEntityVisual.rotationOffset((BlockState)state, (Direction.Axis)axis, (Vec3i)localPos)).setPosition((Vec3i)localPos).light(this.localBlockLight(), 0).setChanged();
        Instancer wheelInstancer = this.instancerProvider.instancer(InstanceTypes.TRANSFORMED, Models.partial((PartialModel)AllPartialModels.FLYWHEEL));
        this.wheel = (TransformedInstance)wheelInstancer.createInstance();
        Direction facing = Direction.fromAxisAndDirection((Direction.Axis)axis, (Direction.AxisDirection)Direction.AxisDirection.POSITIVE);
        ((TransformedInstance)((TransformedInstance)this.wheel.setIdentityTransform().translate((Vec3i)localPos)).center()).rotate((Quaternionfc)new Quaternionf().rotateTo(0.0f, 1.0f, 0.0f, (float)facing.getStepX(), (float)facing.getStepY(), (float)facing.getStepZ()));
        this.baseTransform = new Matrix4f((Matrix4fc)this.wheel.pose);
        this.lastRenderTime = Float.NaN;
        this.hasLastEntityPos = false;
        this.applyWheelAngle(0.0f);
    }

    public void beginFrame() {
        float renderTime = AnimationTickHolder.getRenderTime();
        if (Float.isNaN(this.lastRenderTime)) {
            this.lastRenderTime = renderTime;
        }
        float deltaTicks = renderTime - this.lastRenderTime;
        this.lastRenderTime = renderTime;
        if (deltaTicks < 0.0f) {
            deltaTicks = 0.0f;
        }
        float speedMultiplier = CRConfigs.client().flywheelSpeedMultiplier.getF();
        float rpm = this.computeRpm(deltaTicks) * speedMultiplier;
        float degreesPerTick = rpm * 360.0f / 1200.0f;
        this.angle = (this.angle + degreesPerTick * deltaTicks) % 360.0f;
        this.shaft.setRotationalSpeed(rpm).setChanged();
        this.applyWheelAngle(this.angle);
    }

    private float computeRpm(float deltaTicks) {
        if (!((Boolean)CRConfigs.client().animatedFlywheels.get()).booleanValue()) {
            return 0.0f;
        }
        Contraption contraption = this.context.contraption;
        if (!(contraption instanceof CarriageContraption)) {
            return 0.0f;
        }
        CarriageContraption carriageContraption = (CarriageContraption)contraption;
        AbstractContraptionEntity abstractContraptionEntity = carriageContraption.entity;
        if (!(abstractContraptionEntity instanceof CarriageContraptionEntity)) {
            return 0.0f;
        }
        CarriageContraptionEntity carriageContraptionEntity = (CarriageContraptionEntity)abstractContraptionEntity;
        Direction.Axis axis = (Direction.Axis)this.context.state.getValue((Property)BlockStateProperties.AXIS);
        if (axis.isVertical()) {
            return 0.0f;
        }
        double trainSpeed = this.computeHorizontalSpeed(carriageContraptionEntity, deltaTicks);
        double circumference = 8.835729338221293;
        if (circumference <= 0.0) {
            return 0.0f;
        }
        double rpm = trainSpeed / circumference * 1200.0;
        if (carriageContraptionEntity.movingBackwards) {
            rpm = -rpm;
        }
        if (!Double.isFinite(rpm)) {
            return 0.0f;
        }
        return (float)rpm;
    }

    private double computeHorizontalSpeed(CarriageContraptionEntity entity, float deltaTicks) {
        if (deltaTicks <= 0.0f) {
            return 0.0;
        }
        double x = entity.getX();
        double z = entity.getZ();
        if (!this.hasLastEntityPos) {
            this.hasLastEntityPos = true;
            this.lastEntityX = x;
            this.lastEntityZ = z;
            return 0.0;
        }
        double dx = x - this.lastEntityX;
        double dz = z - this.lastEntityZ;
        this.lastEntityX = x;
        this.lastEntityZ = z;
        return Math.sqrt(dx * dx + dz * dz) / (double)deltaTicks;
    }

    private void applyWheelAngle(float angleDegrees) {
        ((TransformedInstance)this.wheel.setTransform((Matrix4fc)this.baseTransform).rotateY(AngleHelper.rad((double)angleDegrees)).uncenter()).light(this.localBlockLight(), 0).setChanged();
    }

    protected void _delete() {
        this.shaft.delete();
        this.wheel.delete();
    }
}

