/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways;

import com.mojang.brigadier.CommandDispatcher;
import com.railwayteam.railways.content.buffer.BufferModelUtils;
import com.railwayteam.railways.content.conductor.ConductorCapModel;
import com.railwayteam.railways.content.conductor.ConductorEntityModel;
import com.railwayteam.railways.neoforge.RailwaysClientImpl;
import com.railwayteam.railways.ponder.CRPonderPlugin;
import com.railwayteam.railways.registry.CRBlockPartials;
import com.railwayteam.railways.registry.CRCommandsClient;
import com.railwayteam.railways.registry.CRDevCaps;
import com.railwayteam.railways.registry.CREdgePointTypes;
import com.railwayteam.railways.registry.CRKeys;
import com.railwayteam.railways.registry.CRPackets;
import com.railwayteam.railways.util.CustomTrackOverlayRendering;
import com.railwayteam.railways.util.DevCapeUtils;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.createmod.ponder.api.registration.PonderPlugin;
import net.createmod.ponder.foundation.PonderIndex;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.commands.SharedSuggestionProvider;

public class RailwaysClient {
    public static void init() {
        RailwaysClient.registerModelLayer(ConductorEntityModel.LAYER_LOCATION, ConductorEntityModel::createBodyLayer);
        RailwaysClient.registerModelLayer(ConductorCapModel.LAYER_LOCATION, ConductorCapModel::createBodyLayer);
        RailwaysClient.registerBuiltinPack("legacy_semaphore", "Steam 'n' Rails Legacy Semaphores");
        RailwaysClient.registerBuiltinPack("green_signals", "Steam 'n' Rails Green Signals");
        RailwaysClient.registerBuiltinPack("legacy_palettes", "Steam 'n' Rails Legacy Palettes Textures");
        RailwaysClient.registerClientCommands(CRCommandsClient::register);
        CRPackets.PACKETS.registerS2CListener();
        PonderIndex.addPlugin((PonderPlugin)new CRPonderPlugin());
        CRKeys.register();
        CRBlockPartials.init();
        CustomTrackOverlayRendering.register(CREdgePointTypes.COUPLER, CRBlockPartials.COUPLER_BOTH);
        CustomTrackOverlayRendering.register(CREdgePointTypes.SWITCH, CRBlockPartials.SWITCH_RIGHT_TURN);
        CRDevCaps.register();
        BufferModelUtils.register();
        DevCapeUtils.INSTANCE.init();
    }

    public static void registerClientCommands(Consumer<CommandDispatcher<SharedSuggestionProvider>> consumer) {
        RailwaysClientImpl.registerClientCommands(consumer);
    }

    public static void registerModelLayer(ModelLayerLocation layer, Supplier<LayerDefinition> definition) {
        RailwaysClientImpl.registerModelLayer(layer, definition);
    }

    public static void registerBuiltinPack(String id, String name) {
        RailwaysClientImpl.registerBuiltinPack(id, name);
    }
}

