/*
 * Decompiled with CFR 0.152.
 */
package net.unusual.blockfactorysbosses.procedures;

import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexBuffer;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Axis;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.Event;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.RenderGuiEvent;
import net.neoforged.neoforge.client.event.ScreenEvent;
import net.unusual.blockfactorysbosses.configuration.ConfigFileConfiguration;
import net.unusual.blockfactorysbosses.entity.InfernalDragonEntity;
import net.unusual.blockfactorysbosses.entity.SandwormEntity;
import net.unusual.blockfactorysbosses.entity.UnderworldKnightEntity;
import net.unusual.blockfactorysbosses.entity.YetiEntity;
import net.unusual.blockfactorysbosses.init.BlockFactorysBossesModAttributes;
import net.unusual.blockfactorysbosses.procedures.CinematicBarDisplayOverlayIngameProcedure;
import org.joml.Matrix4f;
import org.joml.Matrix4fStack;
import org.joml.Matrix4fc;

@EventBusSubscriber(value={Dist.CLIENT})
public class CustomBossBarProcedure {
    private static Map<EntityType, Entity> data = new HashMap<EntityType, Entity>();
    private static GuiGraphics guiGraphics = null;
    private static float partialTick = 0.0f;
    private static int currentStage = 0;
    private static int targetStage = 0;

    private static boolean target(int targetStage) {
        if (targetStage == currentStage) {
            CustomBossBarProcedure.targetStage = targetStage;
            return true;
        }
        if (targetStage == 1 && currentStage != 0) {
            CustomBossBarProcedure.targetStage = currentStage;
            return true;
        }
        return false;
    }

    private static void release() {
        targetStage = 0;
    }

    public static void renderEntity(LevelAccessor levelAccessor, EntityType type, double x, double y, double depth, float yaw, float pitch, float roll, float scale, boolean modelOnly) {
        if (currentStage == 0 || currentStage != targetStage) {
            return;
        }
        if (type == null) {
            return;
        }
        if (levelAccessor instanceof ClientLevel) {
            ClientLevel level = (ClientLevel)levelAccessor;
            if (Minecraft.getInstance().gameRenderer.getMainCamera() != null) {
                Entity entity = null;
                if (data.containsKey(type)) {
                    entity = data.get(type);
                } else {
                    entity = type.create((Level)level);
                    data.put(type, entity);
                }
                CustomBossBarProcedure.renderEntity(entity, 0.0f, x, y, depth, yaw, pitch, roll, scale, modelOnly);
            }
        }
    }

    public static void renderEntity(LevelAccessor levelAccessor, Entity entity, double x, double y, double depth, float yaw, float pitch, float roll, float scale, boolean modelOnly) {
        if (currentStage == 0 || currentStage != targetStage) {
            return;
        }
        Minecraft minecraft = Minecraft.getInstance();
        if (levelAccessor instanceof ClientLevel && minecraft.gameRenderer.getMainCamera() != null) {
            CustomBossBarProcedure.renderEntity(entity, partialTick, x, y, depth, yaw, pitch, roll, scale, modelOnly);
        }
    }

    private static void renderEntity(Entity entity, float partialTick, double x, double y, double depth, float yaw, float pitch, float roll, float scale, boolean modelOnly) {
        if (entity == null) {
            return;
        }
        float offset = entity.getBbHeight() / 2.0f;
        float yRotO = entity.yRotO;
        float yRot = entity.getYRot();
        float xRotO = entity.xRotO;
        float xRot = entity.getXRot();
        entity.yRotO = 180.0f;
        entity.setYRot(180.0f);
        entity.xRotO = 0.0f;
        entity.setXRot(0.0f);
        PoseStack poseStack = guiGraphics.pose();
        poseStack.pushPose();
        poseStack.translate(x, y, -depth);
        poseStack.mulPose(Axis.YN.rotationDegrees(yaw));
        poseStack.mulPose(Axis.XP.rotationDegrees(pitch));
        poseStack.mulPose(Axis.ZN.rotationDegrees(roll + 180.0f));
        poseStack.mulPose(new Matrix4f().scaling(scale, scale, -scale));
        poseStack.translate(0.0f, -offset, 0.0f);
        Lighting.setupForEntityInInventory();
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            float yBodyRotO = livingEntity.yBodyRotO;
            float yBodyRot = livingEntity.yBodyRot;
            float yHeadRotO = livingEntity.yHeadRotO;
            float yHeadRot = livingEntity.yHeadRot;
            livingEntity.yBodyRotO = 180.0f;
            livingEntity.yBodyRot = 180.0f;
            livingEntity.yHeadRotO = 180.0f;
            livingEntity.yHeadRot = 180.0f;
            CustomBossBarProcedure.renderEntity((Entity)livingEntity, partialTick, poseStack, modelOnly);
            livingEntity.yBodyRotO = yBodyRotO;
            livingEntity.yBodyRot = yBodyRot;
            livingEntity.yHeadRotO = yHeadRotO;
            livingEntity.yHeadRot = yHeadRot;
        } else {
            CustomBossBarProcedure.renderEntity(entity, partialTick, poseStack, modelOnly);
        }
        Lighting.setupFor3DItems();
        poseStack.popPose();
        entity.yRotO = yRotO;
        entity.setYRot(yRot);
        entity.xRotO = xRotO;
        entity.setXRot(xRot);
    }

    private static void renderEntity(Entity entity, float partialTick, PoseStack poseStack, boolean modelOnly) {
        Minecraft minecraft = Minecraft.getInstance();
        if (modelOnly) {
            boolean customNameVisible = entity.isCustomNameVisible();
            entity.setCustomNameVisible(false);
            minecraft.getEntityRenderDispatcher().getRenderer(entity).render(entity, 0.0f, partialTick, poseStack, (MultiBufferSource)guiGraphics.bufferSource(), 0xF000F0);
            guiGraphics.flush();
            entity.setCustomNameVisible(customNameVisible);
        } else {
            EntityRenderDispatcher renderer = minecraft.getEntityRenderDispatcher();
            renderer.setRenderShadow(false);
            renderer.render(entity, 0.0, 0.0, 0.0, 0.0f, partialTick, poseStack, (MultiBufferSource)guiGraphics.bufferSource(), 0xF000F0);
            guiGraphics.flush();
            renderer.setRenderShadow(true);
        }
    }

    public static void renderItem(LevelAccessor levelAccessor, ItemStack itemStack, double x, double y, double depth, float yaw, float pitch, float roll, float scale) {
        if (currentStage == 0 || currentStage != targetStage) {
            return;
        }
        if (itemStack.isEmpty()) {
            return;
        }
        Minecraft minecraft = Minecraft.getInstance();
        if (levelAccessor instanceof ClientLevel) {
            ClientLevel level = (ClientLevel)levelAccessor;
            if (minecraft.gameRenderer.getMainCamera() != null) {
                ItemRenderer renderer = minecraft.getItemRenderer();
                BakedModel bakedModel = renderer.getModel(itemStack, (Level)level, null, 0);
                PoseStack poseStack = guiGraphics.pose();
                poseStack.pushPose();
                poseStack.translate(x, y, -depth);
                poseStack.mulPose(Axis.YN.rotationDegrees(yaw));
                poseStack.mulPose(Axis.XP.rotationDegrees(pitch));
                poseStack.mulPose(Axis.ZN.rotationDegrees(roll));
                poseStack.mulPose(new Matrix4f().scaling(1.0f, -1.0f, 1.0f));
                poseStack.scale(scale, scale, scale);
                if (!bakedModel.usesBlockLight()) {
                    Lighting.setupForFlatItems();
                }
                renderer.render(itemStack, ItemDisplayContext.GUI, false, poseStack, (MultiBufferSource)guiGraphics.bufferSource(), 0xF000F0, OverlayTexture.NO_OVERLAY, bakedModel);
                guiGraphics.flush();
                Lighting.setupFor3DItems();
                poseStack.popPose();
            }
        }
    }

    public static void renderRectangle(float x1, float y1, float x2, float y2, float depth, int color) {
        float y4;
        float y3;
        float x4;
        float x3;
        if (currentStage == 0 || currentStage != targetStage) {
            return;
        }
        if (x1 <= x2) {
            x3 = x1;
            x4 = x2;
        } else {
            x3 = x2;
            x4 = x1;
        }
        if (y1 <= y2) {
            y3 = y1;
            y4 = y2;
        } else {
            y3 = y2;
            y4 = y1;
        }
        int red = color >> 16 & 0xFF;
        int green = color >> 8 & 0xFF;
        int blue = color & 0xFF;
        int alpha = color >>> 24;
        Matrix4f matrix4f = guiGraphics.pose().last().pose();
        VertexConsumer vertexConsumer = guiGraphics.bufferSource().getBuffer(RenderType.gui());
        vertexConsumer.addVertex(matrix4f, x3, y3, -depth).setColor(red, green, blue, alpha);
        vertexConsumer.addVertex(matrix4f, x3, y4, -depth).setColor(red, green, blue, alpha);
        vertexConsumer.addVertex(matrix4f, x4, y4, -depth).setColor(red, green, blue, alpha);
        vertexConsumer.addVertex(matrix4f, x4, y3, -depth).setColor(red, green, blue, alpha);
    }

    public static void renderShape(VertexBuffer vertexBuffer, double x, double y, double depth, float yaw, float pitch, float roll, float xScale, float yScale, float zScale, int color) {
        if (currentStage == 0 || currentStage != targetStage) {
            return;
        }
        if (vertexBuffer == null) {
            return;
        }
        PoseStack poseStack = guiGraphics.pose();
        poseStack.pushPose();
        poseStack.translate(x, y, -depth);
        poseStack.mulPose(Axis.YN.rotationDegrees(yaw));
        poseStack.mulPose(Axis.XP.rotationDegrees(pitch));
        poseStack.mulPose(Axis.ZN.rotationDegrees(roll));
        poseStack.scale(xScale, yScale, zScale);
        Matrix4fStack modelViewStack = RenderSystem.getModelViewStack();
        modelViewStack.pushMatrix();
        modelViewStack.mul((Matrix4fc)poseStack.last().pose());
        RenderSystem.setShaderColor((float)((float)(color >> 16 & 0xFF) / 255.0f), (float)((float)(color >> 8 & 0xFF) / 255.0f), (float)((float)(color & 0xFF) / 255.0f), (float)((float)(color >>> 24) / 255.0f));
        vertexBuffer.bind();
        vertexBuffer.drawWithShader((Matrix4f)modelViewStack, RenderSystem.getProjectionMatrix(), vertexBuffer.getFormat().hasUV(0) ? GameRenderer.getPositionTexColorShader() : GameRenderer.getPositionColorShader());
        VertexBuffer.unbind();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        modelViewStack.popMatrix();
        poseStack.popPose();
    }

    public static void renderTexts(String texts, float x, float y, float depth, float angle, float scale, int color, int alignment) {
        if (currentStage == 0 || currentStage != targetStage) {
            return;
        }
        Font font = Minecraft.getInstance().font;
        float offsetX = 0.0f;
        float offsetY = 0.0f;
        switch (alignment) {
            case 0: {
                offsetX = (float)(font.width(texts) - 1) * 0.5f;
                Objects.requireNonNull(font);
                offsetY = (float)(9 - 1) * 0.5f;
                break;
            }
            case 1: {
                Objects.requireNonNull(font);
                offsetY = (float)(9 - 1) * 0.5f;
                break;
            }
            case 2: {
                offsetX = (float)(font.width(texts) - 1) * -0.5f;
                Objects.requireNonNull(font);
                offsetY = (float)(9 - 1) * 0.5f;
                break;
            }
            case 3: {
                offsetX = (float)(font.width(texts) - 1) * 0.5f;
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                offsetX = (float)(font.width(texts) - 1) * -0.5f;
                break;
            }
            case 6: {
                offsetX = (float)(font.width(texts) - 1) * 0.5f;
                Objects.requireNonNull(font);
                offsetY = (float)(9 - 1) * -0.5f;
                break;
            }
            case 7: {
                Objects.requireNonNull(font);
                offsetY = (float)(9 - 1) * -0.5f;
                break;
            }
            case 8: {
                offsetX = (float)(font.width(texts) - 1) * -0.5f;
                Objects.requireNonNull(font);
                offsetY = (float)(9 - 1) * -0.5f;
            }
        }
        PoseStack poseStack = guiGraphics.pose();
        poseStack.pushPose();
        poseStack.translate(x + offsetX * scale, y + offsetY * scale, -depth);
        poseStack.mulPose(Axis.ZN.rotationDegrees(angle));
        poseStack.scale(scale, scale, 1.0f);
        float f = (float)(font.width(texts) - 1) * -0.5f;
        Objects.requireNonNull(font);
        poseStack.translate(f, (float)(9 - 1) * -0.5f, 0.0f);
        Matrix4f matrix4f = poseStack.last().pose();
        font.drawInBatch(texts, 0.0f, 0.0f, color, false, matrix4f, (MultiBufferSource)guiGraphics.bufferSource(), Font.DisplayMode.NORMAL, 0, 0xF000F0);
        poseStack.popPose();
    }

    public static void renderTexture(ResourceLocation texture, float x, float y, float depth, float angle, float scale, int color, int alignment, int u, int v, float width, float max_width, float height) {
        if (currentStage == 0 || currentStage != targetStage) {
            return;
        }
        float offsetX = 0.0f;
        float offsetY = 0.0f;
        switch (alignment) {
            case 0: {
                offsetX = 0.5f;
                offsetY = 0.5f;
                break;
            }
            case 1: {
                offsetY = 0.5f;
                break;
            }
            case 2: {
                offsetX = -0.5f;
                offsetY = 0.5f;
                break;
            }
            case 3: {
                offsetX = 0.5f;
                break;
            }
            case 5: {
                offsetX = -0.5f;
                break;
            }
            case 6: {
                offsetX = 0.5f;
                offsetY = -0.5f;
                break;
            }
            case 7: {
                offsetY = -0.5f;
                break;
            }
            case 8: {
                offsetX = -0.5f;
                offsetY = -0.5f;
            }
        }
        RenderSystem.setShader(GameRenderer::getPositionTexColorShader);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)texture);
        float texW = 1.0f / max_width;
        float texH = 1.0f / height;
        float u1 = (float)u * texW;
        float v1 = (float)v * texH;
        float u2 = ((float)u + width) * texW;
        float v2 = ((float)v + height) * texH;
        int red = color >> 16 & 0xFF;
        int green = color >> 8 & 0xFF;
        int blue = color & 0xFF;
        int alpha = color >>> 24;
        PoseStack poseStack = guiGraphics.pose();
        poseStack.pushPose();
        poseStack.translate(x, y, -depth);
        poseStack.mulPose(Axis.ZN.rotationDegrees(angle));
        poseStack.scale(width * scale, height * scale, 1.0f);
        poseStack.translate(offsetX * 2.0f, offsetY, 0.0f);
        Matrix4f matrix = poseStack.last().pose();
        BufferBuilder buffer = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX_COLOR);
        buffer.addVertex(matrix, 0.0f, 1.0f, 0.0f).setUv(u1, v2).setColor(red, green, blue, alpha);
        buffer.addVertex(matrix, 0.0f, 0.0f, 0.0f).setUv(u1, v1).setColor(red, green, blue, alpha);
        buffer.addVertex(matrix, 1.0f, 0.0f, 0.0f).setUv(u2, v1).setColor(red, green, blue, alpha);
        buffer.addVertex(matrix, 1.0f, 1.0f, 0.0f).setUv(u2, v2).setColor(red, green, blue, alpha);
        BufferUploader.drawWithShader((MeshData)buffer.buildOrThrow());
        poseStack.popPose();
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void renderGUI(RenderGuiEvent.Pre event) {
        currentStage = 2;
        guiGraphics = event.getGuiGraphics();
        partialTick = event.getPartialTick().getGameTimeDeltaPartialTick(false);
        CustomBossBarProcedure.renderOverlays((Event)event);
        currentStage = 0;
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void renderScreen(ScreenEvent.Render.Post event) {
        currentStage = 3;
        guiGraphics = event.getGuiGraphics();
        partialTick = event.getPartialTick();
        CustomBossBarProcedure.renderOverlays((Event)event);
        currentStage = 0;
    }

    private static void renderOverlays(Event event) {
        Minecraft minecraft = Minecraft.getInstance();
        double scale = minecraft.getWindow().getGuiScale();
        if (scale > 0.0) {
            RenderSystem.depthMask((boolean)true);
            RenderSystem.enableDepthTest();
            RenderSystem.disableCull();
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            CustomBossBarProcedure.execute(event);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.defaultBlendFunc();
            RenderSystem.disableBlend();
            RenderSystem.enableCull();
            RenderSystem.enableDepthTest();
            RenderSystem.depthMask((boolean)true);
        }
    }

    public static void execute() {
        CustomBossBarProcedure.execute(null);
    }

    private static void execute(@Nullable Event event) {
        double nb = 0.0;
        if (CustomBossBarProcedure.target(2)) {
            if (Minecraft.getInstance().player != null) {
                Player ply;
                Minecraft minecraft = Minecraft.getInstance();
                LocalPlayer entity = Minecraft.getInstance().player;
                double x = entity.getX();
                double y = entity.getY();
                double z = entity.getZ();
                Level world = entity.level();
                ResourceKey dimension = entity.level().dimension();
                if (entity instanceof Player && (ply = (Player)entity).getAttribute(BlockFactorysBossesModAttributes.ROLL_ANIMTIME).getBaseValue() > 0.0 && !Minecraft.getInstance().options.hideGui) {
                    float barWidth0 = 20.0f;
                    float barHeight0 = 7.0f;
                    float progressScaled0 = (1.0f - (float)ply.getAttribute(BlockFactorysBossesModAttributes.ROLL_ANIMTIME).getBaseValue() / 90.0f) * 20.0f;
                    if (ply.getAttribute(BlockFactorysBossesModAttributes.ROLL_ANIMTIME).getBaseValue() >= 90.0) {
                        progressScaled0 = 20.0f;
                    }
                    int color0 = -1;
                    CustomBossBarProcedure.renderTexture(ResourceLocation.parse((String)"block_factorys_bosses:textures/bossbar/dash_base.png"), ((float)Minecraft.getInstance().getWindow().getGuiScaledWidth() - 20.0f) * 0.5f, ((float)Minecraft.getInstance().getWindow().getGuiScaledHeight() - 36.0f) * 0.5f, 0.0f, 0.0f, 1.0f, color0, 1, 0, 7, barWidth0, barWidth0, barHeight0);
                    CustomBossBarProcedure.renderTexture(ResourceLocation.parse((String)"block_factorys_bosses:textures/bossbar/dash_bar.png"), ((float)Minecraft.getInstance().getWindow().getGuiScaledWidth() - 20.0f) * 0.5f, ((float)Minecraft.getInstance().getWindow().getGuiScaledHeight() - 36.0f) * 0.5f, 0.0f, 0.0f, 1.0f, color0, 1, 0, 7, progressScaled0, barWidth0, barHeight0);
                }
                if (world instanceof ClientLevel && !CinematicBarDisplayOverlayIngameProcedure.execute((LevelAccessor)world, x, y, z) && !Minecraft.getInstance().options.hideGui) {
                    nb = 0.0;
                    for (Entity entityiterator : ((ClientLevel)world).entitiesForRendering()) {
                        UnderworldKnightEntity knight;
                        SandwormEntity worm;
                        InfernalDragonEntity dragon;
                        if (entityiterator instanceof InfernalDragonEntity && (Integer)(dragon = (InfernalDragonEntity)entityiterator).getEntityData().get(InfernalDragonEntity.DATA_boss_phase) > -2) {
                            barWidth = 288.0f;
                            barHeight = 76.0f;
                            progressScaled = 53.0f + dragon.getHealth() / dragon.getMaxHealth() * 182.0f;
                            color = -1;
                            if (((Boolean)ConfigFileConfiguration.CUSTOM_BOSSBAR.get()).booleanValue()) {
                                CustomBossBarProcedure.renderTexture(ResourceLocation.parse((String)"block_factorys_bosses:textures/bossbar/dragon_base.png"), ((float)Minecraft.getInstance().getWindow().getGuiScaledWidth() - 280.0f) * 0.5f, 26.0f * (float)nb - 10.0f, 0.0f, 0.0f, 1.0f, color, 4, 0, 76, barWidth, barWidth, barHeight);
                            } else {
                                CustomBossBarProcedure.renderTexture(ResourceLocation.parse((String)"block_factorys_bosses:textures/bossbar/simple_dragon_base.png"), ((float)Minecraft.getInstance().getWindow().getGuiScaledWidth() - 280.0f) * 0.5f, 26.0f * (float)nb - 10.0f, 0.0f, 0.0f, 1.0f, color, 4, 0, 76, barWidth, barWidth, barHeight);
                            }
                            CustomBossBarProcedure.renderTexture(ResourceLocation.parse((String)"block_factorys_bosses:textures/bossbar/dragon_bar.png"), ((float)Minecraft.getInstance().getWindow().getGuiScaledWidth() - 280.0f) * 0.5f, 26.0f * (float)nb - 10.0f, 0.0f, 0.0f, 1.0f, color, 4, 0, 76, progressScaled, barWidth, barHeight);
                            nb += 1.0;
                        } else if (entityiterator instanceof SandwormEntity && (Integer)(worm = (SandwormEntity)entityiterator).getEntityData().get(SandwormEntity.DATA_boss_phase) > -1) {
                            barWidth = 288.0f;
                            barHeight = 76.0f;
                            progressScaled = 53.0f + worm.getHealth() / worm.getMaxHealth() * 182.0f;
                            color = -1;
                            if (((Boolean)ConfigFileConfiguration.CUSTOM_BOSSBAR.get()).booleanValue()) {
                                CustomBossBarProcedure.renderTexture(ResourceLocation.parse((String)"block_factorys_bosses:textures/bossbar/worm_base.png"), ((float)Minecraft.getInstance().getWindow().getGuiScaledWidth() - 280.0f) * 0.5f, 26.0f * (float)nb - 10.0f, 0.0f, 0.0f, 1.0f, color, 4, 0, 76, barWidth, barWidth, barHeight);
                            } else {
                                CustomBossBarProcedure.renderTexture(ResourceLocation.parse((String)"block_factorys_bosses:textures/bossbar/simple_worm_base.png"), ((float)Minecraft.getInstance().getWindow().getGuiScaledWidth() - 280.0f) * 0.5f, 26.0f * (float)nb - 10.0f, 0.0f, 0.0f, 1.0f, color, 4, 0, 76, barWidth, barWidth, barHeight);
                            }
                            CustomBossBarProcedure.renderTexture(ResourceLocation.parse((String)"block_factorys_bosses:textures/bossbar/worm_bar.png"), ((float)Minecraft.getInstance().getWindow().getGuiScaledWidth() - 280.0f) * 0.5f, 26.0f * (float)nb - 10.0f, 0.0f, 0.0f, 1.0f, color, 4, 0, 76, progressScaled, barWidth, barHeight);
                            nb += 1.0;
                        } else if (entityiterator instanceof YetiEntity) {
                            YetiEntity yeti = (YetiEntity)entityiterator;
                            barWidth = 288.0f;
                            barHeight = 76.0f;
                            progressScaled = 53.0f + yeti.getHealth() / yeti.getMaxHealth() * 182.0f;
                            color = -1;
                            if (((Boolean)ConfigFileConfiguration.CUSTOM_BOSSBAR.get()).booleanValue()) {
                                CustomBossBarProcedure.renderTexture(ResourceLocation.parse((String)"block_factorys_bosses:textures/bossbar/yeti_base.png"), ((float)Minecraft.getInstance().getWindow().getGuiScaledWidth() - 280.0f) * 0.5f, 26.0f * (float)nb - 10.0f, 0.0f, 0.0f, 1.0f, color, 4, 0, 76, barWidth, barWidth, barHeight);
                            } else {
                                CustomBossBarProcedure.renderTexture(ResourceLocation.parse((String)"block_factorys_bosses:textures/bossbar/simple_yeti_base.png"), ((float)Minecraft.getInstance().getWindow().getGuiScaledWidth() - 280.0f) * 0.5f, 26.0f * (float)nb - 10.0f, 0.0f, 0.0f, 1.0f, color, 4, 0, 76, barWidth, barWidth, barHeight);
                            }
                            CustomBossBarProcedure.renderTexture(ResourceLocation.parse((String)"block_factorys_bosses:textures/bossbar/yeti_bar.png"), ((float)Minecraft.getInstance().getWindow().getGuiScaledWidth() - 280.0f) * 0.5f, 26.0f * (float)nb - 10.0f, 0.0f, 0.0f, 1.0f, color, 4, 0, 76, progressScaled, barWidth, barHeight);
                            nb += 1.0;
                        } else if (entityiterator instanceof UnderworldKnightEntity && (Integer)(knight = (UnderworldKnightEntity)entityiterator).getEntityData().get(UnderworldKnightEntity.DATA_boss_phase) > -1) {
                            barWidth = 288.0f;
                            barHeight = 76.0f;
                            progressScaled = 53.0f + knight.getHealth() / knight.getMaxHealth() * 182.0f;
                            color = -1;
                            if (((Boolean)ConfigFileConfiguration.CUSTOM_BOSSBAR.get()).booleanValue()) {
                                CustomBossBarProcedure.renderTexture(ResourceLocation.parse((String)"block_factorys_bosses:textures/bossbar/knight_base.png"), ((float)Minecraft.getInstance().getWindow().getGuiScaledWidth() - 280.0f) * 0.5f, 26.0f * (float)nb - 10.0f, 0.0f, 0.0f, 1.0f, color, 4, 0, 76, barWidth, barWidth, barHeight);
                            } else {
                                CustomBossBarProcedure.renderTexture(ResourceLocation.parse((String)"block_factorys_bosses:textures/bossbar/simple_knight_base.png"), ((float)Minecraft.getInstance().getWindow().getGuiScaledWidth() - 280.0f) * 0.5f, 26.0f * (float)nb - 10.0f, 0.0f, 0.0f, 1.0f, color, 4, 0, 76, barWidth, barWidth, barHeight);
                            }
                            CustomBossBarProcedure.renderTexture(ResourceLocation.parse((String)"block_factorys_bosses:textures/bossbar/knight_bar.png"), ((float)Minecraft.getInstance().getWindow().getGuiScaledWidth() - 280.0f) * 0.5f, 26.0f * (float)nb - 10.0f, 0.0f, 0.0f, 1.0f, color, 4, 0, 76, progressScaled, barWidth, barHeight);
                            nb += 1.0;
                        }
                        if (!(nb > 3.0)) continue;
                        break;
                    }
                }
            }
            CustomBossBarProcedure.release();
        }
    }
}

