/*
 * Decompiled with CFR 0.152.
 */
package net.unusual.blockfactorysbosses.item;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Map;
import java.util.UUID;
import java.util.WeakHashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;
import net.neoforged.neoforge.client.extensions.common.RegisterClientExtensionsEvent;
import net.unusual.blockfactorysbosses.LargeSwordItemRenderer;
import net.unusual.blockfactorysbosses.init.BlockFactorysBossesModItems;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public class LargeSwordItem
extends SwordItem {
    public static final Map<String, AnimationState> IDLE_STATES = new WeakHashMap<String, AnimationState>();
    public static final Map<String, AnimationState> SWING_STATES = new WeakHashMap<String, AnimationState>();
    public static final Map<ItemStack, Integer> IS_MINING = new WeakHashMap<ItemStack, Integer>();
    private static final Tier TOOL_TIER = new Tier(){

        public int getUses() {
            return 400;
        }

        public float getSpeed() {
            return 4.0f;
        }

        public float getAttackDamageBonus() {
            return 0.0f;
        }

        public TagKey<Block> getIncorrectBlocksForDrops() {
            return BlockTags.INCORRECT_FOR_IRON_TOOL;
        }

        public int getEnchantmentValue() {
            return 2;
        }

        public Ingredient getRepairIngredient() {
            return Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)BlockFactorysBossesModItems.ANCIENT_IRON_INGOT.get())});
        }
    };

    public LargeSwordItem() {
        super(TOOL_TIER, new Item.Properties().attributes(ItemAttributeModifiers.builder().add(Attributes.ENTITY_INTERACTION_RANGE, new AttributeModifier(ResourceLocation.withDefaultNamespace((String)"base_entity_interaction_range"), 1.5, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND).add(Attributes.ATTACK_DAMAGE, new AttributeModifier(BASE_ATTACK_DAMAGE_ID, (double)(11.0f + TOOL_TIER.getAttackDamageBonus()), AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND).add(Attributes.ATTACK_SPEED, new AttributeModifier(BASE_ATTACK_SPEED_ID, (double)-3.3f, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND).build()));
    }

    public void inventoryTick(ItemStack itemstack, Level world, Entity entity, int slot, boolean selected) {
        double swing_animtime;
        super.inventoryTick(itemstack, world, entity, slot, selected);
        if (((CustomData)itemstack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag().getString("itemKey").isEmpty()) {
            CustomData.update((DataComponentType)DataComponents.CUSTOM_DATA, (ItemStack)itemstack, tag -> tag.putString("itemKey", UUID.randomUUID().toString()));
        }
        String key = ((CustomData)itemstack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag().getString("itemKey");
        int is_mining = IS_MINING.computeIfAbsent(itemstack, s -> 0);
        if (is_mining > 0) {
            IS_MINING.put(itemstack, is_mining - 1);
        }
        if ((swing_animtime = ((CustomData)itemstack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag().getDouble("swing_animtime")) > 0.0) {
            CustomData.update((DataComponentType)DataComponents.CUSTOM_DATA, (ItemStack)itemstack, tag -> tag.putDouble("swing_animtime", ((CustomData)itemstack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag().getDouble("swing_animtime") - 1.0));
        }
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return false;
    }

    public float getDestroySpeed(ItemStack itemstack, BlockState blockstate) {
        IS_MINING.put(itemstack, 5);
        if (((CustomData)itemstack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag().getDouble("swing_animtime") == 0.0) {
            return 1.0f;
        }
        return 0.0f;
    }

    public boolean onEntitySwing(ItemStack itemstack, LivingEntity entity, InteractionHand hand) {
        double swing_animtime;
        boolean retval = super.onEntitySwing(itemstack, entity, hand);
        int is_mining = IS_MINING.computeIfAbsent(itemstack, s -> 0);
        if (is_mining == 0 && (swing_animtime = ((CustomData)itemstack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag().getDouble("swing_animtime")) == 0.0 && entity instanceof Player) {
            Player plr = (Player)entity;
            this.playSound(plr, (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"block_factorys_bosses:large_sword_swing")));
            CustomData.update((DataComponentType)DataComponents.CUSTOM_DATA, (ItemStack)itemstack, tag -> tag.putString("itemKey", UUID.randomUUID().toString()));
            CustomData.update((DataComponentType)DataComponents.CUSTOM_DATA, (ItemStack)itemstack, tag -> tag.putDouble("swing_animtime", 14.0));
        }
        return retval;
    }

    @SubscribeEvent
    public static void registerClientExtensions(RegisterClientExtensionsEvent event) {
        event.registerItem(new IClientItemExtensions(){
            private LargeSwordItemRenderer rendererInstance;

            @OnlyIn(value=Dist.CLIENT)
            public boolean applyForgeHandTransform(PoseStack poseStack, LocalPlayer player, HumanoidArm arm, ItemStack itemInHand, float partialTick, float equipProcess, float swingProcess) {
                int is_mining = IS_MINING.computeIfAbsent(player.getMainHandItem(), s -> 0);
                double swing_animtime = ((CustomData)player.getMainHandItem().getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag().getDouble("swing_animtime");
                if (is_mining == 0 && swing_animtime > 0.0) {
                    int i = arm == HumanoidArm.RIGHT ? 1 : -1;
                    poseStack.translate((float)i * 0.56f, -0.52f, -0.72f);
                    if (player.getUseItem() == itemInHand) {
                        poseStack.translate(0.05, 0.05, 0.05);
                    }
                    return true;
                }
                return false;
            }

            @OnlyIn(value=Dist.CLIENT)
            public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                if (this.rendererInstance == null) {
                    this.rendererInstance = new LargeSwordItemRenderer(Minecraft.getInstance().getBlockEntityRenderDispatcher(), Minecraft.getInstance().getEntityModels());
                }
                return this.rendererInstance;
            }
        }, new Item[]{(Item)BlockFactorysBossesModItems.LARGE_SWORD.get()});
    }

    protected void playSound(Player player, SoundEvent soundEvent) {
        player.playSound(soundEvent, 1.0f, 1.0f);
    }
}

