/*
 * Decompiled with CFR 0.152.
 */
package samebutdifferent.ecologics.worldgen.structure.structures;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.ConstantInt;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.monster.Husk;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructurePieceAccessor;
import net.minecraft.world.level.levelgen.structure.TemplateStructurePiece;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.templatesystem.AlwaysTrueTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.BlockIgnoreProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.BlockMatchTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.BlockRotProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.CappedProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.PosAlwaysTrueTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.PosRuleTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.ProcessorRule;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import net.minecraft.world.level.levelgen.structure.templatesystem.rule.blockentity.AppendLoot;
import net.minecraft.world.level.levelgen.structure.templatesystem.rule.blockentity.RuleBlockEntityModifier;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootTable;
import samebutdifferent.ecologics.worldgen.structure.DesertRuinStructure;
import samebutdifferent.ecologics.worldgen.structure.pieces.ModStructurePieces;

public class DesertRuinPieces {
    static final StructureProcessor DESERT_RUIN_PROCESSOR = DesertRuinPieces.archyRuleProcessor(Blocks.SAND, Blocks.SUSPICIOUS_SAND, (ResourceKey<LootTable>)BuiltInLootTables.DESERT_PYRAMID_ARCHAEOLOGY);
    private static final ResourceLocation[] DESERT_RUINS = new ResourceLocation[]{ResourceLocation.fromNamespaceAndPath((String)"ecologics", (String)"desert_ruin/chest_house"), ResourceLocation.fromNamespaceAndPath((String)"ecologics", (String)"desert_ruin/pit"), ResourceLocation.fromNamespaceAndPath((String)"ecologics", (String)"desert_ruin/pillars1"), ResourceLocation.fromNamespaceAndPath((String)"ecologics", (String)"desert_ruin/pillars2"), ResourceLocation.fromNamespaceAndPath((String)"ecologics", (String)"desert_ruin/wall1"), ResourceLocation.fromNamespaceAndPath((String)"ecologics", (String)"desert_ruin/wall2")};

    private static StructureProcessor archyRuleProcessor(Block block, Block suspiciousBlock, ResourceKey<LootTable> lootTable) {
        return new CappedProcessor((StructureProcessor)new RuleProcessor(List.of(new ProcessorRule((RuleTest)new BlockMatchTest(block), (RuleTest)AlwaysTrueTest.INSTANCE, (PosRuleTest)PosAlwaysTrueTest.INSTANCE, suspiciousBlock.defaultBlockState(), (RuleBlockEntityModifier)new AppendLoot(lootTable)))), (IntProvider)ConstantInt.of((int)5));
    }

    private static ResourceLocation getRandomRuin(RandomSource random) {
        return (ResourceLocation)Util.getRandom((Object[])DESERT_RUINS, (RandomSource)random);
    }

    public static void addPieces(StructureTemplateManager structureTemplateManager, BlockPos pos, Rotation rotation, StructurePieceAccessor structurePieceAccessor, RandomSource random, DesertRuinStructure structure) {
        DesertRuinPieces.addPiece(structureTemplateManager, pos, rotation, structurePieceAccessor, random, structure, 0.9f);
        if (random.nextFloat() <= 0.4f) {
            DesertRuinPieces.addClusterRuins(structureTemplateManager, random, rotation, pos, structure, structurePieceAccessor);
        }
    }

    private static void addClusterRuins(StructureTemplateManager structureTemplateManager, RandomSource random, Rotation rotation, BlockPos pos, DesertRuinStructure structure, StructurePieceAccessor structurePieceAccessor) {
        BlockPos blockPos = new BlockPos(pos.getX(), 90, pos.getZ());
        BlockPos blockPos2 = StructureTemplate.transform((BlockPos)new BlockPos(15, 0, 15), (Mirror)Mirror.NONE, (Rotation)rotation, (BlockPos)BlockPos.ZERO).offset((Vec3i)blockPos);
        BoundingBox boundingBox = BoundingBox.fromCorners((Vec3i)blockPos, (Vec3i)blockPos2);
        BlockPos blockPos3 = new BlockPos(Math.min(blockPos.getX(), blockPos2.getX()), blockPos.getY(), Math.min(blockPos.getZ(), blockPos2.getZ()));
        List<BlockPos> list = DesertRuinPieces.allPositions(random, blockPos3);
        int i = Mth.nextInt((RandomSource)random, (int)4, (int)8);
        for (int j = 0; j < i; ++j) {
            Rotation rotation2;
            BlockPos blockPos4;
            if (list.isEmpty() || BoundingBox.fromCorners((Vec3i)(blockPos4 = list.remove(random.nextInt(list.size()))), (Vec3i)StructureTemplate.transform((BlockPos)new BlockPos(5, 0, 6), (Mirror)Mirror.NONE, (Rotation)(rotation2 = Rotation.getRandom((RandomSource)random)), (BlockPos)BlockPos.ZERO).offset((Vec3i)blockPos4)).intersects(boundingBox)) continue;
            DesertRuinPieces.addPiece(structureTemplateManager, blockPos4, rotation2, structurePieceAccessor, random, structure, 0.8f);
        }
    }

    private static List<BlockPos> allPositions(RandomSource random, BlockPos pos) {
        ArrayList list = Lists.newArrayList();
        list.add(pos.offset(-16 + Mth.nextInt((RandomSource)random, (int)1, (int)8), 0, 16 + Mth.nextInt((RandomSource)random, (int)1, (int)7)));
        list.add(pos.offset(-16 + Mth.nextInt((RandomSource)random, (int)1, (int)8), 0, Mth.nextInt((RandomSource)random, (int)1, (int)7)));
        list.add(pos.offset(-16 + Mth.nextInt((RandomSource)random, (int)1, (int)8), 0, -16 + Mth.nextInt((RandomSource)random, (int)4, (int)8)));
        list.add(pos.offset(Mth.nextInt((RandomSource)random, (int)1, (int)7), 0, 16 + Mth.nextInt((RandomSource)random, (int)1, (int)7)));
        list.add(pos.offset(Mth.nextInt((RandomSource)random, (int)1, (int)7), 0, -16 + Mth.nextInt((RandomSource)random, (int)4, (int)6)));
        list.add(pos.offset(16 + Mth.nextInt((RandomSource)random, (int)1, (int)7), 0, 16 + Mth.nextInt((RandomSource)random, (int)3, (int)8)));
        list.add(pos.offset(16 + Mth.nextInt((RandomSource)random, (int)1, (int)7), 0, Mth.nextInt((RandomSource)random, (int)1, (int)7)));
        list.add(pos.offset(16 + Mth.nextInt((RandomSource)random, (int)1, (int)7), 0, -16 + Mth.nextInt((RandomSource)random, (int)4, (int)8)));
        return list;
    }

    private static void addPiece(StructureTemplateManager structureTemplateManager, BlockPos pos, Rotation rotation, StructurePieceAccessor structurePieceAccessor, RandomSource random, DesertRuinStructure structure, float integrity) {
        ResourceLocation resourceLocation = DesertRuinPieces.getRandomRuin(random);
        structurePieceAccessor.addPiece((StructurePiece)new DesertRuinPiece(structureTemplateManager, resourceLocation, pos, rotation, integrity));
    }

    public static class DesertRuinPiece
    extends TemplateStructurePiece {
        private final float integrity;

        public DesertRuinPiece(StructureTemplateManager structureTemplateManager, ResourceLocation location, BlockPos pos, Rotation rotation, float integrity) {
            super(ModStructurePieces.DESERT_RUIN, 0, structureTemplateManager, location, location.toString(), DesertRuinPiece.makeSettings(rotation, integrity), pos);
            this.integrity = integrity;
        }

        private DesertRuinPiece(StructureTemplateManager structureTemplateManager, CompoundTag genDepth, Rotation rotation, float integrity) {
            super(ModStructurePieces.DESERT_RUIN, genDepth, structureTemplateManager, resourceLocation -> DesertRuinPiece.makeSettings(rotation, integrity));
            this.integrity = integrity;
        }

        private static StructurePlaceSettings makeSettings(Rotation rotation, float integrity) {
            StructureProcessor structureProcessor = DESERT_RUIN_PROCESSOR;
            return new StructurePlaceSettings().setRotation(rotation).setMirror(Mirror.NONE).addProcessor((StructureProcessor)new BlockRotProcessor(integrity)).addProcessor((StructureProcessor)BlockIgnoreProcessor.STRUCTURE_AND_AIR).addProcessor(structureProcessor);
        }

        public static DesertRuinPiece create(StructureTemplateManager structureTemplateManager, CompoundTag tag) {
            Rotation rotation = Rotation.valueOf((String)tag.getString("Rot"));
            float f = tag.getFloat("Integrity");
            return new DesertRuinPiece(structureTemplateManager, tag, rotation, f);
        }

        protected void addAdditionalSaveData(StructurePieceSerializationContext context, CompoundTag tag) {
            super.addAdditionalSaveData(context, tag);
            tag.putString("Rot", this.placeSettings.getRotation().name());
            tag.putFloat("Integrity", this.integrity);
        }

        protected void handleDataMarker(String name, BlockPos pos, ServerLevelAccessor level, RandomSource random, BoundingBox box) {
            Husk husk;
            if ("chest".equals(name)) {
                level.setBlock(pos, (BlockState)Blocks.CHEST.defaultBlockState().setValue((Property)ChestBlock.WATERLOGGED, (Comparable)Boolean.valueOf(level.getFluidState(pos).is(FluidTags.WATER))), 2);
                BlockEntity blockEntity = level.getBlockEntity(pos);
                if (blockEntity instanceof ChestBlockEntity) {
                    ((ChestBlockEntity)blockEntity).setLootTable(BuiltInLootTables.TRAIL_RUINS_ARCHAEOLOGY_COMMON, random.nextLong());
                }
            } else if ("drowned".equals(name) && (husk = (Husk)EntityType.HUSK.create((Level)level.getLevel())) != null) {
                husk.setPersistenceRequired();
                husk.moveTo(pos, 0.0f, 0.0f);
                husk.finalizeSpawn(level, level.getCurrentDifficultyAt(pos), MobSpawnType.STRUCTURE, null);
                level.addFreshEntityWithPassengers((Entity)husk);
                if (pos.getY() > level.getSeaLevel()) {
                    level.setBlock(pos, Blocks.AIR.defaultBlockState(), 2);
                } else {
                    level.setBlock(pos, Blocks.WATER.defaultBlockState(), 2);
                }
            }
        }

        public void postProcess(WorldGenLevel level, StructureManager structureManager, ChunkGenerator generator, RandomSource random, BoundingBox box, ChunkPos chunkPos, BlockPos pos) {
            int i = level.getHeight(Heightmap.Types.WORLD_SURFACE_WG, this.templatePosition.getX(), this.templatePosition.getZ());
            this.templatePosition = new BlockPos(this.templatePosition.getX(), i, this.templatePosition.getZ());
            BlockPos blockPos = StructureTemplate.transform((BlockPos)new BlockPos(this.template.getSize().getX() - 1, 0, this.template.getSize().getZ() - 1), (Mirror)Mirror.NONE, (Rotation)this.placeSettings.getRotation(), (BlockPos)BlockPos.ZERO).offset((Vec3i)this.templatePosition);
            this.templatePosition = new BlockPos(this.templatePosition.getX(), this.getHeight(this.templatePosition, (BlockGetter)level, blockPos), this.templatePosition.getZ());
            super.postProcess(level, structureManager, generator, random, box, chunkPos, pos);
        }

        private int getHeight(BlockPos templatePos, BlockGetter level, BlockPos pos) {
            int i = templatePos.getY();
            int j = 512;
            int k = i - 1;
            int l = 0;
            for (BlockPos blockPos : BlockPos.betweenClosed((BlockPos)templatePos, (BlockPos)pos)) {
                int m = blockPos.getX();
                int n = blockPos.getZ();
                int o = templatePos.getY() - 1;
                BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos(m, o, n);
                BlockState blockState = level.getBlockState((BlockPos)mutableBlockPos);
                FluidState fluidState = level.getFluidState((BlockPos)mutableBlockPos);
                while ((blockState.isAir() || fluidState.is(FluidTags.WATER) || blockState.is(BlockTags.ICE)) && o > level.getMinBuildHeight() + 1) {
                    mutableBlockPos.set(m, --o, n);
                    blockState = level.getBlockState((BlockPos)mutableBlockPos);
                    fluidState = level.getFluidState((BlockPos)mutableBlockPos);
                }
                j = Math.min(j, o);
                if (o >= k - 2) continue;
                ++l;
            }
            int p = Math.abs(templatePos.getX() - pos.getX());
            if (k - j > 2 && l > p - 2) {
                i = j + 1;
            }
            return i;
        }
    }
}

