/*
 * Decompiled with CFR 0.152.
 */
package samebutdifferent.ecologics.worldgen.structure;

import com.mojang.serialization.MapCodec;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructurePieceAccessor;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePiecesBuilder;
import net.minecraft.world.level.levelgen.structure.structures.DesertPyramidStructure;
import samebutdifferent.ecologics.registry.ModStructures;
import samebutdifferent.ecologics.worldgen.structure.structures.DesertRuinPieces;

public class DesertRuinStructure
extends Structure {
    public static final MapCodec<DesertRuinStructure> CODEC = DesertPyramidStructure.simpleCodec(DesertRuinStructure::new);

    public DesertRuinStructure(Structure.StructureSettings structureSettings) {
        super(structureSettings);
    }

    public StructureType<?> type() {
        return ModStructures.DESERT_RUIN;
    }

    protected Optional<Structure.GenerationStub> findGenerationPoint(Structure.GenerationContext context) {
        return DesertRuinStructure.onTopOfChunkCenter((Structure.GenerationContext)context, (Heightmap.Types)Heightmap.Types.WORLD_SURFACE_WG, structurePiecesBuilder -> this.generatePieces((StructurePiecesBuilder)structurePiecesBuilder, context));
    }

    private void generatePieces(StructurePiecesBuilder builder, Structure.GenerationContext context) {
        BlockPos blockPos = new BlockPos(context.chunkPos().getMinBlockX(), 90, context.chunkPos().getMinBlockZ());
        Rotation rotation = Rotation.getRandom((RandomSource)context.random());
        DesertRuinPieces.addPieces(context.structureTemplateManager(), blockPos, rotation, (StructurePieceAccessor)builder, (RandomSource)context.random(), this);
    }
}

