/*
 * Decompiled with CFR 0.152.
 */
package samebutdifferent.ecologics.worldgen.feature.foliageplacers;

import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacerType;
import samebutdifferent.ecologics.registry.ModBlocks;
import samebutdifferent.ecologics.registry.ModFoliagePlacerTypes;

public class CoconutFoliagePlacer
extends FoliagePlacer {
    public static final MapCodec<CoconutFoliagePlacer> CODEC = RecordCodecBuilder.mapCodec(placer -> CoconutFoliagePlacer.foliagePlacerParts((RecordCodecBuilder.Instance)placer).apply((Applicative)placer, CoconutFoliagePlacer::new));

    public CoconutFoliagePlacer(IntProvider pRadius, IntProvider pOffset) {
        super(pRadius, pOffset);
    }

    protected FoliagePlacerType<?> type() {
        return ModFoliagePlacerTypes.COCONUT_FOLIAGE_PLACER;
    }

    protected void createFoliage(LevelSimulatedReader pLevel, FoliagePlacer.FoliageSetter pBlockSetter, RandomSource pRandom, TreeConfiguration pConfig, int pMaxFreeTreeHeight, FoliagePlacer.FoliageAttachment pAttachment, int pFoliageHeight, int pFoliageRadius, int pOffset) {
        BlockPos startingPos = pAttachment.pos();
        CoconutFoliagePlacer.tryPlaceLeaf((LevelSimulatedReader)pLevel, (FoliagePlacer.FoliageSetter)pBlockSetter, (RandomSource)pRandom, (TreeConfiguration)pConfig, (BlockPos)startingPos);
        CoconutFoliagePlacer.createQuadrant(Direction.NORTH, startingPos, pLevel, pBlockSetter, pRandom, pConfig);
        CoconutFoliagePlacer.createQuadrant(Direction.EAST, startingPos, pLevel, pBlockSetter, pRandom, pConfig);
        CoconutFoliagePlacer.createQuadrant(Direction.SOUTH, startingPos, pLevel, pBlockSetter, pRandom, pConfig);
        CoconutFoliagePlacer.createQuadrant(Direction.WEST, startingPos, pLevel, pBlockSetter, pRandom, pConfig);
    }

    public int foliageHeight(RandomSource pRandom, int pHeight, TreeConfiguration pConfig) {
        return 0;
    }

    protected boolean shouldSkipLocation(RandomSource pRandom, int pLocalX, int pLocalY, int pLocalZ, int pRange, boolean pLarge) {
        return false;
    }

    private static void createQuadrant(Direction direction, BlockPos startingPos, LevelSimulatedReader pLevel, FoliagePlacer.FoliageSetter pBlockSetter, RandomSource pRandom, TreeConfiguration pConfig) {
        int i;
        BlockPos.MutableBlockPos pos = startingPos.mutable();
        pos.move(direction);
        CoconutFoliagePlacer.tryPlaceLeaf((LevelSimulatedReader)pLevel, (FoliagePlacer.FoliageSetter)pBlockSetter, (RandomSource)pRandom, (TreeConfiguration)pConfig, (BlockPos)pos);
        if (pRandom.nextInt(2) == 0 && pLevel.isStateAtPosition(pos.below(), BlockBehaviour.BlockStateBase::isAir)) {
            pBlockSetter.set(pos.below(), ModBlocks.HANGING_COCONUT.defaultBlockState());
        }
        if (pRandom.nextInt(2) == 0 && pLevel.isStateAtPosition(pos.below().relative(direction.getCounterClockWise()), BlockBehaviour.BlockStateBase::isAir)) {
            pBlockSetter.set(pos.below().relative(direction.getCounterClockWise()), ModBlocks.HANGING_COCONUT.defaultBlockState());
        }
        for (i = 0; i < 2; ++i) {
            pos.move(direction);
            CoconutFoliagePlacer.tryPlaceLeaf((LevelSimulatedReader)pLevel, (FoliagePlacer.FoliageSetter)pBlockSetter, (RandomSource)pRandom, (TreeConfiguration)pConfig, (BlockPos)pos);
            pos.move(Direction.DOWN);
            CoconutFoliagePlacer.tryPlaceLeaf((LevelSimulatedReader)pLevel, (FoliagePlacer.FoliageSetter)pBlockSetter, (RandomSource)pRandom, (TreeConfiguration)pConfig, (BlockPos)pos);
        }
        pos.set((Vec3i)startingPos);
        pos.move(direction).move(direction.getCounterClockWise());
        CoconutFoliagePlacer.tryPlaceLeaf((LevelSimulatedReader)pLevel, (FoliagePlacer.FoliageSetter)pBlockSetter, (RandomSource)pRandom, (TreeConfiguration)pConfig, (BlockPos)pos);
        pos.move(Direction.DOWN).move(direction.getCounterClockWise());
        CoconutFoliagePlacer.tryPlaceLeaf((LevelSimulatedReader)pLevel, (FoliagePlacer.FoliageSetter)pBlockSetter, (RandomSource)pRandom, (TreeConfiguration)pConfig, (BlockPos)pos);
        pos.move(direction);
        CoconutFoliagePlacer.tryPlaceLeaf((LevelSimulatedReader)pLevel, (FoliagePlacer.FoliageSetter)pBlockSetter, (RandomSource)pRandom, (TreeConfiguration)pConfig, (BlockPos)pos.relative(direction.getClockWise()));
        for (i = 0; i < 3; ++i) {
            CoconutFoliagePlacer.tryPlaceLeaf((LevelSimulatedReader)pLevel, (FoliagePlacer.FoliageSetter)pBlockSetter, (RandomSource)pRandom, (TreeConfiguration)pConfig, (BlockPos)pos);
            pos.move(Direction.DOWN);
        }
    }
}

