/*
 * Decompiled with CFR 0.152.
 */
package samebutdifferent.ecologics.worldgen.feature;

import com.google.common.collect.ImmutableList;
import com.mojang.serialization.Codec;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.levelgen.structure.templatesystem.BlockIgnoreProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import samebutdifferent.ecologics.Ecologics;

public class DesertRuinFeature
extends Feature<NoneFeatureConfiguration> {
    private final BlockIgnoreProcessor IGNORE_STRUCTURE_VOID = new BlockIgnoreProcessor((List)ImmutableList.of((Object)Blocks.STRUCTURE_VOID));
    private final StructurePlaceSettings placementsettings = new StructurePlaceSettings().setMirror(Mirror.NONE).addProcessor((StructureProcessor)this.IGNORE_STRUCTURE_VOID).setIgnoreEntities(false);
    private final ResourceLocation[] pieces = new ResourceLocation[]{ResourceLocation.fromNamespaceAndPath((String)"ecologics", (String)"desert_ruin/chest_house"), ResourceLocation.fromNamespaceAndPath((String)"ecologics", (String)"desert_ruin/pillars1"), ResourceLocation.fromNamespaceAndPath((String)"ecologics", (String)"desert_ruin/pillars2"), ResourceLocation.fromNamespaceAndPath((String)"ecologics", (String)"desert_ruin/wall1"), ResourceLocation.fromNamespaceAndPath((String)"ecologics", (String)"desert_ruin/wall2"), ResourceLocation.fromNamespaceAndPath((String)"ecologics", (String)"desert_ruin/pit")};

    public DesertRuinFeature(Codec<NoneFeatureConfiguration> pCodec) {
        super(pCodec);
    }

    public boolean place(FeaturePlaceContext<NoneFeatureConfiguration> pContext) {
        WorldGenLevel level = pContext.level();
        BlockPos origin = pContext.origin();
        RandomSource random = pContext.random();
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos().set((Vec3i)origin);
        mutable.move(Direction.UP);
        while (level.isEmptyBlock((BlockPos)mutable) && mutable.getY() > 2) {
            mutable.move(Direction.DOWN);
        }
        if (level.getBlockState((BlockPos)mutable).isAir() || level.isEmptyBlock(mutable.below()) || level.isEmptyBlock(mutable.below(2))) {
            return false;
        }
        mutable.move(Direction.DOWN);
        BlockPos.MutableBlockPos blockpos$Mutable = new BlockPos.MutableBlockPos();
        StructureTemplateManager templatemanager = level.getLevel().getServer().getStructureManager();
        ResourceLocation nbtRL = this.pieces[random.nextInt(this.pieces.length)];
        Optional template = templatemanager.get(nbtRL);
        if (template.isEmpty()) {
            Ecologics.LOGGER.warn(String.valueOf(nbtRL) + " NTB does not exist!");
            return false;
        }
        for (int x = 0; x < ((StructureTemplate)template.get()).getSize().getX(); ++x) {
            for (int z = 0; z < ((StructureTemplate)template.get()).getSize().getZ(); ++z) {
                blockpos$Mutable.set((Vec3i)origin.below()).move(x, 0, z);
                if (level.getBlockState((BlockPos)blockpos$Mutable).is(BlockTags.SAND)) continue;
                return false;
            }
        }
        int radius = ((StructureTemplate)template.get()).getSize().getX() / 2;
        for (int x = -radius; x <= radius; ++x) {
            for (int z = -radius; z <= radius; ++z) {
                if (x * x + z * z >= radius * radius + 1) continue;
                blockpos$Mutable.set((Vec3i)origin).move(x, 0, z);
                if (!level.getFluidState((BlockPos)blockpos$Mutable).isEmpty()) {
                    return false;
                }
                if (level.getBlockState((BlockPos)blockpos$Mutable.move(Direction.UP)).canOcclude() || !level.getBlockState((BlockPos)blockpos$Mutable.move(Direction.DOWN, 3)).canOcclude()) {
                    return false;
                }
                if (level.getBlockState((BlockPos)blockpos$Mutable).is(BlockTags.SAND)) continue;
                return false;
            }
        }
        BlockPos halfLengths = new BlockPos(((StructureTemplate)template.get()).getSize().getX() / 2, 0, ((StructureTemplate)template.get()).getSize().getZ() / 2);
        this.placementsettings.setRotation(Rotation.getRandom((RandomSource)random)).setRotationPivot(halfLengths).setIgnoreEntities(false);
        blockpos$Mutable.set((Vec3i)origin);
        BlockPos offset = new BlockPos(-((StructureTemplate)template.get()).getSize().getX() / 2, nbtRL.getPath().contains("pit") ? -2 : 0, -((StructureTemplate)template.get()).getSize().getZ() / 2);
        ((StructureTemplate)template.get()).placeInWorld((ServerLevelAccessor)level, blockpos$Mutable.offset((Vec3i)offset), blockpos$Mutable.offset((Vec3i)offset), this.placementsettings, random, 2);
        return true;
    }
}

