/*
 * Decompiled with CFR 0.152.
 */
package samebutdifferent.ecologics.entity;

import java.util.EnumSet;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MoveToBlockGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Fox;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;
import samebutdifferent.ecologics.entity.ai.navigation.BetterWallClimberNavigation;
import samebutdifferent.ecologics.platform.ConfigPlatformHelper;
import samebutdifferent.ecologics.registry.ModEntityTypes;
import samebutdifferent.ecologics.registry.ModSoundEvents;
import samebutdifferent.ecologics.registry.ModTags;

public class Squirrel
extends Animal {
    private static final EntityDataAccessor<Byte> DATA_FLAGS_ID = SynchedEntityData.defineId(Squirrel.class, (EntityDataSerializer)EntityDataSerializers.BYTE);
    private static final EntityDataAccessor<Boolean> DATA_TRUSTING = SynchedEntityData.defineId(Squirrel.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final Ingredient TEMPT_INGREDIENT = Ingredient.of(ModTags.ItemTags.SQUIRREL_TEMPT_ITEMS);

    public Squirrel(EntityType<? extends Animal> type, Level level) {
        super(type, level);
        this.setCanPickUpLoot(true);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 10.0).add(Attributes.MOVEMENT_SPEED, (double)0.4f);
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new PanicGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(2, (Goal)new BreedGoal((Animal)this, 1.0));
        this.goalSelector.addGoal(3, (Goal)new TemptGoal((PathfinderMob)this, 1.0, (Predicate)TEMPT_INGREDIENT, false));
        this.goalSelector.addGoal(4, (Goal)new FollowParentGoal((Animal)this, 1.0));
        this.goalSelector.addGoal(5, (Goal)new SquirrelSearchForSaplingsGoal(this));
        this.goalSelector.addGoal(6, (Goal)new SquirrelPlantSaplingGoal(this, 1.0, 8, 4));
        this.goalSelector.addGoal(7, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.goalSelector.addGoal(9, (Goal)new RandomLookAroundGoal((Mob)this));
        if (ConfigPlatformHelper.foxesAttackSquirrels()) {
            this.goalSelector.addGoal(1, (Goal)new AvoidEntityGoal((PathfinderMob)this, Fox.class, 6.0f, 1.1, 1.3));
        }
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_FLAGS_ID, (Object)0);
        builder.define(DATA_TRUSTING, (Object)false);
    }

    public void addAdditionalSaveData(CompoundTag pCompound) {
        super.addAdditionalSaveData(pCompound);
        pCompound.putBoolean("Trusting", this.isTrusting());
    }

    public void readAdditionalSaveData(CompoundTag pCompound) {
        super.readAdditionalSaveData(pCompound);
        this.setTrusting(pCompound.getBoolean("Trusting"));
    }

    @Nullable
    public AgeableMob getBreedOffspring(ServerLevel pLevel, AgeableMob pMob) {
        return (AgeableMob)ModEntityTypes.SQUIRREL.create((Level)pLevel);
    }

    public boolean isFood(ItemStack pStack) {
        return pStack.is(Items.HONEYCOMB);
    }

    boolean isTrusting() {
        return (Boolean)this.entityData.get(DATA_TRUSTING);
    }

    private void setTrusting(boolean pTrusting) {
        this.entityData.set(DATA_TRUSTING, (Object)pTrusting);
    }

    public InteractionResult mobInteract(Player pPlayer, InteractionHand pHand) {
        ItemStack itemstack = pPlayer.getItemInHand(pHand);
        if (!this.isTrusting() && TEMPT_INGREDIENT.test(itemstack)) {
            this.usePlayerItem(pPlayer, pHand, itemstack);
            if (!this.level().isClientSide()) {
                if (this.random.nextInt(3) == 0) {
                    this.setTrusting(true);
                    this.spawnTrustingParticles(true);
                    this.level().broadcastEntityEvent((Entity)this, (byte)41);
                } else {
                    this.spawnTrustingParticles(false);
                    this.level().broadcastEntityEvent((Entity)this, (byte)40);
                }
            }
            return InteractionResult.sidedSuccess((boolean)this.level().isClientSide());
        }
        return super.mobInteract(pPlayer, pHand);
    }

    public void handleEntityEvent(byte pId) {
        if (pId == 41) {
            this.spawnTrustingParticles(true);
        } else if (pId == 40) {
            this.spawnTrustingParticles(false);
        } else {
            super.handleEntityEvent(pId);
        }
    }

    private void spawnTrustingParticles(boolean isTrusting) {
        SimpleParticleType particleoptions = ParticleTypes.HEART;
        if (!isTrusting) {
            particleoptions = ParticleTypes.SMOKE;
        }
        for (int i = 0; i < 7; ++i) {
            double x = this.random.nextGaussian() * 0.02;
            double y = this.random.nextGaussian() * 0.02;
            double z = this.random.nextGaussian() * 0.02;
            this.level().addParticle((ParticleOptions)particleoptions, this.getRandomX(1.0), this.getRandomY() + 0.5, this.getRandomZ(1.0), x, y, z);
        }
    }

    public boolean canTakeItem(ItemStack pItemstack) {
        EquipmentSlot equipmentslot = this.getEquipmentSlotForItem(pItemstack);
        if (!this.getItemBySlot(equipmentslot).isEmpty() || this.isBaby() || !this.isTrusting()) {
            return false;
        }
        return equipmentslot == EquipmentSlot.MAINHAND && super.canTakeItem(pItemstack);
    }

    public boolean canHoldItem(ItemStack pStack) {
        ItemStack itemstack = this.getItemBySlot(EquipmentSlot.MAINHAND);
        return itemstack.isEmpty() && pStack.is(ItemTags.SAPLINGS) && !this.isBaby() && this.isTrusting();
    }

    protected void pickUpItem(ItemEntity pItemEntity) {
        ItemStack itemstack = pItemEntity.getItem();
        if (this.canHoldItem(itemstack)) {
            int count = itemstack.getCount();
            if (count > 1) {
                this.dropItemStack(itemstack.split(count - 1));
            }
            this.onItemPickup(pItemEntity);
            this.setItemSlot(EquipmentSlot.MAINHAND, itemstack.split(1));
            this.handDropChances[EquipmentSlot.MAINHAND.getIndex()] = 2.0f;
            this.take((Entity)pItemEntity, itemstack.getCount());
            pItemEntity.discard();
        }
    }

    private void dropItemStack(ItemStack pStack) {
        ItemEntity itementity = new ItemEntity(this.level(), this.getX(), this.getY(), this.getZ(), pStack);
        this.level().addFreshEntity((Entity)itementity);
    }

    protected PathNavigation createNavigation(Level pLevel) {
        return new BetterWallClimberNavigation((Mob)this, pLevel);
    }

    public void tick() {
        super.tick();
        if (!this.level().isClientSide()) {
            this.setClimbing(this.horizontalCollision);
        }
    }

    public boolean onClimbable() {
        return this.isClimbing();
    }

    public boolean isClimbing() {
        return ((Byte)this.entityData.get(DATA_FLAGS_ID) & 1) != 0;
    }

    public void setClimbing(boolean pClimbing) {
        byte flag = (Byte)this.entityData.get(DATA_FLAGS_ID);
        flag = pClimbing ? (byte)(flag | 1) : (byte)(flag & 0xFFFFFFFE);
        this.entityData.set(DATA_FLAGS_ID, (Object)flag);
    }

    public boolean causeFallDamage(float pFallDistance, float pMultiplier, DamageSource pSource) {
        return false;
    }

    public boolean canBeLeashed() {
        return this.isTrusting();
    }

    protected SoundEvent getAmbientSound() {
        return ModSoundEvents.SQUIRREL_AMBIENT;
    }

    protected SoundEvent getHurtSound(DamageSource pDamageSource) {
        return ModSoundEvents.SQUIRREL_HURT;
    }

    protected SoundEvent getDeathSound() {
        return ModSoundEvents.SQUIRREL_DEATH;
    }

    static class SquirrelSearchForSaplingsGoal
    extends Goal {
        private final Squirrel squirrel;

        public SquirrelSearchForSaplingsGoal(Squirrel squirrel) {
            this.setFlags(EnumSet.of(Goal.Flag.MOVE));
            this.squirrel = squirrel;
        }

        public boolean canUse() {
            if (!this.squirrel.getItemBySlot(EquipmentSlot.MAINHAND).isEmpty() || this.squirrel.isBaby() || !this.squirrel.isTrusting()) {
                return false;
            }
            List list = this.squirrel.level().getEntitiesOfClass(ItemEntity.class, this.squirrel.getBoundingBox().inflate(8.0, 8.0, 8.0), itemEntity -> itemEntity.getItem().is(ItemTags.SAPLINGS));
            return !list.isEmpty() && this.squirrel.getItemBySlot(EquipmentSlot.MAINHAND).isEmpty();
        }

        public void tick() {
            List list = this.squirrel.level().getEntitiesOfClass(ItemEntity.class, this.squirrel.getBoundingBox().inflate(8.0, 8.0, 8.0), itemEntity -> itemEntity.getItem().is(ItemTags.SAPLINGS));
            ItemStack itemstack = this.squirrel.getItemBySlot(EquipmentSlot.MAINHAND);
            if (itemstack.isEmpty() && !list.isEmpty()) {
                this.squirrel.getNavigation().moveTo((Entity)list.get(0), 1.0);
            }
        }

        public void start() {
            List list = this.squirrel.level().getEntitiesOfClass(ItemEntity.class, this.squirrel.getBoundingBox().inflate(8.0, 8.0, 8.0), itemEntity -> itemEntity.getItem().is(ItemTags.SAPLINGS));
            if (!list.isEmpty()) {
                this.squirrel.getNavigation().moveTo((Entity)list.get(0), 1.0);
            }
        }
    }

    static class SquirrelPlantSaplingGoal
    extends MoveToBlockGoal {
        private final Squirrel squirrel;
        private boolean reachedTarget;

        public SquirrelPlantSaplingGoal(Squirrel squirrel, double pSpeedModifier, int pSearchRange, int pVerticalSearchRange) {
            super((PathfinderMob)squirrel, pSpeedModifier, pSearchRange, pVerticalSearchRange);
            this.squirrel = squirrel;
        }

        public boolean canUse() {
            if (this.squirrel.getItemBySlot(EquipmentSlot.MAINHAND).isEmpty() || this.squirrel.isBaby() || !this.squirrel.isTrusting()) {
                return false;
            }
            return super.canUse();
        }

        public void tick() {
            Level level;
            BlockPos blockpos = this.getMoveToTarget();
            if (!blockpos.closerToCenterThan((Position)this.mob.position(), this.acceptedDistance())) {
                this.reachedTarget = false;
                ++this.tryTicks;
                if (this.shouldRecalculatePath()) {
                    this.mob.getNavigation().moveTo((double)blockpos.getX() + 0.5, (double)blockpos.getY(), (double)blockpos.getZ() + 0.5, this.speedModifier);
                }
            } else {
                this.reachedTarget = true;
                --this.tryTicks;
            }
            if (this.reachedTarget && !this.squirrel.getMainHandItem().isEmpty() && (level = this.squirrel.level()).getBlockState(this.blockPos).is(BlockTags.DIRT)) {
                this.onReachedTarget(level);
                this.reachedTarget = false;
            }
        }

        public double acceptedDistance() {
            return 1.5;
        }

        protected boolean isValidTarget(LevelReader pLevel, BlockPos pPos) {
            BlockState blockstate = pLevel.getBlockState(pPos);
            return blockstate.is(BlockTags.DIRT) && pLevel.getBlockState(pPos.above()).isAir();
        }

        protected void onReachedTarget(Level level) {
            Item item = this.squirrel.getMainHandItem().getItem();
            if (item instanceof BlockItem) {
                BlockItem item2 = (BlockItem)item;
                level.setBlockAndUpdate(this.blockPos.above(), item2.getBlock().defaultBlockState());
                level.playSound(null, this.blockPos, SoundEvents.GRASS_PLACE, SoundSource.BLOCKS, 1.0f, level.getRandom().nextFloat() * 0.4f + 0.8f);
                this.squirrel.setItemSlot(EquipmentSlot.MAINHAND, ItemStack.EMPTY);
            }
        }

        protected boolean isReachedTarget() {
            return this.reachedTarget;
        }
    }
}

