/*
 * Decompiled with CFR 0.152.
 */
package samebutdifferent.ecologics.client.model;

import com.google.common.collect.ImmutableList;
import net.minecraft.client.model.AgeableListModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import samebutdifferent.ecologics.entity.Squirrel;

@OnlyIn(value=Dist.CLIENT)
public class SquirrelModel
extends AgeableListModel<Squirrel> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"ecologics", (String)"squirrel"), "main");
    private final ModelPart head;
    private final ModelPart body;
    private final ModelPart leftArm;
    private final ModelPart rightArm;
    private final ModelPart leftLeg;
    private final ModelPart leftThigh;
    private final ModelPart leftFoot;
    private final ModelPart rightLeg;
    private final ModelPart rightThigh;
    private final ModelPart rightFoot;
    private final ModelPart tail;

    public SquirrelModel(ModelPart root) {
        super(true, 9.0f, 2.0f);
        this.head = root.getChild("head");
        this.body = root.getChild("body");
        this.leftArm = this.body.getChild("leftArm");
        this.rightArm = this.body.getChild("rightArm");
        this.leftLeg = this.body.getChild("leftLeg");
        this.leftThigh = this.leftLeg.getChild("leftThigh");
        this.leftFoot = this.leftThigh.getChild("leftFoot");
        this.rightLeg = this.body.getChild("rightLeg");
        this.rightThigh = this.rightLeg.getChild("rightThigh");
        this.rightFoot = this.rightThigh.getChild("rightFoot");
        this.tail = this.body.getChild("tail");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition head = partdefinition.addOrReplaceChild("head", CubeListBuilder.create().texOffs(16, 15).addBox(-2.0f, -3.0f, -4.1667f, 4.0f, 4.0f, 5.0f, new CubeDeformation(0.0f)).texOffs(11, 15).addBox(1.0f, -5.0f, -1.1667f, 2.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(11, 15).mirror().addBox(-3.0f, -5.0f, -1.1667f, 2.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)0.0f, (float)18.0f, (float)-3.8333f));
        PartDefinition body = partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 0).addBox(-3.0f, -2.5f, -5.0f, 6.0f, 5.0f, 10.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)18.5f, (float)2.0f));
        PartDefinition leftArm = body.addOrReplaceChild("leftArm", CubeListBuilder.create().texOffs(0, 0).addBox(-1.0f, -1.0f, -1.0f, 2.0f, 6.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)3.0f, (float)0.5f, (float)-3.5f));
        PartDefinition rightArm = body.addOrReplaceChild("rightArm", CubeListBuilder.create().texOffs(0, 0).mirror().addBox(-1.0f, -1.0f, -1.0f, 2.0f, 6.0f, 2.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)-3.0f, (float)0.5f, (float)-3.5f));
        PartDefinition leftLeg = body.addOrReplaceChild("leftLeg", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)5.5f, (float)-2.0f));
        PartDefinition leftThigh = leftLeg.addOrReplaceChild("leftThigh", CubeListBuilder.create().texOffs(0, 28).addBox(-1.0f, -1.0f, -1.0f, 2.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)3.0f, (float)-4.0f, (float)4.5f));
        PartDefinition leftFoot = leftThigh.addOrReplaceChild("leftFoot", CubeListBuilder.create().texOffs(22, 0).addBox(-1.0f, -0.5f, -7.0f, 2.0f, 1.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)3.5f, (float)3.0f));
        PartDefinition rightLeg = body.addOrReplaceChild("rightLeg", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)5.5f, (float)-2.0f));
        PartDefinition rightThigh = rightLeg.addOrReplaceChild("rightThigh", CubeListBuilder.create().texOffs(0, 28).mirror().addBox(-1.0f, -1.0f, -1.0f, 2.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)-3.0f, (float)-4.0f, (float)4.5f));
        PartDefinition rightFoot = rightThigh.addOrReplaceChild("rightFoot", CubeListBuilder.create().texOffs(22, 0).mirror().addBox(-1.0f, -0.5f, -5.5f, 2.0f, 1.0f, 7.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)0.0f, (float)3.5f, (float)1.5f));
        PartDefinition tail = body.addOrReplaceChild("tail", CubeListBuilder.create().texOffs(16, 24).addBox(-1.5f, -11.0f, 0.0f, 3.0f, 11.0f, 3.0f, new CubeDeformation(0.0f)).texOffs(0, 15).addBox(-1.5f, -11.0f, 3.0f, 3.0f, 8.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-2.5f, (float)4.0f, (float)-0.7854f, (float)0.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void setupAnim(Squirrel entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.body.getAllParts().forEach(ModelPart::resetPose);
        this.head.resetPose();
        float swingCorrectionFactor = 0.1f;
        float correctedLimbSwing = entity.isBaby() ? limbSwing / 3.0f : limbSwing;
        this.head.xRot = headPitch * ((float)Math.PI / 180);
        this.head.yRot = netHeadYaw * ((float)Math.PI / 180);
        this.head.xRot += Mth.cos((float)((float)Math.toRadians(-45.0) + correctedLimbSwing)) * (swingCorrectionFactor * 0.8f) * limbSwingAmount;
        this.head.y = this.head.y + (-1.0f - Mth.cos((float)correctedLimbSwing)) * (float)(entity.isBaby() ? 1 : 2) * limbSwingAmount;
        this.head.z += 1.0f * limbSwingAmount;
        this.body.xRot = (float)((double)this.body.xRot + (Math.toRadians(10.0) - (double)Mth.cos((float)((float)Math.toRadians(-30.0) + correctedLimbSwing))) * (double)(swingCorrectionFactor * 3.5f) * (double)limbSwingAmount);
        this.body.y += (-1.0f - Mth.cos((float)correctedLimbSwing)) * 2.0f * limbSwingAmount;
        this.leftArm.xRot = (float)((double)this.leftArm.xRot + (Math.toRadians(-15.0) - (double)Mth.cos((float)((float)Math.toRadians(-35.0) + correctedLimbSwing))) * (double)(swingCorrectionFactor * 7.5f) * (double)limbSwingAmount);
        this.leftArm.yRot = (float)((double)this.leftArm.yRot + Math.toRadians(-5.0));
        this.leftArm.zRot = (float)((double)this.leftArm.zRot + (Math.toRadians(-15.0) - (double)Mth.cos((float)correctedLimbSwing)) * (double)(swingCorrectionFactor * 2.0f) * (double)limbSwingAmount);
        this.leftArm.z += (0.5f + Mth.cos((float)correctedLimbSwing)) * (swingCorrectionFactor * 0.05f) * limbSwingAmount;
        this.rightArm.xRot = (float)((double)this.rightArm.xRot + (Math.toRadians(-15.0) - (double)Mth.cos((float)((float)Math.toRadians(-45.0) + correctedLimbSwing))) * (double)(swingCorrectionFactor * 7.5f) * (double)limbSwingAmount);
        this.rightArm.yRot = (float)((double)this.rightArm.yRot + Math.toRadians(-5.0));
        this.rightArm.zRot = (float)((double)this.rightArm.zRot + (Math.toRadians(15.0) - (double)Mth.cos((float)correctedLimbSwing)) * (double)(swingCorrectionFactor * 2.0f) * (double)limbSwingAmount);
        this.rightArm.z += (0.5f + Mth.cos((float)((float)Math.toRadians(-25.0) + correctedLimbSwing))) * (swingCorrectionFactor * 0.05f) * limbSwingAmount;
        this.leftThigh.xRot = (float)((double)this.leftThigh.xRot + (Math.toRadians(45.0) - (double)Mth.cos((float)((float)Math.toRadians(-45.0) + correctedLimbSwing))) * (double)(swingCorrectionFactor * 6.5f) * (double)limbSwingAmount);
        this.leftThigh.y += -3.0f * (swingCorrectionFactor * 7.0f) * limbSwingAmount;
        this.leftThigh.z += Mth.cos((float)((float)Math.toRadians(-35.0) + correctedLimbSwing)) * (swingCorrectionFactor * 0.1f) * limbSwingAmount;
        this.leftFoot.xRot = (float)((double)this.leftFoot.xRot + (Math.toRadians(25.0) + (double)Mth.cos((float)((float)Math.toRadians(-125.0) + correctedLimbSwing))) * (double)(swingCorrectionFactor * 6.0f) * (double)limbSwingAmount);
        this.leftFoot.y += -1.0f * (swingCorrectionFactor * 2.0f) * limbSwingAmount;
        this.leftFoot.z += (-0.5f + Mth.cos((float)correctedLimbSwing)) * (swingCorrectionFactor * 0.025f) * limbSwingAmount;
        this.rightLeg.y += -1.0f * swingCorrectionFactor * limbSwingAmount;
        this.rightThigh.xRot = (float)((double)this.rightThigh.xRot + (Math.toRadians(45.0) - (double)Mth.cos((float)((float)Math.toRadians(-25.0) + correctedLimbSwing))) * (double)(swingCorrectionFactor * 6.5f) * (double)limbSwingAmount);
        this.rightThigh.y += -2.0f * (swingCorrectionFactor * 7.0f) * limbSwingAmount;
        this.rightThigh.z += Mth.cos((float)((float)Math.toRadians(-35.0) + correctedLimbSwing)) * (swingCorrectionFactor * 0.1f) * limbSwingAmount;
        this.rightFoot.xRot = (float)((double)this.rightFoot.xRot + (Math.toRadians(15.0) + (double)Mth.cos((float)((float)Math.toRadians(-85.0) + correctedLimbSwing))) * (double)(swingCorrectionFactor * 6.0f) * (double)limbSwingAmount);
        this.rightFoot.y += -1.0f * (swingCorrectionFactor * 2.0f) * limbSwingAmount;
        this.rightFoot.z += (-0.5f + Mth.cos((float)correctedLimbSwing)) * (swingCorrectionFactor * 0.025f) * limbSwingAmount;
        this.tail.xRot = (float)((double)this.tail.xRot + (Math.toRadians(-40.0) - (double)Mth.cos((float)((float)Math.toRadians(-120.0) + correctedLimbSwing))) * (double)(swingCorrectionFactor * 1.8f) * (double)limbSwingAmount);
        this.tail.z += Mth.cos((float)((float)Math.toRadians(-100.0) + correctedLimbSwing)) * (swingCorrectionFactor * 0.03f) * limbSwingAmount;
    }

    protected Iterable<ModelPart> headParts() {
        return ImmutableList.of((Object)this.head);
    }

    protected Iterable<ModelPart> bodyParts() {
        return ImmutableList.of((Object)this.body);
    }
}

