/*
 * Decompiled with CFR 0.152.
 */
package samebutdifferent.ecologics.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.animal.horse.AbstractChestedHorse;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class CamelModel<T extends AbstractChestedHorse>
extends EntityModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"ecologics", (String)"camel"), "main");
    private final ModelPart saddle;
    private final ModelPart body;
    private final ModelPart head;
    private final ModelPart rightHindLeg;
    private final ModelPart leftHindLeg;
    private final ModelPart rightFrontLeg;
    private final ModelPart leftFrontLeg;
    private final ModelPart leftChest;
    private final ModelPart rightChest;

    public CamelModel(ModelPart root) {
        this.saddle = root.getChild("saddle");
        this.body = root.getChild("body");
        this.head = root.getChild("head");
        this.rightHindLeg = root.getChild("rightHindLeg");
        this.leftHindLeg = root.getChild("leftHindLeg");
        this.rightFrontLeg = root.getChild("rightFrontLeg");
        this.leftFrontLeg = root.getChild("leftFrontLeg");
        this.leftChest = root.getChild("leftChest");
        this.rightChest = root.getChild("rightChest");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition saddle = partdefinition.addOrReplaceChild("saddle", CubeListBuilder.create().texOffs(80, 105).addBox(-5.0f, -13.0f, -1.5f, 10.0f, 9.0f, 14.0f, new CubeDeformation(0.5f)), PartPose.offset((float)0.0f, (float)5.0f, (float)-4.0f));
        PartDefinition body = partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 37).addBox(-5.0f, -7.0f, -3.0f, 10.0f, 5.0f, 13.0f, new CubeDeformation(0.0f)).texOffs(0, 0).addBox(-5.0f, -2.0f, -10.0f, 10.0f, 11.0f, 26.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-1.0f, (float)-2.0f));
        PartDefinition head = partdefinition.addOrReplaceChild("head", CubeListBuilder.create().texOffs(46, 16).addBox(-2.0f, -14.975f, -15.0f, 4.0f, 5.0f, 5.0f, new CubeDeformation(0.0f)).texOffs(0, 0).addBox(-3.0f, -15.0f, -10.0f, 6.0f, 19.0f, 7.0f, new CubeDeformation(0.0f)).texOffs(14, 55).addBox(-3.0f, -4.0f, -3.0f, 6.0f, 8.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)2.0f, (float)-12.0f));
        PartDefinition leftEar = head.addOrReplaceChild("leftEar", CubeListBuilder.create().texOffs(33, 37).addBox(-1.5f, -2.0f, -1.0f, 2.0f, 2.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)2.5f, (float)-15.0f, (float)-6.0f));
        PartDefinition rightEar = head.addOrReplaceChild("rightEar", CubeListBuilder.create().texOffs(0, 37).addBox(-0.5f, -2.0f, -1.0f, 2.0f, 2.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-2.5f, (float)-15.0f, (float)-6.0f));
        PartDefinition rightHindLeg = partdefinition.addOrReplaceChild("rightHindLeg", CubeListBuilder.create().texOffs(0, 55).mirror().addBox(0.0f, 0.0f, -3.0f, 3.0f, 16.0f, 4.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)-4.5f, (float)8.0f, (float)12.0f));
        PartDefinition leftHindLeg = partdefinition.addOrReplaceChild("leftHindLeg", CubeListBuilder.create().texOffs(0, 55).addBox(-3.0f, 0.0f, -3.0f, 3.0f, 16.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)4.5f, (float)8.0f, (float)12.0f));
        PartDefinition rightFrontLeg = partdefinition.addOrReplaceChild("rightFrontLeg", CubeListBuilder.create().texOffs(0, 55).mirror().addBox(0.0f, 0.0f, -2.0f, 3.0f, 16.0f, 4.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)-4.5f, (float)8.0f, (float)-9.0f));
        PartDefinition leftFrontLeg = partdefinition.addOrReplaceChild("leftFrontLeg", CubeListBuilder.create().texOffs(0, 55).addBox(-3.0f, 0.0f, -2.0f, 3.0f, 16.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)4.5f, (float)8.0f, (float)-9.0f));
        PartDefinition leftChest = partdefinition.addOrReplaceChild("leftChest", CubeListBuilder.create().texOffs(46, 0).addBox(19.0f, 0.0f, 2.0f, 3.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-14.5f, (float)-1.0f, (float)-5.0f));
        PartDefinition rightChest = partdefinition.addOrReplaceChild("rightChest", CubeListBuilder.create().texOffs(46, 0).mirror().addBox(19.0f, 0.0f, 2.0f, 3.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)-26.5f, (float)-1.0f, (float)-5.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)128, (int)128);
    }

    public void setupAnim(T pEntity, float pLimbSwing, float pLimbSwingAmount, float pAgeInTicks, float pNetHeadYaw, float pHeadPitch) {
        boolean showSaddle;
        boolean showChest;
        this.head.xRot = pHeadPitch * ((float)Math.PI / 180);
        this.head.yRot = pNetHeadYaw * ((float)Math.PI / 180);
        this.rightHindLeg.xRot = Mth.cos((float)(pLimbSwing * 0.3331f)) * pLimbSwingAmount;
        this.leftHindLeg.xRot = Mth.cos((float)(pLimbSwing * 0.3331f + (float)Math.PI)) * pLimbSwingAmount;
        this.rightFrontLeg.xRot = Mth.cos((float)(pLimbSwing * 0.3331f + (float)Math.PI)) * pLimbSwingAmount;
        this.leftFrontLeg.xRot = Mth.cos((float)(pLimbSwing * 0.3331f)) * pLimbSwingAmount;
        this.rightChest.visible = showChest = !pEntity.isBaby() && pEntity.hasChest();
        this.leftChest.visible = showChest;
        this.saddle.visible = showSaddle = pEntity.isSaddled();
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer buffer, int packedLight, int packedOverlay, int color) {
        this.saddle.render(poseStack, buffer, packedLight, packedOverlay);
        this.body.render(poseStack, buffer, packedLight, packedOverlay);
        this.head.render(poseStack, buffer, packedLight, packedOverlay);
        this.rightHindLeg.render(poseStack, buffer, packedLight, packedOverlay);
        this.leftHindLeg.render(poseStack, buffer, packedLight, packedOverlay);
        this.rightFrontLeg.render(poseStack, buffer, packedLight, packedOverlay);
        this.leftFrontLeg.render(poseStack, buffer, packedLight, packedOverlay);
        this.leftChest.render(poseStack, buffer, packedLight, packedOverlay);
        this.rightChest.render(poseStack, buffer, packedLight, packedOverlay);
    }
}

