/*
 * Decompiled with CFR 0.152.
 */
package samebutdifferent.ecologics.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SnowLayerBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.BlockHitResult;

public class MossLayerBlock
extends SnowLayerBlock {
    public MossLayerBlock() {
        super(BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_GREEN).strength(0.1f).sound(SoundType.MOSS_CARPET));
        this.registerDefaultState((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)LAYERS, (Comparable)Integer.valueOf(2)));
    }

    public ItemInteractionResult useItemOn(ItemStack item, BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHit) {
        if ((Integer)pState.getValue((Property)LAYERS) < 8 && ItemStack.isSameItem((ItemStack)Blocks.MOSS_CARPET.asItem().getDefaultInstance(), (ItemStack)item) && pPlayer.getInBlockState() != pState) {
            if (pState.is((Block)this) && !pLevel.isClientSide()) {
                if ((Integer)pState.getValue((Property)LAYERS) < 7) {
                    pLevel.setBlockAndUpdate(pPos, (BlockState)this.defaultBlockState().setValue((Property)LAYERS, (Comparable)Integer.valueOf((Integer)pState.getValue((Property)LAYERS) + 1)));
                } else {
                    pLevel.setBlockAndUpdate(pPos, Blocks.MOSS_BLOCK.defaultBlockState());
                }
                if (!pPlayer.isCreative()) {
                    item.shrink(1);
                }
            }
            pLevel.playSound(pPlayer, pPos, SoundEvents.MOSS_CARPET_PLACE, SoundSource.BLOCKS, 1.0f, 1.0f);
            return ItemInteractionResult.sidedSuccess((boolean)pLevel.isClientSide());
        }
        return ItemInteractionResult.CONSUME;
    }

    public boolean useShapeForLightOcclusion(BlockState p_56630_) {
        return false;
    }

    public boolean canSurvive(BlockState state, LevelReader reader, BlockPos pos) {
        return !reader.isEmptyBlock(pos.below());
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos facingPos) {
        return !state.canSurvive((LevelReader)world, pos) ? Blocks.AIR.defaultBlockState() : super.updateShape(state, direction, neighborState, world, pos, facingPos);
    }

    public void randomTick(BlockState p_56615_, ServerLevel p_56616_, BlockPos p_56617_, RandomSource p_56618_) {
    }

    public boolean canBeReplaced(BlockState state, BlockPlaceContext useContext) {
        int layers = (Integer)state.getValue((Property)LAYERS);
        if (useContext.getItemInHand().is(this.asItem()) && layers < 8) {
            return useContext.getClickedFace() == Direction.UP;
        }
        return layers == 1;
    }
}

