/*
 * Decompiled with CFR 0.152.
 */
package com.jesz.createdieselgenerators.events;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.jesz.createdieselgenerators.CDGBlockEntityTypes;
import com.jesz.createdieselgenerators.CDGBlocks;
import com.jesz.createdieselgenerators.CDGItems;
import com.jesz.createdieselgenerators.CDGRegistries;
import com.jesz.createdieselgenerators.CreateDieselGenerators;
import com.jesz.createdieselgenerators.compat.kubejs.LighterSkinsEventJS;
import com.jesz.createdieselgenerators.content.bulk_fermenter.BulkFermenterBlockEntity;
import com.jesz.createdieselgenerators.content.burner.BurnerBlockEntity;
import com.jesz.createdieselgenerators.content.canister.CanisterBlockEntity;
import com.jesz.createdieselgenerators.content.canister.SpoutCanisterFilling;
import com.jesz.createdieselgenerators.content.diesel_engine.huge.HugeDieselEngineBlockEntity;
import com.jesz.createdieselgenerators.content.diesel_engine.modular.ModularDieselEngineBlockEntity;
import com.jesz.createdieselgenerators.content.diesel_engine.normal.DieselEngineBlockEntity;
import com.jesz.createdieselgenerators.content.distillation.DistillationTankBlockEntity;
import com.jesz.createdieselgenerators.content.molds.BasinSpoutCasting;
import com.jesz.createdieselgenerators.content.molds.MoldItem;
import com.jesz.createdieselgenerators.content.molds.MoldType;
import com.jesz.createdieselgenerators.content.oil_barrel.OilBarrelBlockEntity;
import com.jesz.createdieselgenerators.content.pumpjack.PumpjackHoleBlockEntity;
import com.jesz.createdieselgenerators.content.tools.ChemicalSprayerItem;
import com.jesz.createdieselgenerators.content.tools.FueledToolItem;
import com.jesz.createdieselgenerators.content.tools.hammer.HammerItem;
import com.jesz.createdieselgenerators.content.tools.lighter.LighterItem;
import com.jesz.createdieselgenerators.content.tools.lighter.LighterModel;
import com.jesz.createdieselgenerators.content.tools.wire_cutters.WireCuttersItem;
import com.jesz.createdieselgenerators.content.track_layers_bag.TrackLayersBagComponent;
import com.jesz.createdieselgenerators.content.turret.ChemicalTurretBlockEntity;
import com.jesz.createdieselgenerators.content.turret.TurretOperatorHatLayer;
import com.jesz.createdieselgenerators.fuel_type.FuelType;
import com.jesz.createdieselgenerators.ponder.CDGPonderPlugin;
import com.simibubi.create.AllBlockEntityTypes;
import com.simibubi.create.api.behaviour.spouting.BlockSpoutingBehaviour;
import com.simibubi.create.foundation.utility.FilesHelper;
import com.tterrag.registrate.providers.ProviderType;
import com.tterrag.registrate.providers.RegistrateLangProvider;
import java.io.IOException;
import java.io.Reader;
import java.util.Map;
import java.util.Optional;
import net.createmod.ponder.api.registration.PonderPlugin;
import net.createmod.ponder.foundation.PonderIndex;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModList;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.neoforged.neoforge.client.event.ModelEvent;
import net.neoforged.neoforge.client.event.RegisterClientTooltipComponentFactoriesEvent;
import net.neoforged.neoforge.client.extensions.common.RegisterClientExtensionsEvent;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import net.neoforged.neoforge.registries.DataPackRegistryEvent;

@EventBusSubscriber(modid="createdieselgenerators", bus=EventBusSubscriber.Bus.MOD)
public class ModEvents {
    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void gatherData(GatherDataEvent event) {
        CreateDieselGenerators.REGISTRATE.addDataGenerator(ProviderType.LANG, provider -> {
            JsonElement jsonElement = FilesHelper.loadJsonResource((String)"assets/createdieselgenerators/lang/default/default.json");
            JsonObject jsonObject = jsonElement.getAsJsonObject();
            for (Map.Entry entry : jsonObject.entrySet()) {
                provider.add((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
            }
            PonderIndex.addPlugin((PonderPlugin)new CDGPonderPlugin());
            PonderIndex.getLangAccess().provideLang("createdieselgenerators", (arg_0, arg_1) -> ((RegistrateLangProvider)provider).add(arg_0, arg_1));
        });
    }

    @SubscribeEvent
    public static void registerDataPackRegistries(DataPackRegistryEvent.NewRegistry event) {
        event.dataPackRegistry(CDGRegistries.FUEL_TYPE, FuelType.CODEC, FuelType.NCODEC);
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public static void onModelRegistry(ModelEvent.RegisterAdditional event) {
        for (MoldType type : MoldType.types) {
            event.register(new ModelResourceLocation(type.getModelId(), "standalone"));
        }
        LighterModel.lighterSkinIDs.clear();
        Minecraft.getInstance().getResourceManager().getNamespaces().stream().toList().forEach(n -> {
            Optional resource = Minecraft.getInstance().getResourceManager().getResource(ResourceLocation.fromNamespaceAndPath((String)n, (String)"lighter_skins.json"));
            if (resource.isEmpty()) {
                return;
            }
            JsonParser parser = new JsonParser();
            try {
                JsonElement data = parser.parse((Reader)((Resource)resource.get()).openAsReader());
                data.getAsJsonArray().forEach(jsonElement -> LighterModel.lighterSkinIDs.put(jsonElement.getAsJsonObject().getAsJsonPrimitive("name").getAsString(), jsonElement.getAsJsonObject().getAsJsonPrimitive("id").getAsString()));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        });
        if (ModList.get().isLoaded("kubejs")) {
            LighterModel.lighterSkinIDs.putAll(LighterSkinsEventJS.addedIds);
            LighterSkinsEventJS.removedIds.forEach((name, id) -> LighterModel.lighterSkinIDs.remove(name, id));
        }
        LighterModel.initSkins();
        LighterModel.onModelRegistry(event);
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public static void registerClientTooltips(RegisterClientTooltipComponentFactoriesEvent event) {
        event.register(TrackLayersBagComponent.class, c -> c);
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public static void addEntityRendererLayers(EntityRenderersEvent.AddLayers event) {
        EntityRenderDispatcher dispatcher = Minecraft.getInstance().getEntityRenderDispatcher();
        TurretOperatorHatLayer.registerOnAll(dispatcher);
    }

    @SubscribeEvent
    public static void registerCapabilities(RegisterCapabilitiesEvent event) {
        event.registerItem(Capabilities.FluidHandler.ITEM, (item, c) -> ((FueledToolItem)item.getItem()).getFluidHandler((ItemStack)item), new ItemLike[]{CDGItems.LIGHTER, CDGItems.CHEMICAL_SPRAYER, CDGItems.CHEMICAL_SPRAYER_LIGHTER, CDGBlocks.CANISTER});
        BulkFermenterBlockEntity.registerCapabilities(event);
        BurnerBlockEntity.registerCapabilities(event);
        CanisterBlockEntity.registerCapabilities(event);
        DieselEngineBlockEntity.registerCapabilities(event);
        ModularDieselEngineBlockEntity.registerCapabilities(event);
        HugeDieselEngineBlockEntity.registerCapabilities(event);
        DistillationTankBlockEntity.registerCapabilities(event);
        OilBarrelBlockEntity.registerCapabilities(event);
        PumpjackHoleBlockEntity.registerCapabilities(event);
        ChemicalTurretBlockEntity.registerCapabilities(event);
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public static void registerClientExtensions(RegisterClientExtensionsEvent event) {
        ((LighterItem)CDGItems.LIGHTER.get()).registerExtension(event);
        ((ChemicalSprayerItem)CDGItems.CHEMICAL_SPRAYER.get()).registerExtension(event);
        ((ChemicalSprayerItem)CDGItems.CHEMICAL_SPRAYER_LIGHTER.get()).registerExtension(event);
        ((HammerItem)((Object)CDGItems.HAMMER.get())).registerExtension(event);
        ((WireCuttersItem)((Object)CDGItems.WIRE_CUTTERS.get())).registerExtension(event);
        ((MoldItem)((Object)CDGItems.MOLD.get())).registerExtension(event);
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public static void onModelBake(ModelEvent.BakingCompleted event) {
        Map models = event.getModels();
        for (MoldType type : MoldType.types) {
            type.model = (BakedModel)models.get(new ModelResourceLocation(type.getModelId(), "standalone"));
        }
    }

    @SubscribeEvent
    public static void setup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            BlockSpoutingBehaviour.BY_BLOCK_ENTITY.register((Object)((BlockEntityType)CDGBlockEntityTypes.CANISTER.get()), (Object)new SpoutCanisterFilling());
            BlockSpoutingBehaviour.BY_BLOCK_ENTITY.register((Object)((BlockEntityType)AllBlockEntityTypes.BASIN.get()), (Object)new BasinSpoutCasting());
        });
    }
}

