/*
 * Decompiled with CFR 0.152.
 */
package com.jesz.createdieselgenerators.content.canister;

import com.jesz.createdieselgenerators.CDGBlockEntityTypes;
import com.jesz.createdieselgenerators.CDGConfig;
import com.jesz.createdieselgenerators.CDGDataComponents;
import com.mojang.serialization.Codec;
import com.simibubi.create.api.equipment.goggles.IHaveGoggleInformation;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BehaviourType;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.fluid.SmartFluidTankBehaviour;
import java.util.List;
import java.util.Optional;
import net.createmod.catnip.codecs.CatnipCodecUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.fluids.SimpleFluidContent;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;

public class CanisterBlockEntity
extends SmartBlockEntity
implements IHaveGoggleInformation {
    CapacityEnchantedFluidTankBehaviour tank;
    BlockState state;
    public int capacityEnchantLevel;
    private DataComponentPatch componentPatch = DataComponentPatch.EMPTY;

    public CanisterBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.state = state;
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        return this.containedFluidTooltip(tooltip, isPlayerSneaking, (IFluidHandler)this.level.getCapability(Capabilities.FluidHandler.BLOCK, this.worldPosition, null));
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        this.tank = CapacityEnchantedFluidTankBehaviour.single(this, Math.abs((Integer)CDGConfig.CANISTER_CAPACITY.get()), (Integer)CDGConfig.CANISTER_CAPACITY_ENCHANTMENT.get());
        behaviours.add((BlockEntityBehaviour)this.tank);
    }

    public static void registerCapabilities(RegisterCapabilitiesEvent event) {
        event.registerBlockEntity(Capabilities.FluidHandler.BLOCK, (BlockEntityType)CDGBlockEntityTypes.CANISTER.get(), (be, context) -> be.tank.getCapability());
    }

    protected void write(CompoundTag compound, HolderLookup.Provider registries, boolean clientPacket) {
        super.write(compound, registries, clientPacket);
        compound.putInt("CapacityEnchantment", this.capacityEnchantLevel);
        compound.put("Components", (Tag)CatnipCodecUtils.encode((Codec)DataComponentPatch.CODEC, (HolderLookup.Provider)registries, (Object)this.componentPatch).orElse(new CompoundTag()));
    }

    protected void read(CompoundTag compound, HolderLookup.Provider registries, boolean clientPacket) {
        super.read(compound, registries, clientPacket);
        this.capacityEnchantLevel = compound.getInt("CapacityEnchantment");
        this.componentPatch = CatnipCodecUtils.decode((Codec)DataComponentPatch.CODEC, (HolderLookup.Provider)registries, (Tag)compound.getCompound("Components")).orElse(DataComponentPatch.EMPTY);
    }

    public void setCapacityEnchantLevel(int capacityEnchantLevel) {
        this.capacityEnchantLevel = capacityEnchantLevel;
        this.tank.getPrimaryHandler().setCapacity(this.tank.baseCapacity + this.tank.capacityAddition * capacityEnchantLevel);
    }

    public void setComponentPatch(DataComponentPatch componentPatch) {
        this.componentPatch = componentPatch;
        Optional content = componentPatch.get(CDGDataComponents.FLUID_CONTENTS);
        if (content == null || content.isEmpty()) {
            return;
        }
        this.tank.getPrimaryHandler().setFluid(((SimpleFluidContent)content.get()).copy());
    }

    public DataComponentPatch getComponentPatch() {
        return this.componentPatch;
    }

    public static class CapacityEnchantedFluidTankBehaviour
    extends SmartFluidTankBehaviour {
        int capacityAddition;
        int baseCapacity;

        public CapacityEnchantedFluidTankBehaviour(BehaviourType<SmartFluidTankBehaviour> type, SmartBlockEntity be, int tanks, int tankCapacity, boolean enforceVariety, int capacityAddition) {
            super(type, be, tanks, tankCapacity, enforceVariety);
            this.capacityAddition = capacityAddition;
            this.baseCapacity = tankCapacity;
        }

        public static CapacityEnchantedFluidTankBehaviour single(SmartBlockEntity be, int capacity, int capacityAddition) {
            return new CapacityEnchantedFluidTankBehaviour((BehaviourType<SmartFluidTankBehaviour>)TYPE, be, 1, capacity, false, capacityAddition);
        }

        public void read(CompoundTag compound, HolderLookup.Provider registries, boolean clientPacket) {
            super.read(compound, registries, clientPacket);
            if (compound.contains("CapacityEnchantment")) {
                this.getPrimaryHandler().setCapacity(this.baseCapacity + compound.getInt("CapacityEnchantment") * this.capacityAddition);
            }
        }
    }
}

