/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create;

import com.mojang.blaze3d.platform.InputConstants;
import java.util.function.BiConsumer;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.RegisterKeyMappingsEvent;
import net.neoforged.neoforge.client.settings.KeyModifier;
import org.lwjgl.glfw.GLFW;

@EventBusSubscriber(value={Dist.CLIENT})
public enum AllKeys {
    TOOL_MENU("toolmenu", 342, "Focus Schematic Overlay"),
    ACTIVATE_TOOL(341),
    TOOLBELT("toolbelt", 342, "Access Nearby Toolboxes"),
    ROTATE_MENU("rotate_menu", -1, "Open Block Rotation Menu");

    private KeyMapping keybind;
    private final String description;
    private final String translation;
    private final int key;
    private final boolean modifiable;

    private AllKeys(int defaultKey) {
        this("", defaultKey, "");
    }

    private AllKeys(String description, int defaultKey, String translation) {
        this.description = "create.keyinfo." + description;
        this.key = defaultKey;
        this.modifiable = !description.isEmpty();
        this.translation = translation;
    }

    public static void provideLang(BiConsumer<String, String> consumer) {
        for (AllKeys key : AllKeys.values()) {
            if (!key.modifiable) continue;
            consumer.accept(key.description, key.translation);
        }
    }

    @SubscribeEvent
    public static void register(RegisterKeyMappingsEvent event) {
        for (AllKeys key : AllKeys.values()) {
            key.keybind = new KeyMapping(key.description, key.key, "Create");
            if (!key.modifiable) continue;
            event.register(key.keybind);
        }
    }

    public KeyMapping getKeybind() {
        return this.keybind;
    }

    public boolean isPressed() {
        if (!this.modifiable) {
            return AllKeys.isKeyDown(this.key);
        }
        return this.keybind.isDown();
    }

    public String getBoundKey() {
        return this.keybind.getTranslatedKeyMessage().getString().toUpperCase();
    }

    public boolean doesModifierAndCodeMatch(int code) {
        boolean codeMatches = code == this.keybind.getKey().getValue();
        KeyModifier modifier = this.keybind.getKeyModifier();
        boolean modifierMatches = modifier == KeyModifier.NONE ? true : KeyModifier.getActiveModifiers().contains(modifier);
        return codeMatches && modifierMatches;
    }

    public static boolean isKeyDown(int key) {
        return InputConstants.isKeyDown((long)Minecraft.getInstance().getWindow().getWindow(), (int)key);
    }

    public static boolean isMouseButtonDown(int button) {
        return GLFW.glfwGetMouseButton((long)Minecraft.getInstance().getWindow().getWindow(), (int)button) == 1;
    }

    public static boolean ctrlDown() {
        return Screen.hasControlDown();
    }

    public static boolean shiftDown() {
        return Screen.hasShiftDown();
    }

    public static boolean altDown() {
        return Screen.hasAltDown();
    }
}

