/*
 * Decompiled with CFR 0.152.
 */
package com.leclowndu93150.cosmeticcorpsecompat.mixin;

import com.leclowndu93150.cosmeticcorpsecompat.CosmeticArmorDeathEventHandler;
import de.maxhenkel.corpse.entities.CorpseEntity;
import de.maxhenkel.corpse.gui.CorpseAdditionalContainer;
import de.maxhenkel.corpse.gui.CorpseInventoryContainer;
import java.util.UUID;
import lain.mods.cos.api.CosArmorAPI;
import lain.mods.cos.api.inventory.CAStacksBase;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={CorpseInventoryContainer.class, CorpseAdditionalContainer.class})
public abstract class CosmeticArmorCorpseMixin {
    private Player cachedPlayer;

    @Inject(method={"<init>"}, at={@At(value="TAIL")})
    private void onInit(int id, Inventory playerInventory, CorpseEntity corpse, boolean editable, boolean history, CallbackInfo ci) {
        if (playerInventory != null) {
            this.cachedPlayer = playerInventory.player;
        }
    }

    @Inject(method={"transferItems"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    private void transferItemsToCosmeticArmor(CallbackInfo ci) {
        block5: {
            boolean isAdditional;
            CAStacksBase cosArmorInventory;
            CosmeticArmorCorpseMixin container;
            block4: {
                int i;
                container = this;
                if (!this.cachedPlayer.isAlive()) {
                    return;
                }
                UUID playerUUID = this.cachedPlayer.getUUID();
                cosArmorInventory = CosArmorAPI.getCAStacks((UUID)playerUUID);
                boolean isCorpseInv = container instanceof CorpseInventoryContainer;
                isAdditional = container instanceof CorpseAdditionalContainer;
                if (!isCorpseInv) break block4;
                CorpseInventoryContainer corpseContainer = (CorpseInventoryContainer)container;
                for (i = 0; i < corpseContainer.slots.size() && i < corpseContainer.getInventorySize(); ++i) {
                    Slot slot = corpseContainer.getSlot(i);
                    ItemStack stack = slot.getItem();
                    if (!this.isCosmeticArmorItem(stack)) continue;
                    int cosmeticSlot = this.getCosmeticSlotIndex(stack);
                    boolean isSkinArmor = this.isSkinArmorItem(stack);
                    stack.remove(CosmeticArmorDeathEventHandler.COSMETIC_ARMOR_COMPONENT.get());
                    stack.remove(CosmeticArmorDeathEventHandler.SLOT_INDEX_COMPONENT.get());
                    stack.remove(CosmeticArmorDeathEventHandler.SKIN_ARMOR_COMPONENT.get());
                    cosArmorInventory.setStackInSlot(cosmeticSlot, stack);
                    cosArmorInventory.setSkinArmor(cosmeticSlot, isSkinArmor);
                    slot.set(ItemStack.EMPTY);
                }
                for (i = 0; i < corpseContainer.getCorpse().getDeath().getAdditionalItems().size(); ++i) {
                    ItemStack stack = (ItemStack)corpseContainer.getCorpse().getDeath().getAdditionalItems().get(i);
                    if (!this.isCosmeticArmorItem(stack)) continue;
                    int cosmeticSlot = this.getCosmeticSlotIndex(stack);
                    boolean isSkinArmor = this.isSkinArmorItem(stack);
                    stack.remove(CosmeticArmorDeathEventHandler.COSMETIC_ARMOR_COMPONENT.get());
                    stack.remove(CosmeticArmorDeathEventHandler.SLOT_INDEX_COMPONENT.get());
                    stack.remove(CosmeticArmorDeathEventHandler.SKIN_ARMOR_COMPONENT.get());
                    cosArmorInventory.setStackInSlot(cosmeticSlot, stack);
                    cosArmorInventory.setSkinArmor(cosmeticSlot, isSkinArmor);
                    corpseContainer.getCorpse().getDeath().getAdditionalItems().set(i, (Object)ItemStack.EMPTY);
                }
                break block5;
            }
            if (!isAdditional) break block5;
            CorpseAdditionalContainer additionalContainer = (CorpseAdditionalContainer)container;
            for (int i = 0; i < additionalContainer.getInventorySize(); ++i) {
                ItemStack stack;
                Slot slot = additionalContainer.getSlot(i);
                if (slot == null || !this.isCosmeticArmorItem(stack = slot.getItem())) continue;
                int cosmeticSlot = this.getCosmeticSlotIndex(stack);
                boolean isSkinArmor = this.isSkinArmorItem(stack);
                stack.remove(CosmeticArmorDeathEventHandler.COSMETIC_ARMOR_COMPONENT.get());
                stack.remove(CosmeticArmorDeathEventHandler.SLOT_INDEX_COMPONENT.get());
                stack.remove(CosmeticArmorDeathEventHandler.SKIN_ARMOR_COMPONENT.get());
                cosArmorInventory.setStackInSlot(cosmeticSlot, stack);
                cosArmorInventory.setSkinArmor(cosmeticSlot, isSkinArmor);
                slot.set(ItemStack.EMPTY);
            }
        }
    }

    @Unique
    private boolean isCosmeticArmorItem(ItemStack stack) {
        if (stack.isEmpty()) {
            return false;
        }
        Boolean isCosmeticArmor = (Boolean)stack.get(CosmeticArmorDeathEventHandler.COSMETIC_ARMOR_COMPONENT.get());
        return isCosmeticArmor != null && isCosmeticArmor != false;
    }

    @Unique
    private int getCosmeticSlotIndex(ItemStack stack) {
        if (stack.isEmpty()) {
            return 0;
        }
        Integer slotIndex = (Integer)stack.get(CosmeticArmorDeathEventHandler.SLOT_INDEX_COMPONENT.get());
        return slotIndex != null ? slotIndex : 0;
    }

    @Unique
    private boolean isSkinArmorItem(ItemStack stack) {
        if (stack.isEmpty()) {
            return false;
        }
        Boolean isSkinArmor = (Boolean)stack.get(CosmeticArmorDeathEventHandler.SKIN_ARMOR_COMPONENT.get());
        return isSkinArmor != null && isSkinArmor != false;
    }
}

