/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftserverzone.weaponmaster.setup.networking.server.positions;

import com.minecraftserverzone.weaponmaster.setup.configs.ConfigHolder;
import com.minecraftserverzone.weaponmaster.setup.helper.ModUtils;
import com.minecraftserverzone.weaponmaster.setup.networking.Networking;
import com.minecraftserverzone.weaponmaster.setup.networking.client.positions.PositionsCPacket;
import com.minecraftserverzone.weaponmaster.setup.networking.server.positions.PositionsSPacket;
import com.minecraftserverzone.weaponmaster.setup.playerdata.IPlayerData;
import com.minecraftserverzone.weaponmaster.setup.playerdata.PlayerData;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.apache.commons.lang3.math.NumberUtils;

public class ServerPayloadHandler {
    public static void handleData(PositionsSPacket data, IPayloadContext context) {
        ServerPayloadHandler.playerChanged(data, context.player());
        context.enqueueWork(() -> ServerPayloadHandler.playerChanged(data, context.player())).exceptionally(e -> {
            context.disconnect((Component)Component.translatable((String)"weaponmaster_ydm.networking.failed.server", (Object[])new Object[]{e.getMessage()}));
            return null;
        });
    }

    public static void playerChanged(PositionsSPacket packetdata, Player sender) {
        String[] s;
        PlayerData data;
        assert (sender.level() != null);
        if (!sender.level().isClientSide() && (data = ((IPlayerData)sender).getPlayerData()) != null && packetdata.value() != null && (s = ModUtils.splitString(packetdata.value(), ",")) != null) {
            int i;
            int[] value = new int[s.length];
            Object valueText = "";
            for (i = 0; i < s.length; ++i) {
                if (!NumberUtils.isCreatable((String)s[i])) continue;
                value[i] = NumberUtils.createInteger((String)s[i]);
                valueText = ModUtils.stringExist((String)valueText) ? (String)valueText + "," + value[i] : (String)valueText + value[i];
            }
            data.positions = value;
            if (!((Boolean)ConfigHolder.COMMON.CAN_CHANGE_POS_AND_ROT.get()).booleanValue() && ConfigHolder.COMMON.positions != null) {
                for (i = 0; i < ConfigHolder.COMMON.positions.length; ++i) {
                    data.positions[i] = (Integer)ConfigHolder.COMMON.positions[i].get();
                }
            }
            for (Player sp : sender.level().players()) {
                Networking.sendToClient(new PositionsCPacket((String)valueText, false, sender.getStringUUID()), (ServerPlayer)sp);
            }
        }
    }
}

