/*
 * Decompiled with CFR 0.152.
 */
package com.cerbon.cerbons_api.api.multipart_entities.util;

import com.cerbon.cerbons_api.api.multipart_entities.entity.MutableBox;
import com.cerbon.cerbons_api.api.multipart_entities.util.OrientedBox;
import com.cerbon.cerbons_api.mixin.multipart_entities.InvokerArrayVoxelShape;
import com.google.common.collect.Iterators;
import it.unimi.dsi.fastutil.doubles.DoubleArrayList;
import it.unimi.dsi.fastutil.doubles.DoubleList;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BitSetDiscreteVoxelShape;
import net.minecraft.world.phys.shapes.DiscreteVoxelShape;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CompoundOrientedBox
extends AABB
implements Iterable<OrientedBox> {
    private final Collection<OrientedBox> boxes;
    private VoxelShape cached;
    @Nullable
    private final MutableBox overrideBox;

    public CompoundOrientedBox(AABB bounds, Collection<OrientedBox> boxes, MutableBox overrideBox) {
        this(bounds.minX, bounds.minY, bounds.minZ, bounds.maxX, bounds.maxY, bounds.maxZ, boxes, overrideBox);
    }

    public CompoundOrientedBox(double minX, double minY, double minZ, double maxX, double maxY, double maxZ, Collection<OrientedBox> boxes, @Nullable MutableBox overrideBox) {
        super(minX, minY, minZ, maxX, maxY, maxZ);
        this.boxes = boxes;
        this.overrideBox = overrideBox;
    }

    private CompoundOrientedBox(double minX, double minY, double minZ, double maxX, double maxY, double maxZ, Collection<OrientedBox> boxes, VoxelShape cached, @Nullable MutableBox overrideBox) {
        super(minX, minY, minZ, maxX, maxY, maxZ);
        this.boxes = boxes;
        this.cached = cached;
        this.overrideBox = overrideBox;
    }

    @NotNull
    public AABB inflate(double x, double y, double z) {
        ObjectArrayList orientedBoxes = new ObjectArrayList(this.boxes.size());
        for (OrientedBox box : this.boxes) {
            orientedBoxes.add(box.expand(x, y, z));
        }
        MutableBox overrideBox = null;
        if (this.overrideBox != null) {
            overrideBox = new MutableBox(this.overrideBox.getBox().inflate(x, y, z));
        }
        if (this.cached != null) {
            return new CompoundOrientedBox(this.minX - x, this.minY - y, this.minZ - z, this.maxX + x, this.maxY + y, this.maxZ + z, (Collection<OrientedBox>)orientedBoxes, this.cached.move(x, y, z), overrideBox);
        }
        return new CompoundOrientedBox(this.minX - x, this.minY - y, this.minZ - z, this.maxX + x, this.maxY + y, this.maxZ + z, (Collection<OrientedBox>)orientedBoxes, overrideBox);
    }

    @NotNull
    public AABB move(double x, double y, double z) {
        ObjectArrayList orientedBoxes = new ObjectArrayList(this.boxes.size());
        for (OrientedBox box : this.boxes) {
            orientedBoxes.add(box.offset(x, y, z));
        }
        MutableBox overrideBox = null;
        if (this.overrideBox != null) {
            overrideBox = new MutableBox(this.overrideBox.getBox().move(x, y, z));
        }
        if (this.cached != null) {
            return new CompoundOrientedBox(this.minX + x, this.minY + y, this.minZ + z, this.maxX + x, this.maxY + y, this.maxZ + z, (Collection<OrientedBox>)orientedBoxes, this.cached.move(x, y, z), overrideBox);
        }
        return new CompoundOrientedBox(this.minX + x, this.minY + y, this.minZ + z, this.maxX + x, this.maxY + y, this.maxZ + z, (Collection<OrientedBox>)orientedBoxes, overrideBox);
    }

    @NotNull
    public AABB move(BlockPos blockPos) {
        return this.move(blockPos.getX(), blockPos.getY(), blockPos.getZ());
    }

    @NotNull
    public Optional<Vec3> clip(@NotNull Vec3 min, @NotNull Vec3 max) {
        double t = Double.MAX_VALUE;
        for (OrientedBox box : this.boxes) {
            double tmp = box.raycast(min, max);
            if (tmp == -1.0) continue;
            t = Math.min(t, tmp);
        }
        if (t != Double.MAX_VALUE) {
            double d = max.x - min.x;
            double e = max.y - min.y;
            double f = max.z - min.z;
            return Optional.of(min.add(t * d, t * e, t * f));
        }
        return Optional.empty();
    }

    @Override
    @NotNull
    public Iterator<OrientedBox> iterator() {
        return Iterators.unmodifiableIterator(this.boxes.iterator());
    }

    public boolean intersects(double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
        return this.intersects(new AABB(minX, minY, minZ, maxX, maxY, maxZ));
    }

    public boolean intersects(@NotNull AABB box) {
        Vec3[] vertices = OrientedBox.getVertices(box);
        for (OrientedBox orientedBox : this.boxes) {
            if (!orientedBox.intersects(vertices)) continue;
            return true;
        }
        return false;
    }

    public VoxelShape toVoxelShape() {
        if (this.cached != null) {
            return this.cached;
        }
        if (this.overrideBox != null) {
            this.cached = Shapes.create((AABB)this.overrideBox.getBox());
            return this.cached;
        }
        double minX = this.min(Direction.Axis.X) + 1.0E-4;
        double minY = this.min(Direction.Axis.Y) + 1.0E-4;
        double minZ = this.min(Direction.Axis.Z) + 1.0E-4;
        double deltaX = this.max(Direction.Axis.X) - minX;
        double deltaY = this.max(Direction.Axis.Y) - minY;
        double deltaZ = this.max(Direction.Axis.Z) - minZ;
        double resolution = 4.0;
        int xResolution = (int)Math.ceil(deltaX * resolution + 1.0E-4);
        int yResolution = (int)Math.ceil(deltaY * resolution + 1.0E-4);
        int zResolution = (int)Math.ceil(deltaZ * resolution + 1.0E-4);
        BitSetDiscreteVoxelShape bitSet = new BitSetDiscreteVoxelShape(xResolution, yResolution, zResolution);
        for (int i = 0; i < xResolution; ++i) {
            double x = minX + (double)i / resolution;
            for (int j = 0; j < zResolution; ++j) {
                double z = minZ + (double)j / resolution;
                for (int k = 0; k < yResolution; ++k) {
                    double y = minY + (double)k / resolution;
                    AABB box = new AABB(x, y, z, x + 0.9999 / (double)xResolution, y + 0.9999 / (double)yResolution, z + 0.9999 / (double)zResolution);
                    if (!this.intersects(box)) continue;
                    bitSet.fill(i, k, j);
                }
            }
        }
        DoubleArrayList xPoints = new DoubleArrayList(xResolution + 1);
        for (int i = 0; i < xResolution + 1; ++i) {
            xPoints.add(minX + (double)i / resolution);
        }
        DoubleArrayList yPoints = new DoubleArrayList(yResolution + 1);
        for (int i = 0; i < yResolution + 1; ++i) {
            yPoints.add(minY + (double)i / resolution);
        }
        DoubleArrayList zPoints = new DoubleArrayList(zResolution + 1);
        for (int i = 0; i < zResolution + 1; ++i) {
            zPoints.add(minZ + (double)i / resolution);
        }
        this.cached = InvokerArrayVoxelShape.init((DiscreteVoxelShape)bitSet, (DoubleList)xPoints, (DoubleList)yPoints, (DoubleList)zPoints);
        return this.cached;
    }

    public boolean contains(double x, double y, double z) {
        for (OrientedBox box : this.boxes) {
            if (!box.contains(x, y, z)) continue;
            return true;
        }
        return false;
    }

    public CompoundOrientedBox withBounds(AABB bounds) {
        return new CompoundOrientedBox(bounds, (Collection<OrientedBox>)new ObjectArrayList(this.boxes), this.overrideBox);
    }

    public double calculateMaxDistance(Direction.Axis axis, VoxelShape voxelShape, double maxDist) {
        for (AABB boundingBox : this.toVoxelShape().toAabbs()) {
            maxDist = voxelShape.collide(axis, boundingBox, maxDist);
            if (!(Math.abs(maxDist) < 1.0E-4)) continue;
            return 0.0;
        }
        return maxDist;
    }
}

