/*
 * Decompiled with CFR 0.152.
 */
package net.nuclearteam.createnuclear.foundation.utility;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import org.apache.commons.lang3.StringUtils;
import org.joml.Matrix4f;

public class TextUtils {
    public static String titleCaseConversion(String inputString) {
        if (StringUtils.isBlank((CharSequence)inputString)) {
            return "";
        }
        if (StringUtils.length((CharSequence)inputString) == 1) {
            return inputString.toUpperCase();
        }
        inputString = inputString.replaceAll("_", " ");
        StringBuffer resultPlaceHolder = new StringBuffer(inputString.length());
        Stream.of(inputString.split(" ")).forEach(stringPart -> {
            if (stringPart.length() > 1) {
                resultPlaceHolder.append(stringPart.substring(0, 1).toUpperCase()).append(stringPart.substring(1).toLowerCase());
            } else {
                resultPlaceHolder.append(stringPart.toUpperCase());
            }
            resultPlaceHolder.append(" ");
        });
        return StringUtils.trim((String)resultPlaceHolder.toString());
    }

    public static void renderMultilineDebugText(PoseStack poseStack, MultiBufferSource buffer, int packedLight, double baseY, boolean transparent, String ... lines) {
        double y = baseY + (double)lines.length / 4.0;
        for (String line : lines) {
            TextUtils.renderDebugText(poseStack, buffer, packedLight, y, transparent, line);
            y -= 0.25;
        }
    }

    public static void renderDebugText(PoseStack poseStack, MultiBufferSource pBuffer, int pPackedLight, double y, boolean transparent, String text) {
        poseStack.pushPose();
        poseStack.translate(0.0, y, 0.0);
        poseStack.mulPose(Minecraft.getInstance().getBlockEntityRenderDispatcher().camera.rotation());
        poseStack.scale(-0.025f, -0.025f, 0.025f);
        Matrix4f matrix4f = poseStack.last().pose();
        float f1 = Minecraft.getInstance().options.getBackgroundOpacity(0.25f);
        int j = (int)(f1 * 255.0f) << 24;
        Font font = Minecraft.getInstance().font;
        float f2 = -font.width(text) / 2;
        font.drawInBatch(text, f2, 0.0f, 0x20FFFFFF, false, matrix4f, pBuffer, transparent ? Font.DisplayMode.SEE_THROUGH : Font.DisplayMode.NORMAL, j, pPackedLight);
        if (transparent) {
            font.drawInBatch(text, f2, 0.0f, -1, false, matrix4f, pBuffer, Font.DisplayMode.NORMAL, 0, pPackedLight);
        }
        poseStack.popPose();
    }

    public static Component translateWithFormatting(String key, Object ... args) {
        MutableComponent base = Component.translatable((String)key, (Object[])args);
        StringBuilder partsStringBuilder = new StringBuilder();
        base.visit((style, part) -> {
            partsStringBuilder.append(part);
            return Optional.empty();
        }, Style.EMPTY);
        return Component.literal((String)partsStringBuilder.toString());
    }

    public static String formatInt(int num) {
        return TextUtils.formatInt(num, ",");
    }

    public static String formatInt(int num, String separator) {
        String raw = String.valueOf(num);
        if (raw.length() <= 3) {
            return raw;
        }
        int start = raw.length() % 3;
        StringBuilder out = new StringBuilder(raw.length() + raw.length() / 3 * separator.length());
        out.append(raw, 0, start);
        for (int i = 0; i < raw.length() / 3; ++i) {
            if (i != 0 || start != 0) {
                out.append(separator);
            }
            out.append(raw, i * 3 + start, i * 3 + start + 3);
        }
        return out.toString();
    }

    public static String leftPad(String s, char c, int width) {
        if (s.length() >= width) {
            return s;
        }
        return String.valueOf(c).repeat(width - s.length()) + s;
    }
}

