/*
 * Decompiled with CFR 0.152.
 */
package net.nuclearteam.createnuclear.content.multiblock.bluePrintItem;

import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.nuclearteam.createnuclear.CNDataComponents;
import net.nuclearteam.createnuclear.CNItems;
import net.nuclearteam.createnuclear.content.multiblock.bluePrintItem.PatternData;
import net.nuclearteam.createnuclear.content.multiblock.bluePrintItem.ReactorBluePrintData;
import net.nuclearteam.createnuclear.content.multiblock.bluePrintItem.ReactorBluePrintMenu;
import org.jetbrains.annotations.Nullable;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class ReactorBluePrintItem
extends Item
implements MenuProvider {
    public ReactorBluePrintItem(Item.Properties properties) {
        super(properties);
    }

    public Component getDisplayName() {
        return Component.translatable((String)"reactor.item.gui.name");
    }

    @Nullable
    public AbstractContainerMenu createMenu(int id, Inventory inv, Player player) {
        ItemStack heldItem = player.getMainHandItem();
        return ReactorBluePrintMenu.create(id, inv, heldItem);
    }

    public InteractionResult useOn(UseOnContext context) {
        if (context.getPlayer() == null) {
            return InteractionResult.PASS;
        }
        return this.use(context.getLevel(), context.getPlayer(), context.getHand()).getResult();
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player player, InteractionHand hand) {
        ItemStack heldItem = player.getItemInHand(hand);
        if (!player.isShiftKeyDown() && hand == InteractionHand.MAIN_HAND) {
            if (!world.isClientSide && player instanceof ServerPlayer) {
                player.openMenu((MenuProvider)this, buf -> ItemStack.STREAM_CODEC.encode(buf, (Object)heldItem));
            }
            return InteractionResultHolder.success((Object)heldItem);
        }
        if (player.isShiftKeyDown() && hand == InteractionHand.MAIN_HAND) {
            if (!world.isClientSide && player instanceof ServerPlayer) {
                player.openMenu((MenuProvider)this, buf -> ItemStack.STREAM_CODEC.encode(buf, (Object)heldItem));
            }
            return InteractionResultHolder.success((Object)heldItem);
        }
        return InteractionResultHolder.pass((Object)heldItem);
    }

    public static ItemStackHandler getItemStorage(ItemStack stack) {
        int slotCount = 57;
        ItemStackHandler inventory = new ItemStackHandler(57);
        if (stack.getItem() != CNItems.REACTOR_BLUEPRINT.get()) {
            throw new IllegalArgumentException("Cannot get configured items from non-blueprint item: " + String.valueOf(stack));
        }
        ReactorBluePrintData data = (ReactorBluePrintData)stack.get(CNDataComponents.REACTOR_BLUE_PRINT_DATA);
        if (data == null || data.pattern().length != 57) {
            return inventory;
        }
        PatternData[] pattern = data.pattern();
        for (int i = 0; i < 57; ++i) {
            inventory.setStackInSlot(i, pattern[i].stack());
        }
        return inventory;
    }
}

